/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.networkmanager.model.SegmentActionServiceInsertion;
import software.amazon.awssdk.services.networkmanager.model.SendViaMode;
import software.amazon.awssdk.services.networkmanager.model.Via;
import software.amazon.awssdk.services.networkmanager.model.WhenSentTo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceInsertionAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceInsertionAction> {
    private static final SdkField<String> ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Action").getter(ServiceInsertionAction.getter(ServiceInsertionAction::actionAsString)).setter(ServiceInsertionAction.setter(Builder::action)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()}).build();
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(ServiceInsertionAction.getter(ServiceInsertionAction::modeAsString)).setter(ServiceInsertionAction.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<WhenSentTo> WHEN_SENT_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("WhenSentTo").getter(ServiceInsertionAction.getter(ServiceInsertionAction::whenSentTo)).setter(ServiceInsertionAction.setter(Builder::whenSentTo)).constructor(WhenSentTo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WhenSentTo").build()}).build();
    private static final SdkField<Via> VIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Via").getter(ServiceInsertionAction.getter(ServiceInsertionAction::via)).setter(ServiceInsertionAction.setter(Builder::via)).constructor(Via::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Via").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD, MODE_FIELD, WHEN_SENT_TO_FIELD, VIA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceInsertionAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String action;
    private final String mode;
    private final WhenSentTo whenSentTo;
    private final Via via;

    private ServiceInsertionAction(BuilderImpl builder) {
        this.action = builder.action;
        this.mode = builder.mode;
        this.whenSentTo = builder.whenSentTo;
        this.via = builder.via;
    }

    public final SegmentActionServiceInsertion action() {
        return SegmentActionServiceInsertion.fromValue(this.action);
    }

    public final String actionAsString() {
        return this.action;
    }

    public final SendViaMode mode() {
        return SendViaMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final WhenSentTo whenSentTo() {
        return this.whenSentTo;
    }

    public final Via via() {
        return this.via;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.whenSentTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.via());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceInsertionAction)) {
            return false;
        }
        ServiceInsertionAction other = (ServiceInsertionAction)obj;
        return Objects.equals(this.actionAsString(), other.actionAsString()) && Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.whenSentTo(), other.whenSentTo()) && Objects.equals(this.via(), other.via());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceInsertionAction").add("Action", (Object)this.actionAsString()).add("Mode", (Object)this.modeAsString()).add("WhenSentTo", (Object)this.whenSentTo()).add("Via", (Object)this.via()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Action": {
                return Optional.ofNullable(clazz.cast(this.actionAsString()));
            }
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "WhenSentTo": {
                return Optional.ofNullable(clazz.cast(this.whenSentTo()));
            }
            case "Via": {
                return Optional.ofNullable(clazz.cast(this.via()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Action", ACTION_FIELD);
        map.put("Mode", MODE_FIELD);
        map.put("WhenSentTo", WHEN_SENT_TO_FIELD);
        map.put("Via", VIA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceInsertionAction, T> g) {
        return obj -> g.apply((ServiceInsertionAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String action;
        private String mode;
        private WhenSentTo whenSentTo;
        private Via via;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceInsertionAction model) {
            this.action(model.action);
            this.mode(model.mode);
            this.whenSentTo(model.whenSentTo);
            this.via(model.via);
        }

        public final String getAction() {
            return this.action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(SegmentActionServiceInsertion action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(SendViaMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final WhenSentTo.Builder getWhenSentTo() {
            return this.whenSentTo != null ? this.whenSentTo.toBuilder() : null;
        }

        public final void setWhenSentTo(WhenSentTo.BuilderImpl whenSentTo) {
            this.whenSentTo = whenSentTo != null ? whenSentTo.build() : null;
        }

        @Override
        public final Builder whenSentTo(WhenSentTo whenSentTo) {
            this.whenSentTo = whenSentTo;
            return this;
        }

        public final Via.Builder getVia() {
            return this.via != null ? this.via.toBuilder() : null;
        }

        public final void setVia(Via.BuilderImpl via) {
            this.via = via != null ? via.build() : null;
        }

        @Override
        public final Builder via(Via via) {
            this.via = via;
            return this;
        }

        public ServiceInsertionAction build() {
            return new ServiceInsertionAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceInsertionAction> {
        public Builder action(String var1);

        public Builder action(SegmentActionServiceInsertion var1);

        public Builder mode(String var1);

        public Builder mode(SendViaMode var1);

        public Builder whenSentTo(WhenSentTo var1);

        default public Builder whenSentTo(Consumer<WhenSentTo.Builder> whenSentTo) {
            return this.whenSentTo((WhenSentTo)((WhenSentTo.Builder)WhenSentTo.builder().applyMutation(whenSentTo)).build());
        }

        public Builder via(Via var1);

        default public Builder via(Consumer<Via.Builder> via) {
            return this.via((Via)((Via.Builder)Via.builder().applyMutation(via)).build());
        }
    }
}

