/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.networkmanager.model.ExternalRegionCodeListCopier;
import software.amazon.awssdk.services.networkmanager.model.NetworkManagerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateDirectConnectGatewayAttachmentRequest
extends NetworkManagerRequest
implements ToCopyableBuilder<Builder, UpdateDirectConnectGatewayAttachmentRequest> {
    private static final SdkField<String> ATTACHMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachmentId").getter(UpdateDirectConnectGatewayAttachmentRequest.getter(UpdateDirectConnectGatewayAttachmentRequest::attachmentId)).setter(UpdateDirectConnectGatewayAttachmentRequest.setter(Builder::attachmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("attachmentId").build()}).build();
    private static final SdkField<List<String>> EDGE_LOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EdgeLocations").getter(UpdateDirectConnectGatewayAttachmentRequest.getter(UpdateDirectConnectGatewayAttachmentRequest::edgeLocations)).setter(UpdateDirectConnectGatewayAttachmentRequest.setter(Builder::edgeLocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EdgeLocations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHMENT_ID_FIELD, EDGE_LOCATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateDirectConnectGatewayAttachmentRequest.memberNameToFieldInitializer();
    private final String attachmentId;
    private final List<String> edgeLocations;

    private UpdateDirectConnectGatewayAttachmentRequest(BuilderImpl builder) {
        super(builder);
        this.attachmentId = builder.attachmentId;
        this.edgeLocations = builder.edgeLocations;
    }

    public final String attachmentId() {
        return this.attachmentId;
    }

    public final boolean hasEdgeLocations() {
        return this.edgeLocations != null && !(this.edgeLocations instanceof SdkAutoConstructList);
    }

    public final List<String> edgeLocations() {
        return this.edgeLocations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.attachmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEdgeLocations() ? this.edgeLocations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDirectConnectGatewayAttachmentRequest)) {
            return false;
        }
        UpdateDirectConnectGatewayAttachmentRequest other = (UpdateDirectConnectGatewayAttachmentRequest)((Object)obj);
        return Objects.equals(this.attachmentId(), other.attachmentId()) && this.hasEdgeLocations() == other.hasEdgeLocations() && Objects.equals(this.edgeLocations(), other.edgeLocations());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateDirectConnectGatewayAttachmentRequest").add("AttachmentId", (Object)this.attachmentId()).add("EdgeLocations", this.hasEdgeLocations() ? this.edgeLocations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachmentId": {
                return Optional.ofNullable(clazz.cast(this.attachmentId()));
            }
            case "EdgeLocations": {
                return Optional.ofNullable(clazz.cast(this.edgeLocations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("attachmentId", ATTACHMENT_ID_FIELD);
        map.put("EdgeLocations", EDGE_LOCATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateDirectConnectGatewayAttachmentRequest, T> g) {
        return obj -> g.apply((UpdateDirectConnectGatewayAttachmentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NetworkManagerRequest.BuilderImpl
    implements Builder {
        private String attachmentId;
        private List<String> edgeLocations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDirectConnectGatewayAttachmentRequest model) {
            super(model);
            this.attachmentId(model.attachmentId);
            this.edgeLocations(model.edgeLocations);
        }

        public final String getAttachmentId() {
            return this.attachmentId;
        }

        public final void setAttachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
        }

        @Override
        public final Builder attachmentId(String attachmentId) {
            this.attachmentId = attachmentId;
            return this;
        }

        public final Collection<String> getEdgeLocations() {
            if (this.edgeLocations instanceof SdkAutoConstructList) {
                return null;
            }
            return this.edgeLocations;
        }

        public final void setEdgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
        }

        @Override
        public final Builder edgeLocations(Collection<String> edgeLocations) {
            this.edgeLocations = ExternalRegionCodeListCopier.copy(edgeLocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder edgeLocations(String ... edgeLocations) {
            this.edgeLocations(Arrays.asList(edgeLocations));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDirectConnectGatewayAttachmentRequest build() {
            return new UpdateDirectConnectGatewayAttachmentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NetworkManagerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateDirectConnectGatewayAttachmentRequest> {
        public Builder attachmentId(String var1);

        public Builder edgeLocations(Collection<String> var1);

        public Builder edgeLocations(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

