/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkChange;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetRequest;
import software.amazon.awssdk.services.networkmanager.model.GetCoreNetworkChangeSetResponse;

public class GetCoreNetworkChangeSetPublisher
implements SdkPublisher<GetCoreNetworkChangeSetResponse> {
    private final NetworkManagerAsyncClient client;
    private final GetCoreNetworkChangeSetRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetCoreNetworkChangeSetPublisher(NetworkManagerAsyncClient client, GetCoreNetworkChangeSetRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetCoreNetworkChangeSetPublisher(NetworkManagerAsyncClient client, GetCoreNetworkChangeSetRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetCoreNetworkChangeSetResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetCoreNetworkChangeSetResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CoreNetworkChange> coreNetworkChanges() {
        Function<GetCoreNetworkChangeSetResponse, Iterator> getIterator = response -> {
            if (response != null && response.coreNetworkChanges() != null) {
                return response.coreNetworkChanges().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetCoreNetworkChangeSetResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetCoreNetworkChangeSetResponseFetcher
    implements AsyncPageFetcher<GetCoreNetworkChangeSetResponse> {
        private GetCoreNetworkChangeSetResponseFetcher() {
        }

        public boolean hasNextPage(GetCoreNetworkChangeSetResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetCoreNetworkChangeSetResponse> nextPage(GetCoreNetworkChangeSetResponse previousPage) {
            if (previousPage == null) {
                return GetCoreNetworkChangeSetPublisher.this.client.getCoreNetworkChangeSet(GetCoreNetworkChangeSetPublisher.this.firstRequest);
            }
            return GetCoreNetworkChangeSetPublisher.this.client.getCoreNetworkChangeSet((GetCoreNetworkChangeSetRequest)((Object)GetCoreNetworkChangeSetPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

