/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsRequest;
import software.amazon.awssdk.services.networkmanager.model.GetTransitGatewayRegistrationsResponse;
import software.amazon.awssdk.services.networkmanager.model.TransitGatewayRegistration;

public class GetTransitGatewayRegistrationsIterable
implements SdkIterable<GetTransitGatewayRegistrationsResponse> {
    private final NetworkManagerClient client;
    private final GetTransitGatewayRegistrationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetTransitGatewayRegistrationsIterable(NetworkManagerClient client, GetTransitGatewayRegistrationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new GetTransitGatewayRegistrationsResponseFetcher();
    }

    public Iterator<GetTransitGatewayRegistrationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TransitGatewayRegistration> transitGatewayRegistrations() {
        Function<GetTransitGatewayRegistrationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transitGatewayRegistrations() != null) {
                return response.transitGatewayRegistrations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class GetTransitGatewayRegistrationsResponseFetcher
    implements SyncPageFetcher<GetTransitGatewayRegistrationsResponse> {
        private GetTransitGatewayRegistrationsResponseFetcher() {
        }

        public boolean hasNextPage(GetTransitGatewayRegistrationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public GetTransitGatewayRegistrationsResponse nextPage(GetTransitGatewayRegistrationsResponse previousPage) {
            if (previousPage == null) {
                return GetTransitGatewayRegistrationsIterable.this.client.getTransitGatewayRegistrations(GetTransitGatewayRegistrationsIterable.this.firstRequest);
            }
            return GetTransitGatewayRegistrationsIterable.this.client.getTransitGatewayRegistrations((GetTransitGatewayRegistrationsRequest)((Object)GetTransitGatewayRegistrationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

