/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerAsyncClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.AttachmentRoutingPolicyAssociationSummary;
import software.amazon.awssdk.services.networkmanager.model.ListAttachmentRoutingPolicyAssociationsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListAttachmentRoutingPolicyAssociationsResponse;

public class ListAttachmentRoutingPolicyAssociationsPublisher
implements SdkPublisher<ListAttachmentRoutingPolicyAssociationsResponse> {
    private final NetworkManagerAsyncClient client;
    private final ListAttachmentRoutingPolicyAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAttachmentRoutingPolicyAssociationsPublisher(NetworkManagerAsyncClient client, ListAttachmentRoutingPolicyAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAttachmentRoutingPolicyAssociationsPublisher(NetworkManagerAsyncClient client, ListAttachmentRoutingPolicyAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAttachmentRoutingPolicyAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAttachmentRoutingPolicyAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AttachmentRoutingPolicyAssociationSummary> attachmentRoutingPolicyAssociations() {
        Function<ListAttachmentRoutingPolicyAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.attachmentRoutingPolicyAssociations() != null) {
                return response.attachmentRoutingPolicyAssociations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAttachmentRoutingPolicyAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAttachmentRoutingPolicyAssociationsResponseFetcher
    implements AsyncPageFetcher<ListAttachmentRoutingPolicyAssociationsResponse> {
        private ListAttachmentRoutingPolicyAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListAttachmentRoutingPolicyAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAttachmentRoutingPolicyAssociationsResponse> nextPage(ListAttachmentRoutingPolicyAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListAttachmentRoutingPolicyAssociationsPublisher.this.client.listAttachmentRoutingPolicyAssociations(ListAttachmentRoutingPolicyAssociationsPublisher.this.firstRequest);
            }
            return ListAttachmentRoutingPolicyAssociationsPublisher.this.client.listAttachmentRoutingPolicyAssociations((ListAttachmentRoutingPolicyAssociationsRequest)((Object)ListAttachmentRoutingPolicyAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

