/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.networkmanager.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.networkmanager.NetworkManagerClient;
import software.amazon.awssdk.services.networkmanager.internal.UserAgentUtils;
import software.amazon.awssdk.services.networkmanager.model.CoreNetworkPolicyVersion;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsRequest;
import software.amazon.awssdk.services.networkmanager.model.ListCoreNetworkPolicyVersionsResponse;

public class ListCoreNetworkPolicyVersionsIterable
implements SdkIterable<ListCoreNetworkPolicyVersionsResponse> {
    private final NetworkManagerClient client;
    private final ListCoreNetworkPolicyVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCoreNetworkPolicyVersionsIterable(NetworkManagerClient client, ListCoreNetworkPolicyVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCoreNetworkPolicyVersionsResponseFetcher();
    }

    public Iterator<ListCoreNetworkPolicyVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CoreNetworkPolicyVersion> coreNetworkPolicyVersions() {
        Function<ListCoreNetworkPolicyVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.coreNetworkPolicyVersions() != null) {
                return response.coreNetworkPolicyVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCoreNetworkPolicyVersionsResponseFetcher
    implements SyncPageFetcher<ListCoreNetworkPolicyVersionsResponse> {
        private ListCoreNetworkPolicyVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCoreNetworkPolicyVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCoreNetworkPolicyVersionsResponse nextPage(ListCoreNetworkPolicyVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListCoreNetworkPolicyVersionsIterable.this.client.listCoreNetworkPolicyVersions(ListCoreNetworkPolicyVersionsIterable.this.firstRequest);
            }
            return ListCoreNetworkPolicyVersionsIterable.this.client.listCoreNetworkPolicyVersions((ListCoreNetworkPolicyVersionsRequest)((Object)ListCoreNetworkPolicyVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

