/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ActStatus {
    RUNNING("RUNNING"),
    PENDING_CLIENT_ACTION("PENDING_CLIENT_ACTION"),
    PENDING_HUMAN_ACTION("PENDING_HUMAN_ACTION"),
    SUCCEEDED("SUCCEEDED"),
    FAILED("FAILED"),
    TIMED_OUT("TIMED_OUT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ActStatus> VALUE_MAP;
    private final String value;

    private ActStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ActStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ActStatus> knownValues() {
        EnumSet<ActStatus> knownValues = EnumSet.allOf(ActStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ActStatus.class, ActStatus::toString);
    }
}

