/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClientInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClientInfo> {
    private static final SdkField<Integer> COMPATIBILITY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("compatibilityVersion").getter(ClientInfo.getter(ClientInfo::compatibilityVersion)).setter(ClientInfo.setter(Builder::compatibilityVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compatibilityVersion").build()}).build();
    private static final SdkField<String> SDK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sdkVersion").getter(ClientInfo.getter(ClientInfo::sdkVersion)).setter(ClientInfo.setter(Builder::sdkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sdkVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPATIBILITY_VERSION_FIELD, SDK_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClientInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer compatibilityVersion;
    private final String sdkVersion;

    private ClientInfo(BuilderImpl builder) {
        this.compatibilityVersion = builder.compatibilityVersion;
        this.sdkVersion = builder.sdkVersion;
    }

    public final Integer compatibilityVersion() {
        return this.compatibilityVersion;
    }

    public final String sdkVersion() {
        return this.sdkVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.compatibilityVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.sdkVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientInfo)) {
            return false;
        }
        ClientInfo other = (ClientInfo)obj;
        return Objects.equals(this.compatibilityVersion(), other.compatibilityVersion()) && Objects.equals(this.sdkVersion(), other.sdkVersion());
    }

    public final String toString() {
        return ToString.builder((String)"ClientInfo").add("CompatibilityVersion", (Object)this.compatibilityVersion()).add("SdkVersion", (Object)this.sdkVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "compatibilityVersion": {
                return Optional.ofNullable(clazz.cast(this.compatibilityVersion()));
            }
            case "sdkVersion": {
                return Optional.ofNullable(clazz.cast(this.sdkVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("compatibilityVersion", COMPATIBILITY_VERSION_FIELD);
        map.put("sdkVersion", SDK_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClientInfo, T> g) {
        return obj -> g.apply((ClientInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer compatibilityVersion;
        private String sdkVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientInfo model) {
            this.compatibilityVersion(model.compatibilityVersion);
            this.sdkVersion(model.sdkVersion);
        }

        public final Integer getCompatibilityVersion() {
            return this.compatibilityVersion;
        }

        public final void setCompatibilityVersion(Integer compatibilityVersion) {
            this.compatibilityVersion = compatibilityVersion;
        }

        @Override
        public final Builder compatibilityVersion(Integer compatibilityVersion) {
            this.compatibilityVersion = compatibilityVersion;
            return this;
        }

        public final String getSdkVersion() {
            return this.sdkVersion;
        }

        public final void setSdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
        }

        @Override
        public final Builder sdkVersion(String sdkVersion) {
            this.sdkVersion = sdkVersion;
            return this;
        }

        public ClientInfo build() {
            return new ClientInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClientInfo> {
        public Builder compatibilityVersion(Integer var1);

        public Builder sdkVersion(String var1);
    }
}

