/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.novaact.model.NovaActResponse;
import software.amazon.awssdk.services.novaact.model.WorkflowRunStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowRunResponse
extends NovaActResponse
implements ToCopyableBuilder<Builder, GetWorkflowRunResponse> {
    private static final SdkField<String> WORKFLOW_RUN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowRunArn").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::workflowRunArn)).setter(GetWorkflowRunResponse.setter(Builder::workflowRunArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowRunArn").build()}).build();
    private static final SdkField<String> WORKFLOW_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowRunId").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::workflowRunId)).setter(GetWorkflowRunResponse.setter(Builder::workflowRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowRunId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::statusAsString)).setter(GetWorkflowRunResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedAt").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::startedAt)).setter(GetWorkflowRunResponse.setter(Builder::startedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endedAt").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::endedAt)).setter(GetWorkflowRunResponse.setter(Builder::endedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::modelId)).setter(GetWorkflowRunResponse.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<String> LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("logGroupName").getter(GetWorkflowRunResponse.getter(GetWorkflowRunResponse::logGroupName)).setter(GetWorkflowRunResponse.setter(Builder::logGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logGroupName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_RUN_ARN_FIELD, WORKFLOW_RUN_ID_FIELD, STATUS_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD, MODEL_ID_FIELD, LOG_GROUP_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWorkflowRunResponse.memberNameToFieldInitializer();
    private final String workflowRunArn;
    private final String workflowRunId;
    private final String status;
    private final Instant startedAt;
    private final Instant endedAt;
    private final String modelId;
    private final String logGroupName;

    private GetWorkflowRunResponse(BuilderImpl builder) {
        super(builder);
        this.workflowRunArn = builder.workflowRunArn;
        this.workflowRunId = builder.workflowRunId;
        this.status = builder.status;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.modelId = builder.modelId;
        this.logGroupName = builder.logGroupName;
    }

    public final String workflowRunArn() {
        return this.workflowRunArn;
    }

    public final String workflowRunId() {
        return this.workflowRunId;
    }

    public final WorkflowRunStatus status() {
        return WorkflowRunStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant startedAt() {
        return this.startedAt;
    }

    public final Instant endedAt() {
        return this.endedAt;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final String logGroupName() {
        return this.logGroupName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowRunArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.logGroupName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowRunResponse)) {
            return false;
        }
        GetWorkflowRunResponse other = (GetWorkflowRunResponse)((Object)obj);
        return Objects.equals(this.workflowRunArn(), other.workflowRunArn()) && Objects.equals(this.workflowRunId(), other.workflowRunId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.startedAt(), other.startedAt()) && Objects.equals(this.endedAt(), other.endedAt()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.logGroupName(), other.logGroupName());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkflowRunResponse").add("WorkflowRunArn", (Object)this.workflowRunArn()).add("WorkflowRunId", (Object)this.workflowRunId()).add("Status", (Object)this.statusAsString()).add("StartedAt", (Object)this.startedAt()).add("EndedAt", (Object)this.endedAt()).add("ModelId", (Object)this.modelId()).add("LogGroupName", (Object)this.logGroupName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflowRunArn": {
                return Optional.ofNullable(clazz.cast(this.workflowRunArn()));
            }
            case "workflowRunId": {
                return Optional.ofNullable(clazz.cast(this.workflowRunId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "startedAt": {
                return Optional.ofNullable(clazz.cast(this.startedAt()));
            }
            case "endedAt": {
                return Optional.ofNullable(clazz.cast(this.endedAt()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "logGroupName": {
                return Optional.ofNullable(clazz.cast(this.logGroupName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflowRunArn", WORKFLOW_RUN_ARN_FIELD);
        map.put("workflowRunId", WORKFLOW_RUN_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("logGroupName", LOG_GROUP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowRunResponse, T> g) {
        return obj -> g.apply((GetWorkflowRunResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends NovaActResponse.BuilderImpl
    implements Builder {
        private String workflowRunArn;
        private String workflowRunId;
        private String status;
        private Instant startedAt;
        private Instant endedAt;
        private String modelId;
        private String logGroupName;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowRunResponse model) {
            super(model);
            this.workflowRunArn(model.workflowRunArn);
            this.workflowRunId(model.workflowRunId);
            this.status(model.status);
            this.startedAt(model.startedAt);
            this.endedAt(model.endedAt);
            this.modelId(model.modelId);
            this.logGroupName(model.logGroupName);
        }

        public final String getWorkflowRunArn() {
            return this.workflowRunArn;
        }

        public final void setWorkflowRunArn(String workflowRunArn) {
            this.workflowRunArn = workflowRunArn;
        }

        @Override
        public final Builder workflowRunArn(String workflowRunArn) {
            this.workflowRunArn = workflowRunArn;
            return this;
        }

        public final String getWorkflowRunId() {
            return this.workflowRunId;
        }

        public final void setWorkflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
        }

        @Override
        public final Builder workflowRunId(String workflowRunId) {
            this.workflowRunId = workflowRunId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartedAt() {
            return this.startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return this.endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final String getLogGroupName() {
            return this.logGroupName;
        }

        public final void setLogGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
        }

        @Override
        public final Builder logGroupName(String logGroupName) {
            this.logGroupName = logGroupName;
            return this;
        }

        @Override
        public GetWorkflowRunResponse build() {
            return new GetWorkflowRunResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends NovaActResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowRunResponse> {
        public Builder workflowRunArn(String var1);

        public Builder workflowRunId(String var1);

        public Builder status(String var1);

        public Builder status(WorkflowRunStatus var1);

        public Builder startedAt(Instant var1);

        public Builder endedAt(Instant var1);

        public Builder modelId(String var1);

        public Builder logGroupName(String var1);
    }
}

