/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.novaact.NovaActClient;
import software.amazon.awssdk.services.novaact.internal.UserAgentUtils;
import software.amazon.awssdk.services.novaact.model.ListWorkflowDefinitionsRequest;
import software.amazon.awssdk.services.novaact.model.ListWorkflowDefinitionsResponse;
import software.amazon.awssdk.services.novaact.model.WorkflowDefinitionSummary;

public class ListWorkflowDefinitionsIterable
implements SdkIterable<ListWorkflowDefinitionsResponse> {
    private final NovaActClient client;
    private final ListWorkflowDefinitionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowDefinitionsIterable(NovaActClient client, ListWorkflowDefinitionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkflowDefinitionsResponseFetcher();
    }

    public Iterator<ListWorkflowDefinitionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowDefinitionSummary> workflowDefinitionSummaries() {
        Function<ListWorkflowDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowDefinitionSummaries() != null) {
                return response.workflowDefinitionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowDefinitionsResponseFetcher
    implements SyncPageFetcher<ListWorkflowDefinitionsResponse> {
        private ListWorkflowDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowDefinitionsResponse nextPage(ListWorkflowDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowDefinitionsIterable.this.client.listWorkflowDefinitions(ListWorkflowDefinitionsIterable.this.firstRequest);
            }
            return ListWorkflowDefinitionsIterable.this.client.listWorkflowDefinitions((ListWorkflowDefinitionsRequest)((Object)ListWorkflowDefinitionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

