/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.novaact.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.novaact.NovaActAsyncClient;
import software.amazon.awssdk.services.novaact.internal.UserAgentUtils;
import software.amazon.awssdk.services.novaact.model.ListWorkflowDefinitionsRequest;
import software.amazon.awssdk.services.novaact.model.ListWorkflowDefinitionsResponse;
import software.amazon.awssdk.services.novaact.model.WorkflowDefinitionSummary;

public class ListWorkflowDefinitionsPublisher
implements SdkPublisher<ListWorkflowDefinitionsResponse> {
    private final NovaActAsyncClient client;
    private final ListWorkflowDefinitionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListWorkflowDefinitionsPublisher(NovaActAsyncClient client, ListWorkflowDefinitionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListWorkflowDefinitionsPublisher(NovaActAsyncClient client, ListWorkflowDefinitionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListWorkflowDefinitionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListWorkflowDefinitionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<WorkflowDefinitionSummary> workflowDefinitionSummaries() {
        Function<ListWorkflowDefinitionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.workflowDefinitionSummaries() != null) {
                return response.workflowDefinitionSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListWorkflowDefinitionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListWorkflowDefinitionsResponseFetcher
    implements AsyncPageFetcher<ListWorkflowDefinitionsResponse> {
        private ListWorkflowDefinitionsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowDefinitionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListWorkflowDefinitionsResponse> nextPage(ListWorkflowDefinitionsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowDefinitionsPublisher.this.client.listWorkflowDefinitions(ListWorkflowDefinitionsPublisher.this.firstRequest);
            }
            return ListWorkflowDefinitionsPublisher.this.client.listWorkflowDefinitions((ListWorkflowDefinitionsRequest)((Object)ListWorkflowDefinitionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

