/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComputeModel {
    ECPU("ECPU"),
    OCPU("OCPU"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComputeModel> VALUE_MAP;
    private final String value;

    private ComputeModel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComputeModel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComputeModel> knownValues() {
        EnumSet<ComputeModel> knownValues = EnumSet.allOf(ComputeModel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComputeModel.class, ComputeModel::toString);
    }
}

