/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.odb.model.DataCollectionOptions;
import software.amazon.awssdk.services.odb.model.LicenseModel;
import software.amazon.awssdk.services.odb.model.OdbRequest;
import software.amazon.awssdk.services.odb.model.RequestTagMapCopier;
import software.amazon.awssdk.services.odb.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCloudVmClusterRequest
extends OdbRequest
implements ToCopyableBuilder<Builder, CreateCloudVmClusterRequest> {
    private static final SdkField<String> CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudExadataInfrastructureId").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::cloudExadataInfrastructureId)).setter(CreateCloudVmClusterRequest.setter(Builder::cloudExadataInfrastructureId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudExadataInfrastructureId").build()}).build();
    private static final SdkField<Integer> CPU_CORE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpuCoreCount").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::cpuCoreCount)).setter(CreateCloudVmClusterRequest.setter(Builder::cpuCoreCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuCoreCount").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("displayName").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::displayName)).setter(CreateCloudVmClusterRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()}).build();
    private static final SdkField<String> GI_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("giVersion").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::giVersion)).setter(CreateCloudVmClusterRequest.setter(Builder::giVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("giVersion").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::hostname)).setter(CreateCloudVmClusterRequest.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<List<String>> SSH_PUBLIC_KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sshPublicKeys").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::sshPublicKeys)).setter(CreateCloudVmClusterRequest.setter(Builder::sshPublicKeys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sshPublicKeys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ODB_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("odbNetworkId").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::odbNetworkId)).setter(CreateCloudVmClusterRequest.setter(Builder::odbNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("odbNetworkId").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::clusterName)).setter(CreateCloudVmClusterRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<DataCollectionOptions> DATA_COLLECTION_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataCollectionOptions").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::dataCollectionOptions)).setter(CreateCloudVmClusterRequest.setter(Builder::dataCollectionOptions)).constructor(DataCollectionOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataCollectionOptions").build()}).build();
    private static final SdkField<Double> DATA_STORAGE_SIZE_IN_T_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("dataStorageSizeInTBs").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::dataStorageSizeInTBs)).setter(CreateCloudVmClusterRequest.setter(Builder::dataStorageSizeInTBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataStorageSizeInTBs").build()}).build();
    private static final SdkField<Integer> DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("dbNodeStorageSizeInGBs").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::dbNodeStorageSizeInGBs)).setter(CreateCloudVmClusterRequest.setter(Builder::dbNodeStorageSizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbNodeStorageSizeInGBs").build()}).build();
    private static final SdkField<List<String>> DB_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dbServers").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::dbServers)).setter(CreateCloudVmClusterRequest.setter(Builder::dbServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::tags)).setter(CreateCloudVmClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_LOCAL_BACKUP_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isLocalBackupEnabled").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::isLocalBackupEnabled)).setter(CreateCloudVmClusterRequest.setter(Builder::isLocalBackupEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isLocalBackupEnabled").build()}).build();
    private static final SdkField<Boolean> IS_SPARSE_DISKGROUP_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isSparseDiskgroupEnabled").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::isSparseDiskgroupEnabled)).setter(CreateCloudVmClusterRequest.setter(Builder::isSparseDiskgroupEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isSparseDiskgroupEnabled").build()}).build();
    private static final SdkField<String> LICENSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("licenseModel").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::licenseModelAsString)).setter(CreateCloudVmClusterRequest.setter(Builder::licenseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseModel").build()}).build();
    private static final SdkField<Integer> MEMORY_SIZE_IN_G_BS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memorySizeInGBs").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::memorySizeInGBs)).setter(CreateCloudVmClusterRequest.setter(Builder::memorySizeInGBs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memorySizeInGBs").build()}).build();
    private static final SdkField<String> SYSTEM_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("systemVersion").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::systemVersion)).setter(CreateCloudVmClusterRequest.setter(Builder::systemVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemVersion").build()}).build();
    private static final SdkField<String> TIME_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timeZone").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::timeZone)).setter(CreateCloudVmClusterRequest.setter(Builder::timeZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeZone").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::clientToken)).setter(CreateCloudVmClusterRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Integer> SCAN_LISTENER_PORT_TCP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("scanListenerPortTcp").getter(CreateCloudVmClusterRequest.getter(CreateCloudVmClusterRequest::scanListenerPortTcp)).setter(CreateCloudVmClusterRequest.setter(Builder::scanListenerPortTcp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scanListenerPortTcp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD, CPU_CORE_COUNT_FIELD, DISPLAY_NAME_FIELD, GI_VERSION_FIELD, HOSTNAME_FIELD, SSH_PUBLIC_KEYS_FIELD, ODB_NETWORK_ID_FIELD, CLUSTER_NAME_FIELD, DATA_COLLECTION_OPTIONS_FIELD, DATA_STORAGE_SIZE_IN_T_BS_FIELD, DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD, DB_SERVERS_FIELD, TAGS_FIELD, IS_LOCAL_BACKUP_ENABLED_FIELD, IS_SPARSE_DISKGROUP_ENABLED_FIELD, LICENSE_MODEL_FIELD, MEMORY_SIZE_IN_G_BS_FIELD, SYSTEM_VERSION_FIELD, TIME_ZONE_FIELD, CLIENT_TOKEN_FIELD, SCAN_LISTENER_PORT_TCP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCloudVmClusterRequest.memberNameToFieldInitializer();
    private final String cloudExadataInfrastructureId;
    private final Integer cpuCoreCount;
    private final String displayName;
    private final String giVersion;
    private final String hostname;
    private final List<String> sshPublicKeys;
    private final String odbNetworkId;
    private final String clusterName;
    private final DataCollectionOptions dataCollectionOptions;
    private final Double dataStorageSizeInTBs;
    private final Integer dbNodeStorageSizeInGBs;
    private final List<String> dbServers;
    private final Map<String, String> tags;
    private final Boolean isLocalBackupEnabled;
    private final Boolean isSparseDiskgroupEnabled;
    private final String licenseModel;
    private final Integer memorySizeInGBs;
    private final String systemVersion;
    private final String timeZone;
    private final String clientToken;
    private final Integer scanListenerPortTcp;

    private CreateCloudVmClusterRequest(BuilderImpl builder) {
        super(builder);
        this.cloudExadataInfrastructureId = builder.cloudExadataInfrastructureId;
        this.cpuCoreCount = builder.cpuCoreCount;
        this.displayName = builder.displayName;
        this.giVersion = builder.giVersion;
        this.hostname = builder.hostname;
        this.sshPublicKeys = builder.sshPublicKeys;
        this.odbNetworkId = builder.odbNetworkId;
        this.clusterName = builder.clusterName;
        this.dataCollectionOptions = builder.dataCollectionOptions;
        this.dataStorageSizeInTBs = builder.dataStorageSizeInTBs;
        this.dbNodeStorageSizeInGBs = builder.dbNodeStorageSizeInGBs;
        this.dbServers = builder.dbServers;
        this.tags = builder.tags;
        this.isLocalBackupEnabled = builder.isLocalBackupEnabled;
        this.isSparseDiskgroupEnabled = builder.isSparseDiskgroupEnabled;
        this.licenseModel = builder.licenseModel;
        this.memorySizeInGBs = builder.memorySizeInGBs;
        this.systemVersion = builder.systemVersion;
        this.timeZone = builder.timeZone;
        this.clientToken = builder.clientToken;
        this.scanListenerPortTcp = builder.scanListenerPortTcp;
    }

    public final String cloudExadataInfrastructureId() {
        return this.cloudExadataInfrastructureId;
    }

    public final Integer cpuCoreCount() {
        return this.cpuCoreCount;
    }

    public final String displayName() {
        return this.displayName;
    }

    public final String giVersion() {
        return this.giVersion;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final boolean hasSshPublicKeys() {
        return this.sshPublicKeys != null && !(this.sshPublicKeys instanceof SdkAutoConstructList);
    }

    public final List<String> sshPublicKeys() {
        return this.sshPublicKeys;
    }

    public final String odbNetworkId() {
        return this.odbNetworkId;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final DataCollectionOptions dataCollectionOptions() {
        return this.dataCollectionOptions;
    }

    public final Double dataStorageSizeInTBs() {
        return this.dataStorageSizeInTBs;
    }

    public final Integer dbNodeStorageSizeInGBs() {
        return this.dbNodeStorageSizeInGBs;
    }

    public final boolean hasDbServers() {
        return this.dbServers != null && !(this.dbServers instanceof SdkAutoConstructList);
    }

    public final List<String> dbServers() {
        return this.dbServers;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final Boolean isLocalBackupEnabled() {
        return this.isLocalBackupEnabled;
    }

    public final Boolean isSparseDiskgroupEnabled() {
        return this.isSparseDiskgroupEnabled;
    }

    public final LicenseModel licenseModel() {
        return LicenseModel.fromValue(this.licenseModel);
    }

    public final String licenseModelAsString() {
        return this.licenseModel;
    }

    public final Integer memorySizeInGBs() {
        return this.memorySizeInGBs;
    }

    public final String systemVersion() {
        return this.systemVersion;
    }

    public final String timeZone() {
        return this.timeZone;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Integer scanListenerPortTcp() {
        return this.scanListenerPortTcp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudExadataInfrastructureId());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuCoreCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.giVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSshPublicKeys() ? this.sshPublicKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.odbNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataCollectionOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataStorageSizeInTBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbNodeStorageSizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDbServers() ? this.dbServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isLocalBackupEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.isSparseDiskgroupEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.licenseModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.memorySizeInGBs());
        hashCode = 31 * hashCode + Objects.hashCode(this.systemVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.timeZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanListenerPortTcp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudVmClusterRequest)) {
            return false;
        }
        CreateCloudVmClusterRequest other = (CreateCloudVmClusterRequest)((Object)obj);
        return Objects.equals(this.cloudExadataInfrastructureId(), other.cloudExadataInfrastructureId()) && Objects.equals(this.cpuCoreCount(), other.cpuCoreCount()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.giVersion(), other.giVersion()) && Objects.equals(this.hostname(), other.hostname()) && this.hasSshPublicKeys() == other.hasSshPublicKeys() && Objects.equals(this.sshPublicKeys(), other.sshPublicKeys()) && Objects.equals(this.odbNetworkId(), other.odbNetworkId()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.dataCollectionOptions(), other.dataCollectionOptions()) && Objects.equals(this.dataStorageSizeInTBs(), other.dataStorageSizeInTBs()) && Objects.equals(this.dbNodeStorageSizeInGBs(), other.dbNodeStorageSizeInGBs()) && this.hasDbServers() == other.hasDbServers() && Objects.equals(this.dbServers(), other.dbServers()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.isLocalBackupEnabled(), other.isLocalBackupEnabled()) && Objects.equals(this.isSparseDiskgroupEnabled(), other.isSparseDiskgroupEnabled()) && Objects.equals(this.licenseModelAsString(), other.licenseModelAsString()) && Objects.equals(this.memorySizeInGBs(), other.memorySizeInGBs()) && Objects.equals(this.systemVersion(), other.systemVersion()) && Objects.equals(this.timeZone(), other.timeZone()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.scanListenerPortTcp(), other.scanListenerPortTcp());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCloudVmClusterRequest").add("CloudExadataInfrastructureId", (Object)this.cloudExadataInfrastructureId()).add("CpuCoreCount", (Object)this.cpuCoreCount()).add("DisplayName", (Object)this.displayName()).add("GiVersion", (Object)this.giVersion()).add("Hostname", (Object)this.hostname()).add("SshPublicKeys", this.hasSshPublicKeys() ? this.sshPublicKeys() : null).add("OdbNetworkId", (Object)this.odbNetworkId()).add("ClusterName", (Object)this.clusterName()).add("DataCollectionOptions", (Object)this.dataCollectionOptions()).add("DataStorageSizeInTBs", (Object)this.dataStorageSizeInTBs()).add("DbNodeStorageSizeInGBs", (Object)this.dbNodeStorageSizeInGBs()).add("DbServers", this.hasDbServers() ? this.dbServers() : null).add("Tags", this.hasTags() ? this.tags() : null).add("IsLocalBackupEnabled", (Object)this.isLocalBackupEnabled()).add("IsSparseDiskgroupEnabled", (Object)this.isSparseDiskgroupEnabled()).add("LicenseModel", (Object)this.licenseModelAsString()).add("MemorySizeInGBs", (Object)this.memorySizeInGBs()).add("SystemVersion", (Object)this.systemVersion()).add("TimeZone", (Object)this.timeZone()).add("ClientToken", (Object)this.clientToken()).add("ScanListenerPortTcp", (Object)this.scanListenerPortTcp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudExadataInfrastructureId": {
                return Optional.ofNullable(clazz.cast(this.cloudExadataInfrastructureId()));
            }
            case "cpuCoreCount": {
                return Optional.ofNullable(clazz.cast(this.cpuCoreCount()));
            }
            case "displayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "giVersion": {
                return Optional.ofNullable(clazz.cast(this.giVersion()));
            }
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "sshPublicKeys": {
                return Optional.ofNullable(clazz.cast(this.sshPublicKeys()));
            }
            case "odbNetworkId": {
                return Optional.ofNullable(clazz.cast(this.odbNetworkId()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "dataCollectionOptions": {
                return Optional.ofNullable(clazz.cast(this.dataCollectionOptions()));
            }
            case "dataStorageSizeInTBs": {
                return Optional.ofNullable(clazz.cast(this.dataStorageSizeInTBs()));
            }
            case "dbNodeStorageSizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.dbNodeStorageSizeInGBs()));
            }
            case "dbServers": {
                return Optional.ofNullable(clazz.cast(this.dbServers()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "isLocalBackupEnabled": {
                return Optional.ofNullable(clazz.cast(this.isLocalBackupEnabled()));
            }
            case "isSparseDiskgroupEnabled": {
                return Optional.ofNullable(clazz.cast(this.isSparseDiskgroupEnabled()));
            }
            case "licenseModel": {
                return Optional.ofNullable(clazz.cast(this.licenseModelAsString()));
            }
            case "memorySizeInGBs": {
                return Optional.ofNullable(clazz.cast(this.memorySizeInGBs()));
            }
            case "systemVersion": {
                return Optional.ofNullable(clazz.cast(this.systemVersion()));
            }
            case "timeZone": {
                return Optional.ofNullable(clazz.cast(this.timeZone()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "scanListenerPortTcp": {
                return Optional.ofNullable(clazz.cast(this.scanListenerPortTcp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudExadataInfrastructureId", CLOUD_EXADATA_INFRASTRUCTURE_ID_FIELD);
        map.put("cpuCoreCount", CPU_CORE_COUNT_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("giVersion", GI_VERSION_FIELD);
        map.put("hostname", HOSTNAME_FIELD);
        map.put("sshPublicKeys", SSH_PUBLIC_KEYS_FIELD);
        map.put("odbNetworkId", ODB_NETWORK_ID_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("dataCollectionOptions", DATA_COLLECTION_OPTIONS_FIELD);
        map.put("dataStorageSizeInTBs", DATA_STORAGE_SIZE_IN_T_BS_FIELD);
        map.put("dbNodeStorageSizeInGBs", DB_NODE_STORAGE_SIZE_IN_G_BS_FIELD);
        map.put("dbServers", DB_SERVERS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("isLocalBackupEnabled", IS_LOCAL_BACKUP_ENABLED_FIELD);
        map.put("isSparseDiskgroupEnabled", IS_SPARSE_DISKGROUP_ENABLED_FIELD);
        map.put("licenseModel", LICENSE_MODEL_FIELD);
        map.put("memorySizeInGBs", MEMORY_SIZE_IN_G_BS_FIELD);
        map.put("systemVersion", SYSTEM_VERSION_FIELD);
        map.put("timeZone", TIME_ZONE_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("scanListenerPortTcp", SCAN_LISTENER_PORT_TCP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudVmClusterRequest, T> g) {
        return obj -> g.apply((CreateCloudVmClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbRequest.BuilderImpl
    implements Builder {
        private String cloudExadataInfrastructureId;
        private Integer cpuCoreCount;
        private String displayName;
        private String giVersion;
        private String hostname;
        private List<String> sshPublicKeys = DefaultSdkAutoConstructList.getInstance();
        private String odbNetworkId;
        private String clusterName;
        private DataCollectionOptions dataCollectionOptions;
        private Double dataStorageSizeInTBs;
        private Integer dbNodeStorageSizeInGBs;
        private List<String> dbServers = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Boolean isLocalBackupEnabled;
        private Boolean isSparseDiskgroupEnabled;
        private String licenseModel;
        private Integer memorySizeInGBs;
        private String systemVersion;
        private String timeZone;
        private String clientToken;
        private Integer scanListenerPortTcp;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudVmClusterRequest model) {
            super(model);
            this.cloudExadataInfrastructureId(model.cloudExadataInfrastructureId);
            this.cpuCoreCount(model.cpuCoreCount);
            this.displayName(model.displayName);
            this.giVersion(model.giVersion);
            this.hostname(model.hostname);
            this.sshPublicKeys(model.sshPublicKeys);
            this.odbNetworkId(model.odbNetworkId);
            this.clusterName(model.clusterName);
            this.dataCollectionOptions(model.dataCollectionOptions);
            this.dataStorageSizeInTBs(model.dataStorageSizeInTBs);
            this.dbNodeStorageSizeInGBs(model.dbNodeStorageSizeInGBs);
            this.dbServers(model.dbServers);
            this.tags(model.tags);
            this.isLocalBackupEnabled(model.isLocalBackupEnabled);
            this.isSparseDiskgroupEnabled(model.isSparseDiskgroupEnabled);
            this.licenseModel(model.licenseModel);
            this.memorySizeInGBs(model.memorySizeInGBs);
            this.systemVersion(model.systemVersion);
            this.timeZone(model.timeZone);
            this.clientToken(model.clientToken);
            this.scanListenerPortTcp(model.scanListenerPortTcp);
        }

        public final String getCloudExadataInfrastructureId() {
            return this.cloudExadataInfrastructureId;
        }

        public final void setCloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
        }

        @Override
        public final Builder cloudExadataInfrastructureId(String cloudExadataInfrastructureId) {
            this.cloudExadataInfrastructureId = cloudExadataInfrastructureId;
            return this;
        }

        public final Integer getCpuCoreCount() {
            return this.cpuCoreCount;
        }

        public final void setCpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
        }

        @Override
        public final Builder cpuCoreCount(Integer cpuCoreCount) {
            this.cpuCoreCount = cpuCoreCount;
            return this;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getGiVersion() {
            return this.giVersion;
        }

        public final void setGiVersion(String giVersion) {
            this.giVersion = giVersion;
        }

        @Override
        public final Builder giVersion(String giVersion) {
            this.giVersion = giVersion;
            return this;
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final Collection<String> getSshPublicKeys() {
            if (this.sshPublicKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sshPublicKeys;
        }

        public final void setSshPublicKeys(Collection<String> sshPublicKeys) {
            this.sshPublicKeys = StringListCopier.copy(sshPublicKeys);
        }

        @Override
        public final Builder sshPublicKeys(Collection<String> sshPublicKeys) {
            this.sshPublicKeys = StringListCopier.copy(sshPublicKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sshPublicKeys(String ... sshPublicKeys) {
            this.sshPublicKeys(Arrays.asList(sshPublicKeys));
            return this;
        }

        public final String getOdbNetworkId() {
            return this.odbNetworkId;
        }

        public final void setOdbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
        }

        @Override
        public final Builder odbNetworkId(String odbNetworkId) {
            this.odbNetworkId = odbNetworkId;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final DataCollectionOptions.Builder getDataCollectionOptions() {
            return this.dataCollectionOptions != null ? this.dataCollectionOptions.toBuilder() : null;
        }

        public final void setDataCollectionOptions(DataCollectionOptions.BuilderImpl dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions != null ? dataCollectionOptions.build() : null;
        }

        @Override
        public final Builder dataCollectionOptions(DataCollectionOptions dataCollectionOptions) {
            this.dataCollectionOptions = dataCollectionOptions;
            return this;
        }

        public final Double getDataStorageSizeInTBs() {
            return this.dataStorageSizeInTBs;
        }

        public final void setDataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
        }

        @Override
        public final Builder dataStorageSizeInTBs(Double dataStorageSizeInTBs) {
            this.dataStorageSizeInTBs = dataStorageSizeInTBs;
            return this;
        }

        public final Integer getDbNodeStorageSizeInGBs() {
            return this.dbNodeStorageSizeInGBs;
        }

        public final void setDbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
        }

        @Override
        public final Builder dbNodeStorageSizeInGBs(Integer dbNodeStorageSizeInGBs) {
            this.dbNodeStorageSizeInGBs = dbNodeStorageSizeInGBs;
            return this;
        }

        public final Collection<String> getDbServers() {
            if (this.dbServers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dbServers;
        }

        public final void setDbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
        }

        @Override
        public final Builder dbServers(Collection<String> dbServers) {
            this.dbServers = StringListCopier.copy(dbServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbServers(String ... dbServers) {
            this.dbServers(Arrays.asList(dbServers));
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = RequestTagMapCopier.copy(tags);
            return this;
        }

        public final Boolean getIsLocalBackupEnabled() {
            return this.isLocalBackupEnabled;
        }

        public final void setIsLocalBackupEnabled(Boolean isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
        }

        @Override
        public final Builder isLocalBackupEnabled(Boolean isLocalBackupEnabled) {
            this.isLocalBackupEnabled = isLocalBackupEnabled;
            return this;
        }

        public final Boolean getIsSparseDiskgroupEnabled() {
            return this.isSparseDiskgroupEnabled;
        }

        public final void setIsSparseDiskgroupEnabled(Boolean isSparseDiskgroupEnabled) {
            this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
        }

        @Override
        public final Builder isSparseDiskgroupEnabled(Boolean isSparseDiskgroupEnabled) {
            this.isSparseDiskgroupEnabled = isSparseDiskgroupEnabled;
            return this;
        }

        public final String getLicenseModel() {
            return this.licenseModel;
        }

        public final void setLicenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
        }

        @Override
        public final Builder licenseModel(String licenseModel) {
            this.licenseModel = licenseModel;
            return this;
        }

        @Override
        public final Builder licenseModel(LicenseModel licenseModel) {
            this.licenseModel(licenseModel == null ? null : licenseModel.toString());
            return this;
        }

        public final Integer getMemorySizeInGBs() {
            return this.memorySizeInGBs;
        }

        public final void setMemorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
        }

        @Override
        public final Builder memorySizeInGBs(Integer memorySizeInGBs) {
            this.memorySizeInGBs = memorySizeInGBs;
            return this;
        }

        public final String getSystemVersion() {
            return this.systemVersion;
        }

        public final void setSystemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
        }

        @Override
        public final Builder systemVersion(String systemVersion) {
            this.systemVersion = systemVersion;
            return this;
        }

        public final String getTimeZone() {
            return this.timeZone;
        }

        public final void setTimeZone(String timeZone) {
            this.timeZone = timeZone;
        }

        @Override
        public final Builder timeZone(String timeZone) {
            this.timeZone = timeZone;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Integer getScanListenerPortTcp() {
            return this.scanListenerPortTcp;
        }

        public final void setScanListenerPortTcp(Integer scanListenerPortTcp) {
            this.scanListenerPortTcp = scanListenerPortTcp;
        }

        @Override
        public final Builder scanListenerPortTcp(Integer scanListenerPortTcp) {
            this.scanListenerPortTcp = scanListenerPortTcp;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCloudVmClusterRequest build() {
            return new CreateCloudVmClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCloudVmClusterRequest> {
        public Builder cloudExadataInfrastructureId(String var1);

        public Builder cpuCoreCount(Integer var1);

        public Builder displayName(String var1);

        public Builder giVersion(String var1);

        public Builder hostname(String var1);

        public Builder sshPublicKeys(Collection<String> var1);

        public Builder sshPublicKeys(String ... var1);

        public Builder odbNetworkId(String var1);

        public Builder clusterName(String var1);

        public Builder dataCollectionOptions(DataCollectionOptions var1);

        default public Builder dataCollectionOptions(Consumer<DataCollectionOptions.Builder> dataCollectionOptions) {
            return this.dataCollectionOptions((DataCollectionOptions)((DataCollectionOptions.Builder)DataCollectionOptions.builder().applyMutation(dataCollectionOptions)).build());
        }

        public Builder dataStorageSizeInTBs(Double var1);

        public Builder dbNodeStorageSizeInGBs(Integer var1);

        public Builder dbServers(Collection<String> var1);

        public Builder dbServers(String ... var1);

        public Builder tags(Map<String, String> var1);

        public Builder isLocalBackupEnabled(Boolean var1);

        public Builder isSparseDiskgroupEnabled(Boolean var1);

        public Builder licenseModel(String var1);

        public Builder licenseModel(LicenseModel var1);

        public Builder memorySizeInGBs(Integer var1);

        public Builder systemVersion(String var1);

        public Builder timeZone(String var1);

        public Builder clientToken(String var1);

        public Builder scanListenerPortTcp(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

