/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.odb.model.DbServerPatchingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DbServerPatchingDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DbServerPatchingDetails> {
    private static final SdkField<Integer> ESTIMATED_PATCH_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("estimatedPatchDuration").getter(DbServerPatchingDetails.getter(DbServerPatchingDetails::estimatedPatchDuration)).setter(DbServerPatchingDetails.setter(Builder::estimatedPatchDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("estimatedPatchDuration").build()}).build();
    private static final SdkField<String> PATCHING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("patchingStatus").getter(DbServerPatchingDetails.getter(DbServerPatchingDetails::patchingStatusAsString)).setter(DbServerPatchingDetails.setter(Builder::patchingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("patchingStatus").build()}).build();
    private static final SdkField<String> TIME_PATCHING_ENDED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timePatchingEnded").getter(DbServerPatchingDetails.getter(DbServerPatchingDetails::timePatchingEnded)).setter(DbServerPatchingDetails.setter(Builder::timePatchingEnded)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timePatchingEnded").build()}).build();
    private static final SdkField<String> TIME_PATCHING_STARTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("timePatchingStarted").getter(DbServerPatchingDetails.getter(DbServerPatchingDetails::timePatchingStarted)).setter(DbServerPatchingDetails.setter(Builder::timePatchingStarted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timePatchingStarted").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ESTIMATED_PATCH_DURATION_FIELD, PATCHING_STATUS_FIELD, TIME_PATCHING_ENDED_FIELD, TIME_PATCHING_STARTED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DbServerPatchingDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer estimatedPatchDuration;
    private final String patchingStatus;
    private final String timePatchingEnded;
    private final String timePatchingStarted;

    private DbServerPatchingDetails(BuilderImpl builder) {
        this.estimatedPatchDuration = builder.estimatedPatchDuration;
        this.patchingStatus = builder.patchingStatus;
        this.timePatchingEnded = builder.timePatchingEnded;
        this.timePatchingStarted = builder.timePatchingStarted;
    }

    public final Integer estimatedPatchDuration() {
        return this.estimatedPatchDuration;
    }

    public final DbServerPatchingStatus patchingStatus() {
        return DbServerPatchingStatus.fromValue(this.patchingStatus);
    }

    public final String patchingStatusAsString() {
        return this.patchingStatus;
    }

    public final String timePatchingEnded() {
        return this.timePatchingEnded;
    }

    public final String timePatchingStarted() {
        return this.timePatchingStarted;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedPatchDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.patchingStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePatchingEnded());
        hashCode = 31 * hashCode + Objects.hashCode(this.timePatchingStarted());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DbServerPatchingDetails)) {
            return false;
        }
        DbServerPatchingDetails other = (DbServerPatchingDetails)obj;
        return Objects.equals(this.estimatedPatchDuration(), other.estimatedPatchDuration()) && Objects.equals(this.patchingStatusAsString(), other.patchingStatusAsString()) && Objects.equals(this.timePatchingEnded(), other.timePatchingEnded()) && Objects.equals(this.timePatchingStarted(), other.timePatchingStarted());
    }

    public final String toString() {
        return ToString.builder((String)"DbServerPatchingDetails").add("EstimatedPatchDuration", (Object)this.estimatedPatchDuration()).add("PatchingStatus", (Object)this.patchingStatusAsString()).add("TimePatchingEnded", (Object)this.timePatchingEnded()).add("TimePatchingStarted", (Object)this.timePatchingStarted()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "estimatedPatchDuration": {
                return Optional.ofNullable(clazz.cast(this.estimatedPatchDuration()));
            }
            case "patchingStatus": {
                return Optional.ofNullable(clazz.cast(this.patchingStatusAsString()));
            }
            case "timePatchingEnded": {
                return Optional.ofNullable(clazz.cast(this.timePatchingEnded()));
            }
            case "timePatchingStarted": {
                return Optional.ofNullable(clazz.cast(this.timePatchingStarted()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("estimatedPatchDuration", ESTIMATED_PATCH_DURATION_FIELD);
        map.put("patchingStatus", PATCHING_STATUS_FIELD);
        map.put("timePatchingEnded", TIME_PATCHING_ENDED_FIELD);
        map.put("timePatchingStarted", TIME_PATCHING_STARTED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DbServerPatchingDetails, T> g) {
        return obj -> g.apply((DbServerPatchingDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer estimatedPatchDuration;
        private String patchingStatus;
        private String timePatchingEnded;
        private String timePatchingStarted;

        private BuilderImpl() {
        }

        private BuilderImpl(DbServerPatchingDetails model) {
            this.estimatedPatchDuration(model.estimatedPatchDuration);
            this.patchingStatus(model.patchingStatus);
            this.timePatchingEnded(model.timePatchingEnded);
            this.timePatchingStarted(model.timePatchingStarted);
        }

        public final Integer getEstimatedPatchDuration() {
            return this.estimatedPatchDuration;
        }

        public final void setEstimatedPatchDuration(Integer estimatedPatchDuration) {
            this.estimatedPatchDuration = estimatedPatchDuration;
        }

        @Override
        public final Builder estimatedPatchDuration(Integer estimatedPatchDuration) {
            this.estimatedPatchDuration = estimatedPatchDuration;
            return this;
        }

        public final String getPatchingStatus() {
            return this.patchingStatus;
        }

        public final void setPatchingStatus(String patchingStatus) {
            this.patchingStatus = patchingStatus;
        }

        @Override
        public final Builder patchingStatus(String patchingStatus) {
            this.patchingStatus = patchingStatus;
            return this;
        }

        @Override
        public final Builder patchingStatus(DbServerPatchingStatus patchingStatus) {
            this.patchingStatus(patchingStatus == null ? null : patchingStatus.toString());
            return this;
        }

        public final String getTimePatchingEnded() {
            return this.timePatchingEnded;
        }

        public final void setTimePatchingEnded(String timePatchingEnded) {
            this.timePatchingEnded = timePatchingEnded;
        }

        @Override
        public final Builder timePatchingEnded(String timePatchingEnded) {
            this.timePatchingEnded = timePatchingEnded;
            return this;
        }

        public final String getTimePatchingStarted() {
            return this.timePatchingStarted;
        }

        public final void setTimePatchingStarted(String timePatchingStarted) {
            this.timePatchingStarted = timePatchingStarted;
        }

        @Override
        public final Builder timePatchingStarted(String timePatchingStarted) {
            this.timePatchingStarted = timePatchingStarted;
            return this;
        }

        public DbServerPatchingDetails build() {
            return new DbServerPatchingDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DbServerPatchingDetails> {
        public Builder estimatedPatchDuration(Integer var1);

        public Builder patchingStatus(String var1);

        public Builder patchingStatus(DbServerPatchingStatus var1);

        public Builder timePatchingEnded(String var1);

        public Builder timePatchingStarted(String var1);
    }
}

