/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DbServerPatchingStatus {
    COMPLETE("COMPLETE"),
    FAILED("FAILED"),
    MAINTENANCE_IN_PROGRESS("MAINTENANCE_IN_PROGRESS"),
    SCHEDULED("SCHEDULED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DbServerPatchingStatus> VALUE_MAP;
    private final String value;

    private DbServerPatchingStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DbServerPatchingStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DbServerPatchingStatus> knownValues() {
        EnumSet<DbServerPatchingStatus> knownValues = EnumSet.allOf(DbServerPatchingStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DbServerPatchingStatus.class, DbServerPatchingStatus::toString);
    }
}

