/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.odb.model.GiVersionListCopier;
import software.amazon.awssdk.services.odb.model.GiVersionSummary;
import software.amazon.awssdk.services.odb.model.OdbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListGiVersionsResponse
extends OdbResponse
implements ToCopyableBuilder<Builder, ListGiVersionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListGiVersionsResponse.getter(ListGiVersionsResponse::nextToken)).setter(ListGiVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<GiVersionSummary>> GI_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("giVersions").getter(ListGiVersionsResponse.getter(ListGiVersionsResponse::giVersions)).setter(ListGiVersionsResponse.setter(Builder::giVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("giVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GiVersionSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, GI_VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListGiVersionsResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<GiVersionSummary> giVersions;

    private ListGiVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.giVersions = builder.giVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasGiVersions() {
        return this.giVersions != null && !(this.giVersions instanceof SdkAutoConstructList);
    }

    public final List<GiVersionSummary> giVersions() {
        return this.giVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGiVersions() ? this.giVersions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListGiVersionsResponse)) {
            return false;
        }
        ListGiVersionsResponse other = (ListGiVersionsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasGiVersions() == other.hasGiVersions() && Objects.equals(this.giVersions(), other.giVersions());
    }

    public final String toString() {
        return ToString.builder((String)"ListGiVersionsResponse").add("NextToken", (Object)this.nextToken()).add("GiVersions", this.hasGiVersions() ? this.giVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "giVersions": {
                return Optional.ofNullable(clazz.cast(this.giVersions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("giVersions", GI_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListGiVersionsResponse, T> g) {
        return obj -> g.apply((ListGiVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OdbResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<GiVersionSummary> giVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListGiVersionsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.giVersions(model.giVersions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<GiVersionSummary.Builder> getGiVersions() {
            List<GiVersionSummary.Builder> result = GiVersionListCopier.copyToBuilder(this.giVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGiVersions(Collection<GiVersionSummary.BuilderImpl> giVersions) {
            this.giVersions = GiVersionListCopier.copyFromBuilder(giVersions);
        }

        @Override
        public final Builder giVersions(Collection<GiVersionSummary> giVersions) {
            this.giVersions = GiVersionListCopier.copy(giVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder giVersions(GiVersionSummary ... giVersions) {
            this.giVersions(Arrays.asList(giVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder giVersions(Consumer<GiVersionSummary.Builder> ... giVersions) {
            this.giVersions(Stream.of(giVersions).map(c -> (GiVersionSummary)((GiVersionSummary.Builder)GiVersionSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListGiVersionsResponse build() {
            return new ListGiVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OdbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListGiVersionsResponse> {
        public Builder nextToken(String var1);

        public Builder giVersions(Collection<GiVersionSummary> var1);

        public Builder giVersions(GiVersionSummary ... var1);

        public Builder giVersions(Consumer<GiVersionSummary.Builder> ... var1);
    }
}

