/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.odb.model.ResourceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OciIdentityDomain
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OciIdentityDomain> {
    private static final SdkField<String> OCI_IDENTITY_DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociIdentityDomainId").getter(OciIdentityDomain.getter(OciIdentityDomain::ociIdentityDomainId)).setter(OciIdentityDomain.setter(Builder::ociIdentityDomainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociIdentityDomainId").build()}).build();
    private static final SdkField<String> OCI_IDENTITY_DOMAIN_RESOURCE_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociIdentityDomainResourceUrl").getter(OciIdentityDomain.getter(OciIdentityDomain::ociIdentityDomainResourceUrl)).setter(OciIdentityDomain.setter(Builder::ociIdentityDomainResourceUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociIdentityDomainResourceUrl").build()}).build();
    private static final SdkField<String> OCI_IDENTITY_DOMAIN_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ociIdentityDomainUrl").getter(OciIdentityDomain.getter(OciIdentityDomain::ociIdentityDomainUrl)).setter(OciIdentityDomain.setter(Builder::ociIdentityDomainUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ociIdentityDomainUrl").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(OciIdentityDomain.getter(OciIdentityDomain::statusAsString)).setter(OciIdentityDomain.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(OciIdentityDomain.getter(OciIdentityDomain::statusReason)).setter(OciIdentityDomain.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final SdkField<String> ACCOUNT_SETUP_CLOUD_FORMATION_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountSetupCloudFormationUrl").getter(OciIdentityDomain.getter(OciIdentityDomain::accountSetupCloudFormationUrl)).setter(OciIdentityDomain.setter(Builder::accountSetupCloudFormationUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountSetupCloudFormationUrl").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OCI_IDENTITY_DOMAIN_ID_FIELD, OCI_IDENTITY_DOMAIN_RESOURCE_URL_FIELD, OCI_IDENTITY_DOMAIN_URL_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, ACCOUNT_SETUP_CLOUD_FORMATION_URL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = OciIdentityDomain.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String ociIdentityDomainId;
    private final String ociIdentityDomainResourceUrl;
    private final String ociIdentityDomainUrl;
    private final String status;
    private final String statusReason;
    private final String accountSetupCloudFormationUrl;

    private OciIdentityDomain(BuilderImpl builder) {
        this.ociIdentityDomainId = builder.ociIdentityDomainId;
        this.ociIdentityDomainResourceUrl = builder.ociIdentityDomainResourceUrl;
        this.ociIdentityDomainUrl = builder.ociIdentityDomainUrl;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.accountSetupCloudFormationUrl = builder.accountSetupCloudFormationUrl;
    }

    public final String ociIdentityDomainId() {
        return this.ociIdentityDomainId;
    }

    public final String ociIdentityDomainResourceUrl() {
        return this.ociIdentityDomainResourceUrl;
    }

    public final String ociIdentityDomainUrl() {
        return this.ociIdentityDomainUrl;
    }

    public final ResourceStatus status() {
        return ResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public final String accountSetupCloudFormationUrl() {
        return this.accountSetupCloudFormationUrl;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ociIdentityDomainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociIdentityDomainResourceUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.ociIdentityDomainUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountSetupCloudFormationUrl());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OciIdentityDomain)) {
            return false;
        }
        OciIdentityDomain other = (OciIdentityDomain)obj;
        return Objects.equals(this.ociIdentityDomainId(), other.ociIdentityDomainId()) && Objects.equals(this.ociIdentityDomainResourceUrl(), other.ociIdentityDomainResourceUrl()) && Objects.equals(this.ociIdentityDomainUrl(), other.ociIdentityDomainUrl()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason()) && Objects.equals(this.accountSetupCloudFormationUrl(), other.accountSetupCloudFormationUrl());
    }

    public final String toString() {
        return ToString.builder((String)"OciIdentityDomain").add("OciIdentityDomainId", (Object)this.ociIdentityDomainId()).add("OciIdentityDomainResourceUrl", (Object)this.ociIdentityDomainResourceUrl()).add("OciIdentityDomainUrl", (Object)this.ociIdentityDomainUrl()).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)this.statusReason()).add("AccountSetupCloudFormationUrl", (Object)this.accountSetupCloudFormationUrl()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ociIdentityDomainId": {
                return Optional.ofNullable(clazz.cast(this.ociIdentityDomainId()));
            }
            case "ociIdentityDomainResourceUrl": {
                return Optional.ofNullable(clazz.cast(this.ociIdentityDomainResourceUrl()));
            }
            case "ociIdentityDomainUrl": {
                return Optional.ofNullable(clazz.cast(this.ociIdentityDomainUrl()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
            case "accountSetupCloudFormationUrl": {
                return Optional.ofNullable(clazz.cast(this.accountSetupCloudFormationUrl()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ociIdentityDomainId", OCI_IDENTITY_DOMAIN_ID_FIELD);
        map.put("ociIdentityDomainResourceUrl", OCI_IDENTITY_DOMAIN_RESOURCE_URL_FIELD);
        map.put("ociIdentityDomainUrl", OCI_IDENTITY_DOMAIN_URL_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("accountSetupCloudFormationUrl", ACCOUNT_SETUP_CLOUD_FORMATION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OciIdentityDomain, T> g) {
        return obj -> g.apply((OciIdentityDomain)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String ociIdentityDomainId;
        private String ociIdentityDomainResourceUrl;
        private String ociIdentityDomainUrl;
        private String status;
        private String statusReason;
        private String accountSetupCloudFormationUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(OciIdentityDomain model) {
            this.ociIdentityDomainId(model.ociIdentityDomainId);
            this.ociIdentityDomainResourceUrl(model.ociIdentityDomainResourceUrl);
            this.ociIdentityDomainUrl(model.ociIdentityDomainUrl);
            this.status(model.status);
            this.statusReason(model.statusReason);
            this.accountSetupCloudFormationUrl(model.accountSetupCloudFormationUrl);
        }

        public final String getOciIdentityDomainId() {
            return this.ociIdentityDomainId;
        }

        public final void setOciIdentityDomainId(String ociIdentityDomainId) {
            this.ociIdentityDomainId = ociIdentityDomainId;
        }

        @Override
        public final Builder ociIdentityDomainId(String ociIdentityDomainId) {
            this.ociIdentityDomainId = ociIdentityDomainId;
            return this;
        }

        public final String getOciIdentityDomainResourceUrl() {
            return this.ociIdentityDomainResourceUrl;
        }

        public final void setOciIdentityDomainResourceUrl(String ociIdentityDomainResourceUrl) {
            this.ociIdentityDomainResourceUrl = ociIdentityDomainResourceUrl;
        }

        @Override
        public final Builder ociIdentityDomainResourceUrl(String ociIdentityDomainResourceUrl) {
            this.ociIdentityDomainResourceUrl = ociIdentityDomainResourceUrl;
            return this;
        }

        public final String getOciIdentityDomainUrl() {
            return this.ociIdentityDomainUrl;
        }

        public final void setOciIdentityDomainUrl(String ociIdentityDomainUrl) {
            this.ociIdentityDomainUrl = ociIdentityDomainUrl;
        }

        @Override
        public final Builder ociIdentityDomainUrl(String ociIdentityDomainUrl) {
            this.ociIdentityDomainUrl = ociIdentityDomainUrl;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getAccountSetupCloudFormationUrl() {
            return this.accountSetupCloudFormationUrl;
        }

        public final void setAccountSetupCloudFormationUrl(String accountSetupCloudFormationUrl) {
            this.accountSetupCloudFormationUrl = accountSetupCloudFormationUrl;
        }

        @Override
        public final Builder accountSetupCloudFormationUrl(String accountSetupCloudFormationUrl) {
            this.accountSetupCloudFormationUrl = accountSetupCloudFormationUrl;
            return this;
        }

        public OciIdentityDomain build() {
            return new OciIdentityDomain(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OciIdentityDomain> {
        public Builder ociIdentityDomainId(String var1);

        public Builder ociIdentityDomainResourceUrl(String var1);

        public Builder ociIdentityDomainUrl(String var1);

        public Builder status(String var1);

        public Builder status(ResourceStatus var1);

        public Builder statusReason(String var1);

        public Builder accountSetupCloudFormationUrl(String var1);
    }
}

