/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.odb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.odb.OdbClient;
import software.amazon.awssdk.services.odb.internal.UserAgentUtils;
import software.amazon.awssdk.services.odb.model.CloudExadataInfrastructureSummary;
import software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresRequest;
import software.amazon.awssdk.services.odb.model.ListCloudExadataInfrastructuresResponse;

public class ListCloudExadataInfrastructuresIterable
implements SdkIterable<ListCloudExadataInfrastructuresResponse> {
    private final OdbClient client;
    private final ListCloudExadataInfrastructuresRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCloudExadataInfrastructuresIterable(OdbClient client, ListCloudExadataInfrastructuresRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCloudExadataInfrastructuresResponseFetcher();
    }

    public Iterator<ListCloudExadataInfrastructuresResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<CloudExadataInfrastructureSummary> cloudExadataInfrastructures() {
        Function<ListCloudExadataInfrastructuresResponse, Iterator> getIterator = response -> {
            if (response != null && response.cloudExadataInfrastructures() != null) {
                return response.cloudExadataInfrastructures().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListCloudExadataInfrastructuresResponseFetcher
    implements SyncPageFetcher<ListCloudExadataInfrastructuresResponse> {
        private ListCloudExadataInfrastructuresResponseFetcher() {
        }

        public boolean hasNextPage(ListCloudExadataInfrastructuresResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCloudExadataInfrastructuresResponse nextPage(ListCloudExadataInfrastructuresResponse previousPage) {
            if (previousPage == null) {
                return ListCloudExadataInfrastructuresIterable.this.client.listCloudExadataInfrastructures(ListCloudExadataInfrastructuresIterable.this.firstRequest);
            }
            return ListCloudExadataInfrastructuresIterable.this.client.listCloudExadataInfrastructures((ListCloudExadataInfrastructuresRequest)((Object)ListCloudExadataInfrastructuresIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

