/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageDetails> {
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("image").getter(ImageDetails.getter(ImageDetails::image)).setter(ImageDetails.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageDigest").getter(ImageDetails.getter(ImageDetails::imageDigest)).setter(ImageDetails.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()}).build();
    private static final SdkField<String> SOURCE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceImage").getter(ImageDetails.getter(ImageDetails::sourceImage)).setter(ImageDetails.setter(Builder::sourceImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceImage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, IMAGE_DIGEST_FIELD, SOURCE_IMAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String image;
    private final String imageDigest;
    private final String sourceImage;

    private ImageDetails(BuilderImpl builder) {
        this.image = builder.image;
        this.imageDigest = builder.imageDigest;
        this.sourceImage = builder.sourceImage;
    }

    public final String image() {
        return this.image;
    }

    public final String imageDigest() {
        return this.imageDigest;
    }

    public final String sourceImage() {
        return this.sourceImage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageDetails)) {
            return false;
        }
        ImageDetails other = (ImageDetails)obj;
        return Objects.equals(this.image(), other.image()) && Objects.equals(this.imageDigest(), other.imageDigest()) && Objects.equals(this.sourceImage(), other.sourceImage());
    }

    public final String toString() {
        return ToString.builder((String)"ImageDetails").add("Image", (Object)this.image()).add("ImageDigest", (Object)this.imageDigest()).add("SourceImage", (Object)this.sourceImage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "imageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
            case "sourceImage": {
                return Optional.ofNullable(clazz.cast(this.sourceImage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("image", IMAGE_FIELD);
        map.put("imageDigest", IMAGE_DIGEST_FIELD);
        map.put("sourceImage", SOURCE_IMAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageDetails, T> g) {
        return obj -> g.apply((ImageDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String image;
        private String imageDigest;
        private String sourceImage;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageDetails model) {
            this.image(model.image);
            this.imageDigest(model.imageDigest);
            this.sourceImage(model.sourceImage);
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final String getSourceImage() {
            return this.sourceImage;
        }

        public final void setSourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
        }

        @Override
        public final Builder sourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public ImageDetails build() {
            return new ImageDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageDetails> {
        public Builder image(String var1);

        public Builder imageDigest(String var1);

        public Builder sourceImage(String var1);
    }
}

