/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EcsResourceRequirementType {
    GPU("GPU"),
    INFERENCE_ACCELERATOR("InferenceAccelerator"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EcsResourceRequirementType> VALUE_MAP;
    private final String value;

    private EcsResourceRequirementType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EcsResourceRequirementType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EcsResourceRequirementType> knownValues() {
        EnumSet<EcsResourceRequirementType> knownValues = EnumSet.allOf(EcsResourceRequirementType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EcsResourceRequirementType.class, EcsResourceRequirementType::toString);
    }
}

