/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pipes.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pipes.model.PipeTargetBatchJobParameters;
import software.amazon.awssdk.services.pipes.model.PipeTargetCloudWatchLogsParameters;
import software.amazon.awssdk.services.pipes.model.PipeTargetEcsTaskParameters;
import software.amazon.awssdk.services.pipes.model.PipeTargetEventBridgeEventBusParameters;
import software.amazon.awssdk.services.pipes.model.PipeTargetHttpParameters;
import software.amazon.awssdk.services.pipes.model.PipeTargetKinesisStreamParameters;
import software.amazon.awssdk.services.pipes.model.PipeTargetLambdaFunctionParameters;
import software.amazon.awssdk.services.pipes.model.PipeTargetRedshiftDataParameters;
import software.amazon.awssdk.services.pipes.model.PipeTargetSageMakerPipelineParameters;
import software.amazon.awssdk.services.pipes.model.PipeTargetSqsQueueParameters;
import software.amazon.awssdk.services.pipes.model.PipeTargetStateMachineParameters;
import software.amazon.awssdk.services.pipes.model.PipeTargetTimestreamParameters;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PipeTargetParameters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PipeTargetParameters> {
    private static final SdkField<String> INPUT_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InputTemplate").getter(PipeTargetParameters.getter(PipeTargetParameters::inputTemplate)).setter(PipeTargetParameters.setter(Builder::inputTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputTemplate").build()}).build();
    private static final SdkField<PipeTargetLambdaFunctionParameters> LAMBDA_FUNCTION_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LambdaFunctionParameters").getter(PipeTargetParameters.getter(PipeTargetParameters::lambdaFunctionParameters)).setter(PipeTargetParameters.setter(Builder::lambdaFunctionParameters)).constructor(PipeTargetLambdaFunctionParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LambdaFunctionParameters").build()}).build();
    private static final SdkField<PipeTargetStateMachineParameters> STEP_FUNCTION_STATE_MACHINE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StepFunctionStateMachineParameters").getter(PipeTargetParameters.getter(PipeTargetParameters::stepFunctionStateMachineParameters)).setter(PipeTargetParameters.setter(Builder::stepFunctionStateMachineParameters)).constructor(PipeTargetStateMachineParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StepFunctionStateMachineParameters").build()}).build();
    private static final SdkField<PipeTargetKinesisStreamParameters> KINESIS_STREAM_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KinesisStreamParameters").getter(PipeTargetParameters.getter(PipeTargetParameters::kinesisStreamParameters)).setter(PipeTargetParameters.setter(Builder::kinesisStreamParameters)).constructor(PipeTargetKinesisStreamParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KinesisStreamParameters").build()}).build();
    private static final SdkField<PipeTargetEcsTaskParameters> ECS_TASK_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EcsTaskParameters").getter(PipeTargetParameters.getter(PipeTargetParameters::ecsTaskParameters)).setter(PipeTargetParameters.setter(Builder::ecsTaskParameters)).constructor(PipeTargetEcsTaskParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EcsTaskParameters").build()}).build();
    private static final SdkField<PipeTargetBatchJobParameters> BATCH_JOB_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BatchJobParameters").getter(PipeTargetParameters.getter(PipeTargetParameters::batchJobParameters)).setter(PipeTargetParameters.setter(Builder::batchJobParameters)).constructor(PipeTargetBatchJobParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BatchJobParameters").build()}).build();
    private static final SdkField<PipeTargetSqsQueueParameters> SQS_QUEUE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SqsQueueParameters").getter(PipeTargetParameters.getter(PipeTargetParameters::sqsQueueParameters)).setter(PipeTargetParameters.setter(Builder::sqsQueueParameters)).constructor(PipeTargetSqsQueueParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SqsQueueParameters").build()}).build();
    private static final SdkField<PipeTargetHttpParameters> HTTP_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HttpParameters").getter(PipeTargetParameters.getter(PipeTargetParameters::httpParameters)).setter(PipeTargetParameters.setter(Builder::httpParameters)).constructor(PipeTargetHttpParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HttpParameters").build()}).build();
    private static final SdkField<PipeTargetRedshiftDataParameters> REDSHIFT_DATA_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RedshiftDataParameters").getter(PipeTargetParameters.getter(PipeTargetParameters::redshiftDataParameters)).setter(PipeTargetParameters.setter(Builder::redshiftDataParameters)).constructor(PipeTargetRedshiftDataParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedshiftDataParameters").build()}).build();
    private static final SdkField<PipeTargetSageMakerPipelineParameters> SAGE_MAKER_PIPELINE_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SageMakerPipelineParameters").getter(PipeTargetParameters.getter(PipeTargetParameters::sageMakerPipelineParameters)).setter(PipeTargetParameters.setter(Builder::sageMakerPipelineParameters)).constructor(PipeTargetSageMakerPipelineParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SageMakerPipelineParameters").build()}).build();
    private static final SdkField<PipeTargetEventBridgeEventBusParameters> EVENT_BRIDGE_EVENT_BUS_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EventBridgeEventBusParameters").getter(PipeTargetParameters.getter(PipeTargetParameters::eventBridgeEventBusParameters)).setter(PipeTargetParameters.setter(Builder::eventBridgeEventBusParameters)).constructor(PipeTargetEventBridgeEventBusParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventBridgeEventBusParameters").build()}).build();
    private static final SdkField<PipeTargetCloudWatchLogsParameters> CLOUD_WATCH_LOGS_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CloudWatchLogsParameters").getter(PipeTargetParameters.getter(PipeTargetParameters::cloudWatchLogsParameters)).setter(PipeTargetParameters.setter(Builder::cloudWatchLogsParameters)).constructor(PipeTargetCloudWatchLogsParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLogsParameters").build()}).build();
    private static final SdkField<PipeTargetTimestreamParameters> TIMESTREAM_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TimestreamParameters").getter(PipeTargetParameters.getter(PipeTargetParameters::timestreamParameters)).setter(PipeTargetParameters.setter(Builder::timestreamParameters)).constructor(PipeTargetTimestreamParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TimestreamParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_TEMPLATE_FIELD, LAMBDA_FUNCTION_PARAMETERS_FIELD, STEP_FUNCTION_STATE_MACHINE_PARAMETERS_FIELD, KINESIS_STREAM_PARAMETERS_FIELD, ECS_TASK_PARAMETERS_FIELD, BATCH_JOB_PARAMETERS_FIELD, SQS_QUEUE_PARAMETERS_FIELD, HTTP_PARAMETERS_FIELD, REDSHIFT_DATA_PARAMETERS_FIELD, SAGE_MAKER_PIPELINE_PARAMETERS_FIELD, EVENT_BRIDGE_EVENT_BUS_PARAMETERS_FIELD, CLOUD_WATCH_LOGS_PARAMETERS_FIELD, TIMESTREAM_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PipeTargetParameters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String inputTemplate;
    private final PipeTargetLambdaFunctionParameters lambdaFunctionParameters;
    private final PipeTargetStateMachineParameters stepFunctionStateMachineParameters;
    private final PipeTargetKinesisStreamParameters kinesisStreamParameters;
    private final PipeTargetEcsTaskParameters ecsTaskParameters;
    private final PipeTargetBatchJobParameters batchJobParameters;
    private final PipeTargetSqsQueueParameters sqsQueueParameters;
    private final PipeTargetHttpParameters httpParameters;
    private final PipeTargetRedshiftDataParameters redshiftDataParameters;
    private final PipeTargetSageMakerPipelineParameters sageMakerPipelineParameters;
    private final PipeTargetEventBridgeEventBusParameters eventBridgeEventBusParameters;
    private final PipeTargetCloudWatchLogsParameters cloudWatchLogsParameters;
    private final PipeTargetTimestreamParameters timestreamParameters;

    private PipeTargetParameters(BuilderImpl builder) {
        this.inputTemplate = builder.inputTemplate;
        this.lambdaFunctionParameters = builder.lambdaFunctionParameters;
        this.stepFunctionStateMachineParameters = builder.stepFunctionStateMachineParameters;
        this.kinesisStreamParameters = builder.kinesisStreamParameters;
        this.ecsTaskParameters = builder.ecsTaskParameters;
        this.batchJobParameters = builder.batchJobParameters;
        this.sqsQueueParameters = builder.sqsQueueParameters;
        this.httpParameters = builder.httpParameters;
        this.redshiftDataParameters = builder.redshiftDataParameters;
        this.sageMakerPipelineParameters = builder.sageMakerPipelineParameters;
        this.eventBridgeEventBusParameters = builder.eventBridgeEventBusParameters;
        this.cloudWatchLogsParameters = builder.cloudWatchLogsParameters;
        this.timestreamParameters = builder.timestreamParameters;
    }

    public final String inputTemplate() {
        return this.inputTemplate;
    }

    public final PipeTargetLambdaFunctionParameters lambdaFunctionParameters() {
        return this.lambdaFunctionParameters;
    }

    public final PipeTargetStateMachineParameters stepFunctionStateMachineParameters() {
        return this.stepFunctionStateMachineParameters;
    }

    public final PipeTargetKinesisStreamParameters kinesisStreamParameters() {
        return this.kinesisStreamParameters;
    }

    public final PipeTargetEcsTaskParameters ecsTaskParameters() {
        return this.ecsTaskParameters;
    }

    public final PipeTargetBatchJobParameters batchJobParameters() {
        return this.batchJobParameters;
    }

    public final PipeTargetSqsQueueParameters sqsQueueParameters() {
        return this.sqsQueueParameters;
    }

    public final PipeTargetHttpParameters httpParameters() {
        return this.httpParameters;
    }

    public final PipeTargetRedshiftDataParameters redshiftDataParameters() {
        return this.redshiftDataParameters;
    }

    public final PipeTargetSageMakerPipelineParameters sageMakerPipelineParameters() {
        return this.sageMakerPipelineParameters;
    }

    public final PipeTargetEventBridgeEventBusParameters eventBridgeEventBusParameters() {
        return this.eventBridgeEventBusParameters;
    }

    public final PipeTargetCloudWatchLogsParameters cloudWatchLogsParameters() {
        return this.cloudWatchLogsParameters;
    }

    public final PipeTargetTimestreamParameters timestreamParameters() {
        return this.timestreamParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(this.lambdaFunctionParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepFunctionStateMachineParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisStreamParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsTaskParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchJobParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsQueueParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.httpParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftDataParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.sageMakerPipelineParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventBridgeEventBusParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogsParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestreamParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PipeTargetParameters)) {
            return false;
        }
        PipeTargetParameters other = (PipeTargetParameters)obj;
        return Objects.equals(this.inputTemplate(), other.inputTemplate()) && Objects.equals(this.lambdaFunctionParameters(), other.lambdaFunctionParameters()) && Objects.equals(this.stepFunctionStateMachineParameters(), other.stepFunctionStateMachineParameters()) && Objects.equals(this.kinesisStreamParameters(), other.kinesisStreamParameters()) && Objects.equals(this.ecsTaskParameters(), other.ecsTaskParameters()) && Objects.equals(this.batchJobParameters(), other.batchJobParameters()) && Objects.equals(this.sqsQueueParameters(), other.sqsQueueParameters()) && Objects.equals(this.httpParameters(), other.httpParameters()) && Objects.equals(this.redshiftDataParameters(), other.redshiftDataParameters()) && Objects.equals(this.sageMakerPipelineParameters(), other.sageMakerPipelineParameters()) && Objects.equals(this.eventBridgeEventBusParameters(), other.eventBridgeEventBusParameters()) && Objects.equals(this.cloudWatchLogsParameters(), other.cloudWatchLogsParameters()) && Objects.equals(this.timestreamParameters(), other.timestreamParameters());
    }

    public final String toString() {
        return ToString.builder((String)"PipeTargetParameters").add("InputTemplate", (Object)(this.inputTemplate() == null ? null : "*** Sensitive Data Redacted ***")).add("LambdaFunctionParameters", (Object)this.lambdaFunctionParameters()).add("StepFunctionStateMachineParameters", (Object)this.stepFunctionStateMachineParameters()).add("KinesisStreamParameters", (Object)this.kinesisStreamParameters()).add("EcsTaskParameters", (Object)this.ecsTaskParameters()).add("BatchJobParameters", (Object)this.batchJobParameters()).add("SqsQueueParameters", (Object)this.sqsQueueParameters()).add("HttpParameters", (Object)this.httpParameters()).add("RedshiftDataParameters", (Object)this.redshiftDataParameters()).add("SageMakerPipelineParameters", (Object)this.sageMakerPipelineParameters()).add("EventBridgeEventBusParameters", (Object)this.eventBridgeEventBusParameters()).add("CloudWatchLogsParameters", (Object)this.cloudWatchLogsParameters()).add("TimestreamParameters", (Object)this.timestreamParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InputTemplate": {
                return Optional.ofNullable(clazz.cast(this.inputTemplate()));
            }
            case "LambdaFunctionParameters": {
                return Optional.ofNullable(clazz.cast(this.lambdaFunctionParameters()));
            }
            case "StepFunctionStateMachineParameters": {
                return Optional.ofNullable(clazz.cast(this.stepFunctionStateMachineParameters()));
            }
            case "KinesisStreamParameters": {
                return Optional.ofNullable(clazz.cast(this.kinesisStreamParameters()));
            }
            case "EcsTaskParameters": {
                return Optional.ofNullable(clazz.cast(this.ecsTaskParameters()));
            }
            case "BatchJobParameters": {
                return Optional.ofNullable(clazz.cast(this.batchJobParameters()));
            }
            case "SqsQueueParameters": {
                return Optional.ofNullable(clazz.cast(this.sqsQueueParameters()));
            }
            case "HttpParameters": {
                return Optional.ofNullable(clazz.cast(this.httpParameters()));
            }
            case "RedshiftDataParameters": {
                return Optional.ofNullable(clazz.cast(this.redshiftDataParameters()));
            }
            case "SageMakerPipelineParameters": {
                return Optional.ofNullable(clazz.cast(this.sageMakerPipelineParameters()));
            }
            case "EventBridgeEventBusParameters": {
                return Optional.ofNullable(clazz.cast(this.eventBridgeEventBusParameters()));
            }
            case "CloudWatchLogsParameters": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogsParameters()));
            }
            case "TimestreamParameters": {
                return Optional.ofNullable(clazz.cast(this.timestreamParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InputTemplate", INPUT_TEMPLATE_FIELD);
        map.put("LambdaFunctionParameters", LAMBDA_FUNCTION_PARAMETERS_FIELD);
        map.put("StepFunctionStateMachineParameters", STEP_FUNCTION_STATE_MACHINE_PARAMETERS_FIELD);
        map.put("KinesisStreamParameters", KINESIS_STREAM_PARAMETERS_FIELD);
        map.put("EcsTaskParameters", ECS_TASK_PARAMETERS_FIELD);
        map.put("BatchJobParameters", BATCH_JOB_PARAMETERS_FIELD);
        map.put("SqsQueueParameters", SQS_QUEUE_PARAMETERS_FIELD);
        map.put("HttpParameters", HTTP_PARAMETERS_FIELD);
        map.put("RedshiftDataParameters", REDSHIFT_DATA_PARAMETERS_FIELD);
        map.put("SageMakerPipelineParameters", SAGE_MAKER_PIPELINE_PARAMETERS_FIELD);
        map.put("EventBridgeEventBusParameters", EVENT_BRIDGE_EVENT_BUS_PARAMETERS_FIELD);
        map.put("CloudWatchLogsParameters", CLOUD_WATCH_LOGS_PARAMETERS_FIELD);
        map.put("TimestreamParameters", TIMESTREAM_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PipeTargetParameters, T> g) {
        return obj -> g.apply((PipeTargetParameters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String inputTemplate;
        private PipeTargetLambdaFunctionParameters lambdaFunctionParameters;
        private PipeTargetStateMachineParameters stepFunctionStateMachineParameters;
        private PipeTargetKinesisStreamParameters kinesisStreamParameters;
        private PipeTargetEcsTaskParameters ecsTaskParameters;
        private PipeTargetBatchJobParameters batchJobParameters;
        private PipeTargetSqsQueueParameters sqsQueueParameters;
        private PipeTargetHttpParameters httpParameters;
        private PipeTargetRedshiftDataParameters redshiftDataParameters;
        private PipeTargetSageMakerPipelineParameters sageMakerPipelineParameters;
        private PipeTargetEventBridgeEventBusParameters eventBridgeEventBusParameters;
        private PipeTargetCloudWatchLogsParameters cloudWatchLogsParameters;
        private PipeTargetTimestreamParameters timestreamParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(PipeTargetParameters model) {
            this.inputTemplate(model.inputTemplate);
            this.lambdaFunctionParameters(model.lambdaFunctionParameters);
            this.stepFunctionStateMachineParameters(model.stepFunctionStateMachineParameters);
            this.kinesisStreamParameters(model.kinesisStreamParameters);
            this.ecsTaskParameters(model.ecsTaskParameters);
            this.batchJobParameters(model.batchJobParameters);
            this.sqsQueueParameters(model.sqsQueueParameters);
            this.httpParameters(model.httpParameters);
            this.redshiftDataParameters(model.redshiftDataParameters);
            this.sageMakerPipelineParameters(model.sageMakerPipelineParameters);
            this.eventBridgeEventBusParameters(model.eventBridgeEventBusParameters);
            this.cloudWatchLogsParameters(model.cloudWatchLogsParameters);
            this.timestreamParameters(model.timestreamParameters);
        }

        public final String getInputTemplate() {
            return this.inputTemplate;
        }

        public final void setInputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
        }

        @Override
        public final Builder inputTemplate(String inputTemplate) {
            this.inputTemplate = inputTemplate;
            return this;
        }

        public final PipeTargetLambdaFunctionParameters.Builder getLambdaFunctionParameters() {
            return this.lambdaFunctionParameters != null ? this.lambdaFunctionParameters.toBuilder() : null;
        }

        public final void setLambdaFunctionParameters(PipeTargetLambdaFunctionParameters.BuilderImpl lambdaFunctionParameters) {
            this.lambdaFunctionParameters = lambdaFunctionParameters != null ? lambdaFunctionParameters.build() : null;
        }

        @Override
        public final Builder lambdaFunctionParameters(PipeTargetLambdaFunctionParameters lambdaFunctionParameters) {
            this.lambdaFunctionParameters = lambdaFunctionParameters;
            return this;
        }

        public final PipeTargetStateMachineParameters.Builder getStepFunctionStateMachineParameters() {
            return this.stepFunctionStateMachineParameters != null ? this.stepFunctionStateMachineParameters.toBuilder() : null;
        }

        public final void setStepFunctionStateMachineParameters(PipeTargetStateMachineParameters.BuilderImpl stepFunctionStateMachineParameters) {
            this.stepFunctionStateMachineParameters = stepFunctionStateMachineParameters != null ? stepFunctionStateMachineParameters.build() : null;
        }

        @Override
        public final Builder stepFunctionStateMachineParameters(PipeTargetStateMachineParameters stepFunctionStateMachineParameters) {
            this.stepFunctionStateMachineParameters = stepFunctionStateMachineParameters;
            return this;
        }

        public final PipeTargetKinesisStreamParameters.Builder getKinesisStreamParameters() {
            return this.kinesisStreamParameters != null ? this.kinesisStreamParameters.toBuilder() : null;
        }

        public final void setKinesisStreamParameters(PipeTargetKinesisStreamParameters.BuilderImpl kinesisStreamParameters) {
            this.kinesisStreamParameters = kinesisStreamParameters != null ? kinesisStreamParameters.build() : null;
        }

        @Override
        public final Builder kinesisStreamParameters(PipeTargetKinesisStreamParameters kinesisStreamParameters) {
            this.kinesisStreamParameters = kinesisStreamParameters;
            return this;
        }

        public final PipeTargetEcsTaskParameters.Builder getEcsTaskParameters() {
            return this.ecsTaskParameters != null ? this.ecsTaskParameters.toBuilder() : null;
        }

        public final void setEcsTaskParameters(PipeTargetEcsTaskParameters.BuilderImpl ecsTaskParameters) {
            this.ecsTaskParameters = ecsTaskParameters != null ? ecsTaskParameters.build() : null;
        }

        @Override
        public final Builder ecsTaskParameters(PipeTargetEcsTaskParameters ecsTaskParameters) {
            this.ecsTaskParameters = ecsTaskParameters;
            return this;
        }

        public final PipeTargetBatchJobParameters.Builder getBatchJobParameters() {
            return this.batchJobParameters != null ? this.batchJobParameters.toBuilder() : null;
        }

        public final void setBatchJobParameters(PipeTargetBatchJobParameters.BuilderImpl batchJobParameters) {
            this.batchJobParameters = batchJobParameters != null ? batchJobParameters.build() : null;
        }

        @Override
        public final Builder batchJobParameters(PipeTargetBatchJobParameters batchJobParameters) {
            this.batchJobParameters = batchJobParameters;
            return this;
        }

        public final PipeTargetSqsQueueParameters.Builder getSqsQueueParameters() {
            return this.sqsQueueParameters != null ? this.sqsQueueParameters.toBuilder() : null;
        }

        public final void setSqsQueueParameters(PipeTargetSqsQueueParameters.BuilderImpl sqsQueueParameters) {
            this.sqsQueueParameters = sqsQueueParameters != null ? sqsQueueParameters.build() : null;
        }

        @Override
        public final Builder sqsQueueParameters(PipeTargetSqsQueueParameters sqsQueueParameters) {
            this.sqsQueueParameters = sqsQueueParameters;
            return this;
        }

        public final PipeTargetHttpParameters.Builder getHttpParameters() {
            return this.httpParameters != null ? this.httpParameters.toBuilder() : null;
        }

        public final void setHttpParameters(PipeTargetHttpParameters.BuilderImpl httpParameters) {
            this.httpParameters = httpParameters != null ? httpParameters.build() : null;
        }

        @Override
        public final Builder httpParameters(PipeTargetHttpParameters httpParameters) {
            this.httpParameters = httpParameters;
            return this;
        }

        public final PipeTargetRedshiftDataParameters.Builder getRedshiftDataParameters() {
            return this.redshiftDataParameters != null ? this.redshiftDataParameters.toBuilder() : null;
        }

        public final void setRedshiftDataParameters(PipeTargetRedshiftDataParameters.BuilderImpl redshiftDataParameters) {
            this.redshiftDataParameters = redshiftDataParameters != null ? redshiftDataParameters.build() : null;
        }

        @Override
        public final Builder redshiftDataParameters(PipeTargetRedshiftDataParameters redshiftDataParameters) {
            this.redshiftDataParameters = redshiftDataParameters;
            return this;
        }

        public final PipeTargetSageMakerPipelineParameters.Builder getSageMakerPipelineParameters() {
            return this.sageMakerPipelineParameters != null ? this.sageMakerPipelineParameters.toBuilder() : null;
        }

        public final void setSageMakerPipelineParameters(PipeTargetSageMakerPipelineParameters.BuilderImpl sageMakerPipelineParameters) {
            this.sageMakerPipelineParameters = sageMakerPipelineParameters != null ? sageMakerPipelineParameters.build() : null;
        }

        @Override
        public final Builder sageMakerPipelineParameters(PipeTargetSageMakerPipelineParameters sageMakerPipelineParameters) {
            this.sageMakerPipelineParameters = sageMakerPipelineParameters;
            return this;
        }

        public final PipeTargetEventBridgeEventBusParameters.Builder getEventBridgeEventBusParameters() {
            return this.eventBridgeEventBusParameters != null ? this.eventBridgeEventBusParameters.toBuilder() : null;
        }

        public final void setEventBridgeEventBusParameters(PipeTargetEventBridgeEventBusParameters.BuilderImpl eventBridgeEventBusParameters) {
            this.eventBridgeEventBusParameters = eventBridgeEventBusParameters != null ? eventBridgeEventBusParameters.build() : null;
        }

        @Override
        public final Builder eventBridgeEventBusParameters(PipeTargetEventBridgeEventBusParameters eventBridgeEventBusParameters) {
            this.eventBridgeEventBusParameters = eventBridgeEventBusParameters;
            return this;
        }

        public final PipeTargetCloudWatchLogsParameters.Builder getCloudWatchLogsParameters() {
            return this.cloudWatchLogsParameters != null ? this.cloudWatchLogsParameters.toBuilder() : null;
        }

        public final void setCloudWatchLogsParameters(PipeTargetCloudWatchLogsParameters.BuilderImpl cloudWatchLogsParameters) {
            this.cloudWatchLogsParameters = cloudWatchLogsParameters != null ? cloudWatchLogsParameters.build() : null;
        }

        @Override
        public final Builder cloudWatchLogsParameters(PipeTargetCloudWatchLogsParameters cloudWatchLogsParameters) {
            this.cloudWatchLogsParameters = cloudWatchLogsParameters;
            return this;
        }

        public final PipeTargetTimestreamParameters.Builder getTimestreamParameters() {
            return this.timestreamParameters != null ? this.timestreamParameters.toBuilder() : null;
        }

        public final void setTimestreamParameters(PipeTargetTimestreamParameters.BuilderImpl timestreamParameters) {
            this.timestreamParameters = timestreamParameters != null ? timestreamParameters.build() : null;
        }

        @Override
        public final Builder timestreamParameters(PipeTargetTimestreamParameters timestreamParameters) {
            this.timestreamParameters = timestreamParameters;
            return this;
        }

        public PipeTargetParameters build() {
            return new PipeTargetParameters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PipeTargetParameters> {
        public Builder inputTemplate(String var1);

        public Builder lambdaFunctionParameters(PipeTargetLambdaFunctionParameters var1);

        default public Builder lambdaFunctionParameters(Consumer<PipeTargetLambdaFunctionParameters.Builder> lambdaFunctionParameters) {
            return this.lambdaFunctionParameters((PipeTargetLambdaFunctionParameters)((PipeTargetLambdaFunctionParameters.Builder)PipeTargetLambdaFunctionParameters.builder().applyMutation(lambdaFunctionParameters)).build());
        }

        public Builder stepFunctionStateMachineParameters(PipeTargetStateMachineParameters var1);

        default public Builder stepFunctionStateMachineParameters(Consumer<PipeTargetStateMachineParameters.Builder> stepFunctionStateMachineParameters) {
            return this.stepFunctionStateMachineParameters((PipeTargetStateMachineParameters)((PipeTargetStateMachineParameters.Builder)PipeTargetStateMachineParameters.builder().applyMutation(stepFunctionStateMachineParameters)).build());
        }

        public Builder kinesisStreamParameters(PipeTargetKinesisStreamParameters var1);

        default public Builder kinesisStreamParameters(Consumer<PipeTargetKinesisStreamParameters.Builder> kinesisStreamParameters) {
            return this.kinesisStreamParameters((PipeTargetKinesisStreamParameters)((PipeTargetKinesisStreamParameters.Builder)PipeTargetKinesisStreamParameters.builder().applyMutation(kinesisStreamParameters)).build());
        }

        public Builder ecsTaskParameters(PipeTargetEcsTaskParameters var1);

        default public Builder ecsTaskParameters(Consumer<PipeTargetEcsTaskParameters.Builder> ecsTaskParameters) {
            return this.ecsTaskParameters((PipeTargetEcsTaskParameters)((PipeTargetEcsTaskParameters.Builder)PipeTargetEcsTaskParameters.builder().applyMutation(ecsTaskParameters)).build());
        }

        public Builder batchJobParameters(PipeTargetBatchJobParameters var1);

        default public Builder batchJobParameters(Consumer<PipeTargetBatchJobParameters.Builder> batchJobParameters) {
            return this.batchJobParameters((PipeTargetBatchJobParameters)((PipeTargetBatchJobParameters.Builder)PipeTargetBatchJobParameters.builder().applyMutation(batchJobParameters)).build());
        }

        public Builder sqsQueueParameters(PipeTargetSqsQueueParameters var1);

        default public Builder sqsQueueParameters(Consumer<PipeTargetSqsQueueParameters.Builder> sqsQueueParameters) {
            return this.sqsQueueParameters((PipeTargetSqsQueueParameters)((PipeTargetSqsQueueParameters.Builder)PipeTargetSqsQueueParameters.builder().applyMutation(sqsQueueParameters)).build());
        }

        public Builder httpParameters(PipeTargetHttpParameters var1);

        default public Builder httpParameters(Consumer<PipeTargetHttpParameters.Builder> httpParameters) {
            return this.httpParameters((PipeTargetHttpParameters)((PipeTargetHttpParameters.Builder)PipeTargetHttpParameters.builder().applyMutation(httpParameters)).build());
        }

        public Builder redshiftDataParameters(PipeTargetRedshiftDataParameters var1);

        default public Builder redshiftDataParameters(Consumer<PipeTargetRedshiftDataParameters.Builder> redshiftDataParameters) {
            return this.redshiftDataParameters((PipeTargetRedshiftDataParameters)((PipeTargetRedshiftDataParameters.Builder)PipeTargetRedshiftDataParameters.builder().applyMutation(redshiftDataParameters)).build());
        }

        public Builder sageMakerPipelineParameters(PipeTargetSageMakerPipelineParameters var1);

        default public Builder sageMakerPipelineParameters(Consumer<PipeTargetSageMakerPipelineParameters.Builder> sageMakerPipelineParameters) {
            return this.sageMakerPipelineParameters((PipeTargetSageMakerPipelineParameters)((PipeTargetSageMakerPipelineParameters.Builder)PipeTargetSageMakerPipelineParameters.builder().applyMutation(sageMakerPipelineParameters)).build());
        }

        public Builder eventBridgeEventBusParameters(PipeTargetEventBridgeEventBusParameters var1);

        default public Builder eventBridgeEventBusParameters(Consumer<PipeTargetEventBridgeEventBusParameters.Builder> eventBridgeEventBusParameters) {
            return this.eventBridgeEventBusParameters((PipeTargetEventBridgeEventBusParameters)((PipeTargetEventBridgeEventBusParameters.Builder)PipeTargetEventBridgeEventBusParameters.builder().applyMutation(eventBridgeEventBusParameters)).build());
        }

        public Builder cloudWatchLogsParameters(PipeTargetCloudWatchLogsParameters var1);

        default public Builder cloudWatchLogsParameters(Consumer<PipeTargetCloudWatchLogsParameters.Builder> cloudWatchLogsParameters) {
            return this.cloudWatchLogsParameters((PipeTargetCloudWatchLogsParameters)((PipeTargetCloudWatchLogsParameters.Builder)PipeTargetCloudWatchLogsParameters.builder().applyMutation(cloudWatchLogsParameters)).build());
        }

        public Builder timestreamParameters(PipeTargetTimestreamParameters var1);

        default public Builder timestreamParameters(Consumer<PipeTargetTimestreamParameters.Builder> timestreamParameters) {
            return this.timestreamParameters((PipeTargetTimestreamParameters)((PipeTargetTimestreamParameters.Builder)PipeTargetTimestreamParameters.builder().applyMutation(timestreamParameters)).build());
        }
    }
}

