/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AssistantAssociationIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeSource> {
    private static final SdkField<List<String>> ASSISTANT_ASSOCIATION_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assistantAssociationIds").getter(KnowledgeSource.getter(KnowledgeSource::assistantAssociationIds)).setter(KnowledgeSource.setter(Builder::assistantAssociationIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assistantAssociationIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ASSOCIATION_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KnowledgeSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> assistantAssociationIds;
    private final Type type;

    private KnowledgeSource(BuilderImpl builder) {
        this.assistantAssociationIds = builder.assistantAssociationIds;
        this.type = builder.type;
    }

    public final boolean hasAssistantAssociationIds() {
        return this.assistantAssociationIds != null && !(this.assistantAssociationIds instanceof SdkAutoConstructList);
    }

    public final List<String> assistantAssociationIds() {
        return this.assistantAssociationIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssistantAssociationIds() ? this.assistantAssociationIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeSource)) {
            return false;
        }
        KnowledgeSource other = (KnowledgeSource)obj;
        return this.hasAssistantAssociationIds() == other.hasAssistantAssociationIds() && Objects.equals(this.assistantAssociationIds(), other.assistantAssociationIds());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeSource").add("AssistantAssociationIds", this.hasAssistantAssociationIds() ? this.assistantAssociationIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantAssociationIds": {
                return Optional.ofNullable(clazz.cast(this.assistantAssociationIds()));
            }
        }
        return Optional.empty();
    }

    public static KnowledgeSource fromAssistantAssociationIds(List<String> assistantAssociationIds) {
        return (KnowledgeSource)KnowledgeSource.builder().assistantAssociationIds(assistantAssociationIds).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("assistantAssociationIds", ASSISTANT_ASSOCIATION_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeSource, T> g) {
        return obj -> g.apply((KnowledgeSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ASSISTANT_ASSOCIATION_IDS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private List<String> assistantAssociationIds = DefaultSdkAutoConstructList.getInstance();
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeSource model) {
            this.assistantAssociationIds(model.assistantAssociationIds);
        }

        public final Collection<String> getAssistantAssociationIds() {
            if (this.assistantAssociationIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.assistantAssociationIds;
        }

        public final void setAssistantAssociationIds(Collection<String> assistantAssociationIds) {
            List<String> oldValue = this.assistantAssociationIds;
            this.assistantAssociationIds = AssistantAssociationIdListCopier.copy(assistantAssociationIds);
            this.handleUnionValueChange(Type.ASSISTANT_ASSOCIATION_IDS, oldValue, this.assistantAssociationIds);
        }

        @Override
        public final Builder assistantAssociationIds(Collection<String> assistantAssociationIds) {
            List<String> oldValue = this.assistantAssociationIds;
            this.assistantAssociationIds = AssistantAssociationIdListCopier.copy(assistantAssociationIds);
            this.handleUnionValueChange(Type.ASSISTANT_ASSOCIATION_IDS, oldValue, this.assistantAssociationIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assistantAssociationIds(String ... assistantAssociationIds) {
            this.assistantAssociationIds(Arrays.asList(assistantAssociationIds));
            return this;
        }

        public KnowledgeSource build() {
            return new KnowledgeSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeSource> {
        public Builder assistantAssociationIds(Collection<String> var1);

        public Builder assistantAssociationIds(String ... var1);
    }
}

