/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.TextMessage;
import software.amazon.awssdk.services.qconnect.model.ToolUseResultData;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageData> {
    private static final SdkField<TextMessage> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("text").getter(MessageData.getter(MessageData::text)).setter(MessageData.setter(Builder::text)).constructor(TextMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<ToolUseResultData> TOOL_USE_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolUseResult").getter(MessageData.getter(MessageData::toolUseResult)).setter(MessageData.setter(Builder::toolUseResult)).constructor(ToolUseResultData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUseResult").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, TOOL_USE_RESULT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageData.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final TextMessage text;
    private final ToolUseResultData toolUseResult;
    private final Type type;

    private MessageData(BuilderImpl builder) {
        this.text = builder.text;
        this.toolUseResult = builder.toolUseResult;
        this.type = builder.type;
    }

    public final TextMessage text() {
        return this.text;
    }

    public final ToolUseResultData toolUseResult() {
        return this.toolUseResult;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolUseResult());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageData)) {
            return false;
        }
        MessageData other = (MessageData)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.toolUseResult(), other.toolUseResult());
    }

    public final String toString() {
        return ToString.builder((String)"MessageData").add("Text", (Object)this.text()).add("ToolUseResult", (Object)this.toolUseResult()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "toolUseResult": {
                return Optional.ofNullable(clazz.cast(this.toolUseResult()));
            }
        }
        return Optional.empty();
    }

    public static MessageData fromText(TextMessage text) {
        return (MessageData)MessageData.builder().text(text).build();
    }

    public static MessageData fromText(Consumer<TextMessage.Builder> text) {
        TextMessage.Builder builder = TextMessage.builder();
        text.accept(builder);
        return MessageData.fromText((TextMessage)builder.build());
    }

    public static MessageData fromToolUseResult(ToolUseResultData toolUseResult) {
        return (MessageData)MessageData.builder().toolUseResult(toolUseResult).build();
    }

    public static MessageData fromToolUseResult(Consumer<ToolUseResultData.Builder> toolUseResult) {
        ToolUseResultData.Builder builder = ToolUseResultData.builder();
        toolUseResult.accept(builder);
        return MessageData.fromToolUseResult((ToolUseResultData)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", TEXT_FIELD);
        map.put("toolUseResult", TOOL_USE_RESULT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageData, T> g) {
        return obj -> g.apply((MessageData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT,
        TOOL_USE_RESULT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private TextMessage text;
        private ToolUseResultData toolUseResult;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MessageData model) {
            this.text(model.text);
            this.toolUseResult(model.toolUseResult);
        }

        public final TextMessage.Builder getText() {
            return this.text != null ? this.text.toBuilder() : null;
        }

        public final void setText(TextMessage.BuilderImpl text) {
            TextMessage oldValue = this.text;
            this.text = text != null ? text.build() : null;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(TextMessage text) {
            TextMessage oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final ToolUseResultData.Builder getToolUseResult() {
            return this.toolUseResult != null ? this.toolUseResult.toBuilder() : null;
        }

        public final void setToolUseResult(ToolUseResultData.BuilderImpl toolUseResult) {
            ToolUseResultData oldValue = this.toolUseResult;
            this.toolUseResult = toolUseResult != null ? toolUseResult.build() : null;
            this.handleUnionValueChange(Type.TOOL_USE_RESULT, oldValue, this.toolUseResult);
        }

        @Override
        public final Builder toolUseResult(ToolUseResultData toolUseResult) {
            ToolUseResultData oldValue = this.toolUseResult;
            this.toolUseResult = toolUseResult;
            this.handleUnionValueChange(Type.TOOL_USE_RESULT, oldValue, this.toolUseResult);
            return this;
        }

        public MessageData build() {
            return new MessageData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageData> {
        public Builder text(TextMessage var1);

        default public Builder text(Consumer<TextMessage.Builder> text) {
            return this.text((TextMessage)((TextMessage.Builder)TextMessage.builder().applyMutation(text)).build());
        }

        public Builder toolUseResult(ToolUseResultData var1);

        default public Builder toolUseResult(Consumer<ToolUseResultData.Builder> toolUseResult) {
            return this.toolUseResult((ToolUseResultData)((ToolUseResultData.Builder)ToolUseResultData.builder().applyMutation(toolUseResult)).build());
        }
    }
}

