/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.qconnect.model.AgentAttributes;
import software.amazon.awssdk.services.qconnect.model.CustomAttributesCopier;
import software.amazon.awssdk.services.qconnect.model.CustomerProfileAttributes;
import software.amazon.awssdk.services.qconnect.model.SystemAttributes;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MessageTemplateAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MessageTemplateAttributes> {
    private static final SdkField<SystemAttributes> SYSTEM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("systemAttributes").getter(MessageTemplateAttributes.getter(MessageTemplateAttributes::systemAttributes)).setter(MessageTemplateAttributes.setter(Builder::systemAttributes)).constructor(SystemAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemAttributes").build()}).build();
    private static final SdkField<AgentAttributes> AGENT_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agentAttributes").getter(MessageTemplateAttributes.getter(MessageTemplateAttributes::agentAttributes)).setter(MessageTemplateAttributes.setter(Builder::agentAttributes)).constructor(AgentAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentAttributes").build()}).build();
    private static final SdkField<CustomerProfileAttributes> CUSTOMER_PROFILE_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customerProfileAttributes").getter(MessageTemplateAttributes.getter(MessageTemplateAttributes::customerProfileAttributes)).setter(MessageTemplateAttributes.setter(Builder::customerProfileAttributes)).constructor(CustomerProfileAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerProfileAttributes").build()}).build();
    private static final SdkField<Map<String, String>> CUSTOM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("customAttributes").getter(MessageTemplateAttributes.getter(MessageTemplateAttributes::customAttributes)).setter(MessageTemplateAttributes.setter(Builder::customAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAttributes").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYSTEM_ATTRIBUTES_FIELD, AGENT_ATTRIBUTES_FIELD, CUSTOMER_PROFILE_ATTRIBUTES_FIELD, CUSTOM_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = MessageTemplateAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final SystemAttributes systemAttributes;
    private final AgentAttributes agentAttributes;
    private final CustomerProfileAttributes customerProfileAttributes;
    private final Map<String, String> customAttributes;

    private MessageTemplateAttributes(BuilderImpl builder) {
        this.systemAttributes = builder.systemAttributes;
        this.agentAttributes = builder.agentAttributes;
        this.customerProfileAttributes = builder.customerProfileAttributes;
        this.customAttributes = builder.customAttributes;
    }

    public final SystemAttributes systemAttributes() {
        return this.systemAttributes;
    }

    public final AgentAttributes agentAttributes() {
        return this.agentAttributes;
    }

    public final CustomerProfileAttributes customerProfileAttributes() {
        return this.customerProfileAttributes;
    }

    public final boolean hasCustomAttributes() {
        return this.customAttributes != null && !(this.customAttributes instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> customAttributes() {
        return this.customAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.systemAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerProfileAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAttributes() ? this.customAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MessageTemplateAttributes)) {
            return false;
        }
        MessageTemplateAttributes other = (MessageTemplateAttributes)obj;
        return Objects.equals(this.systemAttributes(), other.systemAttributes()) && Objects.equals(this.agentAttributes(), other.agentAttributes()) && Objects.equals(this.customerProfileAttributes(), other.customerProfileAttributes()) && this.hasCustomAttributes() == other.hasCustomAttributes() && Objects.equals(this.customAttributes(), other.customAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"MessageTemplateAttributes").add("SystemAttributes", (Object)this.systemAttributes()).add("AgentAttributes", (Object)this.agentAttributes()).add("CustomerProfileAttributes", (Object)this.customerProfileAttributes()).add("CustomAttributes", (Object)(this.customAttributes() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "systemAttributes": {
                return Optional.ofNullable(clazz.cast(this.systemAttributes()));
            }
            case "agentAttributes": {
                return Optional.ofNullable(clazz.cast(this.agentAttributes()));
            }
            case "customerProfileAttributes": {
                return Optional.ofNullable(clazz.cast(this.customerProfileAttributes()));
            }
            case "customAttributes": {
                return Optional.ofNullable(clazz.cast(this.customAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("systemAttributes", SYSTEM_ATTRIBUTES_FIELD);
        map.put("agentAttributes", AGENT_ATTRIBUTES_FIELD);
        map.put("customerProfileAttributes", CUSTOMER_PROFILE_ATTRIBUTES_FIELD);
        map.put("customAttributes", CUSTOM_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MessageTemplateAttributes, T> g) {
        return obj -> g.apply((MessageTemplateAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SystemAttributes systemAttributes;
        private AgentAttributes agentAttributes;
        private CustomerProfileAttributes customerProfileAttributes;
        private Map<String, String> customAttributes = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MessageTemplateAttributes model) {
            this.systemAttributes(model.systemAttributes);
            this.agentAttributes(model.agentAttributes);
            this.customerProfileAttributes(model.customerProfileAttributes);
            this.customAttributes(model.customAttributes);
        }

        public final SystemAttributes.Builder getSystemAttributes() {
            return this.systemAttributes != null ? this.systemAttributes.toBuilder() : null;
        }

        public final void setSystemAttributes(SystemAttributes.BuilderImpl systemAttributes) {
            this.systemAttributes = systemAttributes != null ? systemAttributes.build() : null;
        }

        @Override
        public final Builder systemAttributes(SystemAttributes systemAttributes) {
            this.systemAttributes = systemAttributes;
            return this;
        }

        public final AgentAttributes.Builder getAgentAttributes() {
            return this.agentAttributes != null ? this.agentAttributes.toBuilder() : null;
        }

        public final void setAgentAttributes(AgentAttributes.BuilderImpl agentAttributes) {
            this.agentAttributes = agentAttributes != null ? agentAttributes.build() : null;
        }

        @Override
        public final Builder agentAttributes(AgentAttributes agentAttributes) {
            this.agentAttributes = agentAttributes;
            return this;
        }

        public final CustomerProfileAttributes.Builder getCustomerProfileAttributes() {
            return this.customerProfileAttributes != null ? this.customerProfileAttributes.toBuilder() : null;
        }

        public final void setCustomerProfileAttributes(CustomerProfileAttributes.BuilderImpl customerProfileAttributes) {
            this.customerProfileAttributes = customerProfileAttributes != null ? customerProfileAttributes.build() : null;
        }

        @Override
        public final Builder customerProfileAttributes(CustomerProfileAttributes customerProfileAttributes) {
            this.customerProfileAttributes = customerProfileAttributes;
            return this;
        }

        public final Map<String, String> getCustomAttributes() {
            if (this.customAttributes instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.customAttributes;
        }

        public final void setCustomAttributes(Map<String, String> customAttributes) {
            this.customAttributes = CustomAttributesCopier.copy(customAttributes);
        }

        @Override
        public final Builder customAttributes(Map<String, String> customAttributes) {
            this.customAttributes = CustomAttributesCopier.copy(customAttributes);
            return this;
        }

        public MessageTemplateAttributes build() {
            return new MessageTemplateAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MessageTemplateAttributes> {
        public Builder systemAttributes(SystemAttributes var1);

        default public Builder systemAttributes(Consumer<SystemAttributes.Builder> systemAttributes) {
            return this.systemAttributes((SystemAttributes)((SystemAttributes.Builder)SystemAttributes.builder().applyMutation(systemAttributes)).build());
        }

        public Builder agentAttributes(AgentAttributes var1);

        default public Builder agentAttributes(Consumer<AgentAttributes.Builder> agentAttributes) {
            return this.agentAttributes((AgentAttributes)((AgentAttributes.Builder)AgentAttributes.builder().applyMutation(agentAttributes)).build());
        }

        public Builder customerProfileAttributes(CustomerProfileAttributes var1);

        default public Builder customerProfileAttributes(Consumer<CustomerProfileAttributes.Builder> customerProfileAttributes) {
            return this.customerProfileAttributes((CustomerProfileAttributes)((CustomerProfileAttributes.Builder)CustomerProfileAttributes.builder().applyMutation(customerProfileAttributes)).build());
        }

        public Builder customAttributes(Map<String, String> var1);
    }
}

