/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ParsingStrategy {
    BEDROCK_FOUNDATION_MODEL("BEDROCK_FOUNDATION_MODEL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ParsingStrategy> VALUE_MAP;
    private final String value;

    private ParsingStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParsingStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ParsingStrategy> knownValues() {
        EnumSet<ParsingStrategy> knownValues = EnumSet.allOf(ParsingStrategy.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ParsingStrategy.class, ParsingStrategy::toString);
    }
}

