/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.PushADMMessageTemplateContent;
import software.amazon.awssdk.services.qconnect.model.PushAPNSMessageTemplateContent;
import software.amazon.awssdk.services.qconnect.model.PushBaiduMessageTemplateContent;
import software.amazon.awssdk.services.qconnect.model.PushFCMMessageTemplateContent;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PushMessageTemplateContent
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PushMessageTemplateContent> {
    private static final SdkField<PushADMMessageTemplateContent> ADM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("adm").getter(PushMessageTemplateContent.getter(PushMessageTemplateContent::adm)).setter(PushMessageTemplateContent.setter(Builder::adm)).constructor(PushADMMessageTemplateContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adm").build()}).build();
    private static final SdkField<PushAPNSMessageTemplateContent> APNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("apns").getter(PushMessageTemplateContent.getter(PushMessageTemplateContent::apns)).setter(PushMessageTemplateContent.setter(Builder::apns)).constructor(PushAPNSMessageTemplateContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apns").build()}).build();
    private static final SdkField<PushFCMMessageTemplateContent> FCM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("fcm").getter(PushMessageTemplateContent.getter(PushMessageTemplateContent::fcm)).setter(PushMessageTemplateContent.setter(Builder::fcm)).constructor(PushFCMMessageTemplateContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fcm").build()}).build();
    private static final SdkField<PushBaiduMessageTemplateContent> BAIDU_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("baidu").getter(PushMessageTemplateContent.getter(PushMessageTemplateContent::baidu)).setter(PushMessageTemplateContent.setter(Builder::baidu)).constructor(PushBaiduMessageTemplateContent::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baidu").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADM_FIELD, APNS_FIELD, FCM_FIELD, BAIDU_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PushMessageTemplateContent.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final PushADMMessageTemplateContent adm;
    private final PushAPNSMessageTemplateContent apns;
    private final PushFCMMessageTemplateContent fcm;
    private final PushBaiduMessageTemplateContent baidu;

    private PushMessageTemplateContent(BuilderImpl builder) {
        this.adm = builder.adm;
        this.apns = builder.apns;
        this.fcm = builder.fcm;
        this.baidu = builder.baidu;
    }

    public final PushADMMessageTemplateContent adm() {
        return this.adm;
    }

    public final PushAPNSMessageTemplateContent apns() {
        return this.apns;
    }

    public final PushFCMMessageTemplateContent fcm() {
        return this.fcm;
    }

    public final PushBaiduMessageTemplateContent baidu() {
        return this.baidu;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.adm());
        hashCode = 31 * hashCode + Objects.hashCode(this.apns());
        hashCode = 31 * hashCode + Objects.hashCode(this.fcm());
        hashCode = 31 * hashCode + Objects.hashCode(this.baidu());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PushMessageTemplateContent)) {
            return false;
        }
        PushMessageTemplateContent other = (PushMessageTemplateContent)obj;
        return Objects.equals(this.adm(), other.adm()) && Objects.equals(this.apns(), other.apns()) && Objects.equals(this.fcm(), other.fcm()) && Objects.equals(this.baidu(), other.baidu());
    }

    public final String toString() {
        return ToString.builder((String)"PushMessageTemplateContent").add("Adm", (Object)this.adm()).add("Apns", (Object)this.apns()).add("Fcm", (Object)this.fcm()).add("Baidu", (Object)this.baidu()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "adm": {
                return Optional.ofNullable(clazz.cast(this.adm()));
            }
            case "apns": {
                return Optional.ofNullable(clazz.cast(this.apns()));
            }
            case "fcm": {
                return Optional.ofNullable(clazz.cast(this.fcm()));
            }
            case "baidu": {
                return Optional.ofNullable(clazz.cast(this.baidu()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("adm", ADM_FIELD);
        map.put("apns", APNS_FIELD);
        map.put("fcm", FCM_FIELD);
        map.put("baidu", BAIDU_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PushMessageTemplateContent, T> g) {
        return obj -> g.apply((PushMessageTemplateContent)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private PushADMMessageTemplateContent adm;
        private PushAPNSMessageTemplateContent apns;
        private PushFCMMessageTemplateContent fcm;
        private PushBaiduMessageTemplateContent baidu;

        private BuilderImpl() {
        }

        private BuilderImpl(PushMessageTemplateContent model) {
            this.adm(model.adm);
            this.apns(model.apns);
            this.fcm(model.fcm);
            this.baidu(model.baidu);
        }

        public final PushADMMessageTemplateContent.Builder getAdm() {
            return this.adm != null ? this.adm.toBuilder() : null;
        }

        public final void setAdm(PushADMMessageTemplateContent.BuilderImpl adm) {
            this.adm = adm != null ? adm.build() : null;
        }

        @Override
        public final Builder adm(PushADMMessageTemplateContent adm) {
            this.adm = adm;
            return this;
        }

        public final PushAPNSMessageTemplateContent.Builder getApns() {
            return this.apns != null ? this.apns.toBuilder() : null;
        }

        public final void setApns(PushAPNSMessageTemplateContent.BuilderImpl apns) {
            this.apns = apns != null ? apns.build() : null;
        }

        @Override
        public final Builder apns(PushAPNSMessageTemplateContent apns) {
            this.apns = apns;
            return this;
        }

        public final PushFCMMessageTemplateContent.Builder getFcm() {
            return this.fcm != null ? this.fcm.toBuilder() : null;
        }

        public final void setFcm(PushFCMMessageTemplateContent.BuilderImpl fcm) {
            this.fcm = fcm != null ? fcm.build() : null;
        }

        @Override
        public final Builder fcm(PushFCMMessageTemplateContent fcm) {
            this.fcm = fcm;
            return this;
        }

        public final PushBaiduMessageTemplateContent.Builder getBaidu() {
            return this.baidu != null ? this.baidu.toBuilder() : null;
        }

        public final void setBaidu(PushBaiduMessageTemplateContent.BuilderImpl baidu) {
            this.baidu = baidu != null ? baidu.build() : null;
        }

        @Override
        public final Builder baidu(PushBaiduMessageTemplateContent baidu) {
            this.baidu = baidu;
            return this;
        }

        public PushMessageTemplateContent build() {
            return new PushMessageTemplateContent(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PushMessageTemplateContent> {
        public Builder adm(PushADMMessageTemplateContent var1);

        default public Builder adm(Consumer<PushADMMessageTemplateContent.Builder> adm) {
            return this.adm((PushADMMessageTemplateContent)((PushADMMessageTemplateContent.Builder)PushADMMessageTemplateContent.builder().applyMutation(adm)).build());
        }

        public Builder apns(PushAPNSMessageTemplateContent var1);

        default public Builder apns(Consumer<PushAPNSMessageTemplateContent.Builder> apns) {
            return this.apns((PushAPNSMessageTemplateContent)((PushAPNSMessageTemplateContent.Builder)PushAPNSMessageTemplateContent.builder().applyMutation(apns)).build());
        }

        public Builder fcm(PushFCMMessageTemplateContent var1);

        default public Builder fcm(Consumer<PushFCMMessageTemplateContent.Builder> fcm) {
            return this.fcm((PushFCMMessageTemplateContent)((PushFCMMessageTemplateContent.Builder)PushFCMMessageTemplateContent.builder().applyMutation(fcm)).build());
        }

        public Builder baidu(PushBaiduMessageTemplateContent var1);

        default public Builder baidu(Consumer<PushBaiduMessageTemplateContent.Builder> baidu) {
            return this.baidu((PushBaiduMessageTemplateContent)((PushBaiduMessageTemplateContent.Builder)PushBaiduMessageTemplateContent.builder().applyMutation(baidu)).build());
        }
    }
}

