/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.AIAgentType;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveAssistantAiAgentRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, RemoveAssistantAiAgentRequest> {
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(RemoveAssistantAiAgentRequest.getter(RemoveAssistantAiAgentRequest::assistantId)).setter(RemoveAssistantAiAgentRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> AI_AGENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentType").getter(RemoveAssistantAiAgentRequest.getter(RemoveAssistantAiAgentRequest::aiAgentTypeAsString)).setter(RemoveAssistantAiAgentRequest.setter(Builder::aiAgentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("aiAgentType").build()}).build();
    private static final SdkField<String> ORCHESTRATOR_USE_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("orchestratorUseCase").getter(RemoveAssistantAiAgentRequest.getter(RemoveAssistantAiAgentRequest::orchestratorUseCase)).setter(RemoveAssistantAiAgentRequest.setter(Builder::orchestratorUseCase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("orchestratorUseCase").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSISTANT_ID_FIELD, AI_AGENT_TYPE_FIELD, ORCHESTRATOR_USE_CASE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemoveAssistantAiAgentRequest.memberNameToFieldInitializer();
    private final String assistantId;
    private final String aiAgentType;
    private final String orchestratorUseCase;

    private RemoveAssistantAiAgentRequest(BuilderImpl builder) {
        super(builder);
        this.assistantId = builder.assistantId;
        this.aiAgentType = builder.aiAgentType;
        this.orchestratorUseCase = builder.orchestratorUseCase;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final AIAgentType aiAgentType() {
        return AIAgentType.fromValue(this.aiAgentType);
    }

    public final String aiAgentTypeAsString() {
        return this.aiAgentType;
    }

    public final String orchestratorUseCase() {
        return this.orchestratorUseCase;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestratorUseCase());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveAssistantAiAgentRequest)) {
            return false;
        }
        RemoveAssistantAiAgentRequest other = (RemoveAssistantAiAgentRequest)((Object)obj);
        return Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.aiAgentTypeAsString(), other.aiAgentTypeAsString()) && Objects.equals(this.orchestratorUseCase(), other.orchestratorUseCase());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveAssistantAiAgentRequest").add("AssistantId", (Object)this.assistantId()).add("AiAgentType", (Object)this.aiAgentTypeAsString()).add("OrchestratorUseCase", (Object)this.orchestratorUseCase()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "aiAgentType": {
                return Optional.ofNullable(clazz.cast(this.aiAgentTypeAsString()));
            }
            case "orchestratorUseCase": {
                return Optional.ofNullable(clazz.cast(this.orchestratorUseCase()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("aiAgentType", AI_AGENT_TYPE_FIELD);
        map.put("orchestratorUseCase", ORCHESTRATOR_USE_CASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoveAssistantAiAgentRequest, T> g) {
        return obj -> g.apply((RemoveAssistantAiAgentRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String assistantId;
        private String aiAgentType;
        private String orchestratorUseCase;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveAssistantAiAgentRequest model) {
            super(model);
            this.assistantId(model.assistantId);
            this.aiAgentType(model.aiAgentType);
            this.orchestratorUseCase(model.orchestratorUseCase);
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAiAgentType() {
            return this.aiAgentType;
        }

        public final void setAiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
        }

        @Override
        public final Builder aiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
            return this;
        }

        @Override
        public final Builder aiAgentType(AIAgentType aiAgentType) {
            this.aiAgentType(aiAgentType == null ? null : aiAgentType.toString());
            return this;
        }

        public final String getOrchestratorUseCase() {
            return this.orchestratorUseCase;
        }

        public final void setOrchestratorUseCase(String orchestratorUseCase) {
            this.orchestratorUseCase = orchestratorUseCase;
        }

        @Override
        public final Builder orchestratorUseCase(String orchestratorUseCase) {
            this.orchestratorUseCase = orchestratorUseCase;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveAssistantAiAgentRequest build() {
            return new RemoveAssistantAiAgentRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveAssistantAiAgentRequest> {
        public Builder assistantId(String var1);

        public Builder aiAgentType(String var1);

        public Builder aiAgentType(AIAgentType var1);

        public Builder orchestratorUseCase(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

