/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.AIAgentType;
import software.amazon.awssdk.services.qconnect.model.AIPromptType;
import software.amazon.awssdk.services.qconnect.model.SpanFinishReasonListCopier;
import software.amazon.awssdk.services.qconnect.model.SpanMessage;
import software.amazon.awssdk.services.qconnect.model.SpanMessageListCopier;
import software.amazon.awssdk.services.qconnect.model.SpanMessageValue;
import software.amazon.awssdk.services.qconnect.model.SpanMessageValueListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpanAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpanAttributes> {
    private static final SdkField<String> OPERATION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("operationName").getter(SpanAttributes.getter(SpanAttributes::operationName)).setter(SpanAttributes.setter(Builder::operationName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationName").build()}).build();
    private static final SdkField<String> PROVIDER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("providerName").getter(SpanAttributes.getter(SpanAttributes::providerName)).setter(SpanAttributes.setter(Builder::providerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerName").build()}).build();
    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorType").getter(SpanAttributes.getter(SpanAttributes::errorType)).setter(SpanAttributes.setter(Builder::errorType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()}).build();
    private static final SdkField<String> AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentId").getter(SpanAttributes.getter(SpanAttributes::agentId)).setter(SpanAttributes.setter(Builder::agentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentId").build()}).build();
    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instanceArn").getter(SpanAttributes.getter(SpanAttributes::instanceArn)).setter(SpanAttributes.setter(Builder::instanceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()}).build();
    private static final SdkField<String> CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("contactId").getter(SpanAttributes.getter(SpanAttributes::contactId)).setter(SpanAttributes.setter(Builder::contactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contactId").build()}).build();
    private static final SdkField<String> INITIAL_CONTACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("initialContactId").getter(SpanAttributes.getter(SpanAttributes::initialContactId)).setter(SpanAttributes.setter(Builder::initialContactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("initialContactId").build()}).build();
    private static final SdkField<String> SESSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionName").getter(SpanAttributes.getter(SpanAttributes::sessionName)).setter(SpanAttributes.setter(Builder::sessionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionName").build()}).build();
    private static final SdkField<String> AI_AGENT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentArn").getter(SpanAttributes.getter(SpanAttributes::aiAgentArn)).setter(SpanAttributes.setter(Builder::aiAgentArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentArn").build()}).build();
    private static final SdkField<String> AI_AGENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentType").getter(SpanAttributes.getter(SpanAttributes::aiAgentTypeAsString)).setter(SpanAttributes.setter(Builder::aiAgentType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentType").build()}).build();
    private static final SdkField<String> AI_AGENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentName").getter(SpanAttributes.getter(SpanAttributes::aiAgentName)).setter(SpanAttributes.setter(Builder::aiAgentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentName").build()}).build();
    private static final SdkField<String> AI_AGENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentId").getter(SpanAttributes.getter(SpanAttributes::aiAgentId)).setter(SpanAttributes.setter(Builder::aiAgentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentId").build()}).build();
    private static final SdkField<Integer> AI_AGENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("aiAgentVersion").getter(SpanAttributes.getter(SpanAttributes::aiAgentVersion)).setter(SpanAttributes.setter(Builder::aiAgentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentVersion").build()}).build();
    private static final SdkField<String> AI_AGENT_INVOKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentInvoker").getter(SpanAttributes.getter(SpanAttributes::aiAgentInvoker)).setter(SpanAttributes.setter(Builder::aiAgentInvoker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentInvoker").build()}).build();
    private static final SdkField<String> AI_AGENT_ORCHESTRATOR_USE_CASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiAgentOrchestratorUseCase").getter(SpanAttributes.getter(SpanAttributes::aiAgentOrchestratorUseCase)).setter(SpanAttributes.setter(Builder::aiAgentOrchestratorUseCase)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("aiAgentOrchestratorUseCase").build()}).build();
    private static final SdkField<String> REQUEST_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestModel").getter(SpanAttributes.getter(SpanAttributes::requestModel)).setter(SpanAttributes.setter(Builder::requestModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestModel").build()}).build();
    private static final SdkField<Integer> REQUEST_MAX_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("requestMaxTokens").getter(SpanAttributes.getter(SpanAttributes::requestMaxTokens)).setter(SpanAttributes.setter(Builder::requestMaxTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMaxTokens").build()}).build();
    private static final SdkField<Float> TEMPERATURE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("temperature").getter(SpanAttributes.getter(SpanAttributes::temperature)).setter(SpanAttributes.setter(Builder::temperature)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("temperature").build()}).build();
    private static final SdkField<Float> TOPP_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("topP").getter(SpanAttributes.getter(SpanAttributes::topP)).setter(SpanAttributes.setter(Builder::topP)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topP").build()}).build();
    private static final SdkField<String> RESPONSE_MODEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("responseModel").getter(SpanAttributes.getter(SpanAttributes::responseModel)).setter(SpanAttributes.setter(Builder::responseModel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseModel").build()}).build();
    private static final SdkField<List<String>> RESPONSE_FINISH_REASONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("responseFinishReasons").getter(SpanAttributes.getter(SpanAttributes::responseFinishReasons)).setter(SpanAttributes.setter(Builder::responseFinishReasons)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseFinishReasons").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> USAGE_INPUT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("usageInputTokens").getter(SpanAttributes.getter(SpanAttributes::usageInputTokens)).setter(SpanAttributes.setter(Builder::usageInputTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageInputTokens").build()}).build();
    private static final SdkField<Integer> USAGE_OUTPUT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("usageOutputTokens").getter(SpanAttributes.getter(SpanAttributes::usageOutputTokens)).setter(SpanAttributes.setter(Builder::usageOutputTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageOutputTokens").build()}).build();
    private static final SdkField<Integer> USAGE_TOTAL_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("usageTotalTokens").getter(SpanAttributes.getter(SpanAttributes::usageTotalTokens)).setter(SpanAttributes.setter(Builder::usageTotalTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("usageTotalTokens").build()}).build();
    private static final SdkField<Integer> CACHE_READ_INPUT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cacheReadInputTokens").getter(SpanAttributes.getter(SpanAttributes::cacheReadInputTokens)).setter(SpanAttributes.setter(Builder::cacheReadInputTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheReadInputTokens").build()}).build();
    private static final SdkField<Integer> CACHE_WRITE_INPUT_TOKENS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cacheWriteInputTokens").getter(SpanAttributes.getter(SpanAttributes::cacheWriteInputTokens)).setter(SpanAttributes.setter(Builder::cacheWriteInputTokens)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheWriteInputTokens").build()}).build();
    private static final SdkField<List<SpanMessage>> INPUT_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputMessages").getter(SpanAttributes.getter(SpanAttributes::inputMessages)).setter(SpanAttributes.setter(Builder::inputMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpanMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SpanMessage>> OUTPUT_MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputMessages").getter(SpanAttributes.getter(SpanAttributes::outputMessages)).setter(SpanAttributes.setter(Builder::outputMessages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputMessages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpanMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SpanMessageValue>> SYSTEM_INSTRUCTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("systemInstructions").getter(SpanAttributes.getter(SpanAttributes::systemInstructions)).setter(SpanAttributes.setter(Builder::systemInstructions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemInstructions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SpanMessageValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROMPT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptArn").getter(SpanAttributes.getter(SpanAttributes::promptArn)).setter(SpanAttributes.setter(Builder::promptArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptArn").build()}).build();
    private static final SdkField<String> PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptId").getter(SpanAttributes.getter(SpanAttributes::promptId)).setter(SpanAttributes.setter(Builder::promptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptId").build()}).build();
    private static final SdkField<String> PROMPT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptType").getter(SpanAttributes.getter(SpanAttributes::promptTypeAsString)).setter(SpanAttributes.setter(Builder::promptType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptType").build()}).build();
    private static final SdkField<String> PROMPT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("promptName").getter(SpanAttributes.getter(SpanAttributes::promptName)).setter(SpanAttributes.setter(Builder::promptName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptName").build()}).build();
    private static final SdkField<Integer> PROMPT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("promptVersion").getter(SpanAttributes.getter(SpanAttributes::promptVersion)).setter(SpanAttributes.setter(Builder::promptVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPERATION_NAME_FIELD, PROVIDER_NAME_FIELD, ERROR_TYPE_FIELD, AGENT_ID_FIELD, INSTANCE_ARN_FIELD, CONTACT_ID_FIELD, INITIAL_CONTACT_ID_FIELD, SESSION_NAME_FIELD, AI_AGENT_ARN_FIELD, AI_AGENT_TYPE_FIELD, AI_AGENT_NAME_FIELD, AI_AGENT_ID_FIELD, AI_AGENT_VERSION_FIELD, AI_AGENT_INVOKER_FIELD, AI_AGENT_ORCHESTRATOR_USE_CASE_FIELD, REQUEST_MODEL_FIELD, REQUEST_MAX_TOKENS_FIELD, TEMPERATURE_FIELD, TOPP_FIELD, RESPONSE_MODEL_FIELD, RESPONSE_FINISH_REASONS_FIELD, USAGE_INPUT_TOKENS_FIELD, USAGE_OUTPUT_TOKENS_FIELD, USAGE_TOTAL_TOKENS_FIELD, CACHE_READ_INPUT_TOKENS_FIELD, CACHE_WRITE_INPUT_TOKENS_FIELD, INPUT_MESSAGES_FIELD, OUTPUT_MESSAGES_FIELD, SYSTEM_INSTRUCTIONS_FIELD, PROMPT_ARN_FIELD, PROMPT_ID_FIELD, PROMPT_TYPE_FIELD, PROMPT_NAME_FIELD, PROMPT_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SpanAttributes.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String operationName;
    private final String providerName;
    private final String errorType;
    private final String agentId;
    private final String instanceArn;
    private final String contactId;
    private final String initialContactId;
    private final String sessionName;
    private final String aiAgentArn;
    private final String aiAgentType;
    private final String aiAgentName;
    private final String aiAgentId;
    private final Integer aiAgentVersion;
    private final String aiAgentInvoker;
    private final String aiAgentOrchestratorUseCase;
    private final String requestModel;
    private final Integer requestMaxTokens;
    private final Float temperature;
    private final Float topP;
    private final String responseModel;
    private final List<String> responseFinishReasons;
    private final Integer usageInputTokens;
    private final Integer usageOutputTokens;
    private final Integer usageTotalTokens;
    private final Integer cacheReadInputTokens;
    private final Integer cacheWriteInputTokens;
    private final List<SpanMessage> inputMessages;
    private final List<SpanMessage> outputMessages;
    private final List<SpanMessageValue> systemInstructions;
    private final String promptArn;
    private final String promptId;
    private final String promptType;
    private final String promptName;
    private final Integer promptVersion;

    private SpanAttributes(BuilderImpl builder) {
        this.operationName = builder.operationName;
        this.providerName = builder.providerName;
        this.errorType = builder.errorType;
        this.agentId = builder.agentId;
        this.instanceArn = builder.instanceArn;
        this.contactId = builder.contactId;
        this.initialContactId = builder.initialContactId;
        this.sessionName = builder.sessionName;
        this.aiAgentArn = builder.aiAgentArn;
        this.aiAgentType = builder.aiAgentType;
        this.aiAgentName = builder.aiAgentName;
        this.aiAgentId = builder.aiAgentId;
        this.aiAgentVersion = builder.aiAgentVersion;
        this.aiAgentInvoker = builder.aiAgentInvoker;
        this.aiAgentOrchestratorUseCase = builder.aiAgentOrchestratorUseCase;
        this.requestModel = builder.requestModel;
        this.requestMaxTokens = builder.requestMaxTokens;
        this.temperature = builder.temperature;
        this.topP = builder.topP;
        this.responseModel = builder.responseModel;
        this.responseFinishReasons = builder.responseFinishReasons;
        this.usageInputTokens = builder.usageInputTokens;
        this.usageOutputTokens = builder.usageOutputTokens;
        this.usageTotalTokens = builder.usageTotalTokens;
        this.cacheReadInputTokens = builder.cacheReadInputTokens;
        this.cacheWriteInputTokens = builder.cacheWriteInputTokens;
        this.inputMessages = builder.inputMessages;
        this.outputMessages = builder.outputMessages;
        this.systemInstructions = builder.systemInstructions;
        this.promptArn = builder.promptArn;
        this.promptId = builder.promptId;
        this.promptType = builder.promptType;
        this.promptName = builder.promptName;
        this.promptVersion = builder.promptVersion;
    }

    public final String operationName() {
        return this.operationName;
    }

    public final String providerName() {
        return this.providerName;
    }

    public final String errorType() {
        return this.errorType;
    }

    public final String agentId() {
        return this.agentId;
    }

    public final String instanceArn() {
        return this.instanceArn;
    }

    public final String contactId() {
        return this.contactId;
    }

    public final String initialContactId() {
        return this.initialContactId;
    }

    public final String sessionName() {
        return this.sessionName;
    }

    public final String aiAgentArn() {
        return this.aiAgentArn;
    }

    public final AIAgentType aiAgentType() {
        return AIAgentType.fromValue(this.aiAgentType);
    }

    public final String aiAgentTypeAsString() {
        return this.aiAgentType;
    }

    public final String aiAgentName() {
        return this.aiAgentName;
    }

    public final String aiAgentId() {
        return this.aiAgentId;
    }

    public final Integer aiAgentVersion() {
        return this.aiAgentVersion;
    }

    public final String aiAgentInvoker() {
        return this.aiAgentInvoker;
    }

    public final String aiAgentOrchestratorUseCase() {
        return this.aiAgentOrchestratorUseCase;
    }

    public final String requestModel() {
        return this.requestModel;
    }

    public final Integer requestMaxTokens() {
        return this.requestMaxTokens;
    }

    public final Float temperature() {
        return this.temperature;
    }

    public final Float topP() {
        return this.topP;
    }

    public final String responseModel() {
        return this.responseModel;
    }

    public final boolean hasResponseFinishReasons() {
        return this.responseFinishReasons != null && !(this.responseFinishReasons instanceof SdkAutoConstructList);
    }

    public final List<String> responseFinishReasons() {
        return this.responseFinishReasons;
    }

    public final Integer usageInputTokens() {
        return this.usageInputTokens;
    }

    public final Integer usageOutputTokens() {
        return this.usageOutputTokens;
    }

    public final Integer usageTotalTokens() {
        return this.usageTotalTokens;
    }

    public final Integer cacheReadInputTokens() {
        return this.cacheReadInputTokens;
    }

    public final Integer cacheWriteInputTokens() {
        return this.cacheWriteInputTokens;
    }

    public final boolean hasInputMessages() {
        return this.inputMessages != null && !(this.inputMessages instanceof SdkAutoConstructList);
    }

    public final List<SpanMessage> inputMessages() {
        return this.inputMessages;
    }

    public final boolean hasOutputMessages() {
        return this.outputMessages != null && !(this.outputMessages instanceof SdkAutoConstructList);
    }

    public final List<SpanMessage> outputMessages() {
        return this.outputMessages;
    }

    public final boolean hasSystemInstructions() {
        return this.systemInstructions != null && !(this.systemInstructions instanceof SdkAutoConstructList);
    }

    public final List<SpanMessageValue> systemInstructions() {
        return this.systemInstructions;
    }

    public final String promptArn() {
        return this.promptArn;
    }

    public final String promptId() {
        return this.promptId;
    }

    public final AIPromptType promptType() {
        return AIPromptType.fromValue(this.promptType);
    }

    public final String promptTypeAsString() {
        return this.promptType;
    }

    public final String promptName() {
        return this.promptName;
    }

    public final Integer promptVersion() {
        return this.promptVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.operationName());
        hashCode = 31 * hashCode + Objects.hashCode(this.providerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorType());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.contactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialContactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentInvoker());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiAgentOrchestratorUseCase());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestMaxTokens());
        hashCode = 31 * hashCode + Objects.hashCode(this.temperature());
        hashCode = 31 * hashCode + Objects.hashCode(this.topP());
        hashCode = 31 * hashCode + Objects.hashCode(this.responseModel());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResponseFinishReasons() ? this.responseFinishReasons() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.usageInputTokens());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageOutputTokens());
        hashCode = 31 * hashCode + Objects.hashCode(this.usageTotalTokens());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheReadInputTokens());
        hashCode = 31 * hashCode + Objects.hashCode(this.cacheWriteInputTokens());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputMessages() ? this.inputMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputMessages() ? this.outputMessages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSystemInstructions() ? this.systemInstructions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.promptArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptName());
        hashCode = 31 * hashCode + Objects.hashCode(this.promptVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpanAttributes)) {
            return false;
        }
        SpanAttributes other = (SpanAttributes)obj;
        return Objects.equals(this.operationName(), other.operationName()) && Objects.equals(this.providerName(), other.providerName()) && Objects.equals(this.errorType(), other.errorType()) && Objects.equals(this.agentId(), other.agentId()) && Objects.equals(this.instanceArn(), other.instanceArn()) && Objects.equals(this.contactId(), other.contactId()) && Objects.equals(this.initialContactId(), other.initialContactId()) && Objects.equals(this.sessionName(), other.sessionName()) && Objects.equals(this.aiAgentArn(), other.aiAgentArn()) && Objects.equals(this.aiAgentTypeAsString(), other.aiAgentTypeAsString()) && Objects.equals(this.aiAgentName(), other.aiAgentName()) && Objects.equals(this.aiAgentId(), other.aiAgentId()) && Objects.equals(this.aiAgentVersion(), other.aiAgentVersion()) && Objects.equals(this.aiAgentInvoker(), other.aiAgentInvoker()) && Objects.equals(this.aiAgentOrchestratorUseCase(), other.aiAgentOrchestratorUseCase()) && Objects.equals(this.requestModel(), other.requestModel()) && Objects.equals(this.requestMaxTokens(), other.requestMaxTokens()) && Objects.equals(this.temperature(), other.temperature()) && Objects.equals(this.topP(), other.topP()) && Objects.equals(this.responseModel(), other.responseModel()) && this.hasResponseFinishReasons() == other.hasResponseFinishReasons() && Objects.equals(this.responseFinishReasons(), other.responseFinishReasons()) && Objects.equals(this.usageInputTokens(), other.usageInputTokens()) && Objects.equals(this.usageOutputTokens(), other.usageOutputTokens()) && Objects.equals(this.usageTotalTokens(), other.usageTotalTokens()) && Objects.equals(this.cacheReadInputTokens(), other.cacheReadInputTokens()) && Objects.equals(this.cacheWriteInputTokens(), other.cacheWriteInputTokens()) && this.hasInputMessages() == other.hasInputMessages() && Objects.equals(this.inputMessages(), other.inputMessages()) && this.hasOutputMessages() == other.hasOutputMessages() && Objects.equals(this.outputMessages(), other.outputMessages()) && this.hasSystemInstructions() == other.hasSystemInstructions() && Objects.equals(this.systemInstructions(), other.systemInstructions()) && Objects.equals(this.promptArn(), other.promptArn()) && Objects.equals(this.promptId(), other.promptId()) && Objects.equals(this.promptTypeAsString(), other.promptTypeAsString()) && Objects.equals(this.promptName(), other.promptName()) && Objects.equals(this.promptVersion(), other.promptVersion());
    }

    public final String toString() {
        return ToString.builder((String)"SpanAttributes").add("OperationName", (Object)this.operationName()).add("ProviderName", (Object)this.providerName()).add("ErrorType", (Object)this.errorType()).add("AgentId", (Object)this.agentId()).add("InstanceArn", (Object)this.instanceArn()).add("ContactId", (Object)this.contactId()).add("InitialContactId", (Object)this.initialContactId()).add("SessionName", (Object)this.sessionName()).add("AiAgentArn", (Object)this.aiAgentArn()).add("AiAgentType", (Object)this.aiAgentTypeAsString()).add("AiAgentName", (Object)this.aiAgentName()).add("AiAgentId", (Object)this.aiAgentId()).add("AiAgentVersion", (Object)this.aiAgentVersion()).add("AiAgentInvoker", (Object)this.aiAgentInvoker()).add("AiAgentOrchestratorUseCase", (Object)this.aiAgentOrchestratorUseCase()).add("RequestModel", (Object)this.requestModel()).add("RequestMaxTokens", (Object)this.requestMaxTokens()).add("Temperature", (Object)this.temperature()).add("TopP", (Object)this.topP()).add("ResponseModel", (Object)this.responseModel()).add("ResponseFinishReasons", this.hasResponseFinishReasons() ? this.responseFinishReasons() : null).add("UsageInputTokens", (Object)this.usageInputTokens()).add("UsageOutputTokens", (Object)this.usageOutputTokens()).add("UsageTotalTokens", (Object)this.usageTotalTokens()).add("CacheReadInputTokens", (Object)this.cacheReadInputTokens()).add("CacheWriteInputTokens", (Object)this.cacheWriteInputTokens()).add("InputMessages", this.hasInputMessages() ? this.inputMessages() : null).add("OutputMessages", this.hasOutputMessages() ? this.outputMessages() : null).add("SystemInstructions", this.hasSystemInstructions() ? this.systemInstructions() : null).add("PromptArn", (Object)this.promptArn()).add("PromptId", (Object)this.promptId()).add("PromptType", (Object)this.promptTypeAsString()).add("PromptName", (Object)this.promptName()).add("PromptVersion", (Object)this.promptVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "operationName": {
                return Optional.ofNullable(clazz.cast(this.operationName()));
            }
            case "providerName": {
                return Optional.ofNullable(clazz.cast(this.providerName()));
            }
            case "errorType": {
                return Optional.ofNullable(clazz.cast(this.errorType()));
            }
            case "agentId": {
                return Optional.ofNullable(clazz.cast(this.agentId()));
            }
            case "instanceArn": {
                return Optional.ofNullable(clazz.cast(this.instanceArn()));
            }
            case "contactId": {
                return Optional.ofNullable(clazz.cast(this.contactId()));
            }
            case "initialContactId": {
                return Optional.ofNullable(clazz.cast(this.initialContactId()));
            }
            case "sessionName": {
                return Optional.ofNullable(clazz.cast(this.sessionName()));
            }
            case "aiAgentArn": {
                return Optional.ofNullable(clazz.cast(this.aiAgentArn()));
            }
            case "aiAgentType": {
                return Optional.ofNullable(clazz.cast(this.aiAgentTypeAsString()));
            }
            case "aiAgentName": {
                return Optional.ofNullable(clazz.cast(this.aiAgentName()));
            }
            case "aiAgentId": {
                return Optional.ofNullable(clazz.cast(this.aiAgentId()));
            }
            case "aiAgentVersion": {
                return Optional.ofNullable(clazz.cast(this.aiAgentVersion()));
            }
            case "aiAgentInvoker": {
                return Optional.ofNullable(clazz.cast(this.aiAgentInvoker()));
            }
            case "aiAgentOrchestratorUseCase": {
                return Optional.ofNullable(clazz.cast(this.aiAgentOrchestratorUseCase()));
            }
            case "requestModel": {
                return Optional.ofNullable(clazz.cast(this.requestModel()));
            }
            case "requestMaxTokens": {
                return Optional.ofNullable(clazz.cast(this.requestMaxTokens()));
            }
            case "temperature": {
                return Optional.ofNullable(clazz.cast(this.temperature()));
            }
            case "topP": {
                return Optional.ofNullable(clazz.cast(this.topP()));
            }
            case "responseModel": {
                return Optional.ofNullable(clazz.cast(this.responseModel()));
            }
            case "responseFinishReasons": {
                return Optional.ofNullable(clazz.cast(this.responseFinishReasons()));
            }
            case "usageInputTokens": {
                return Optional.ofNullable(clazz.cast(this.usageInputTokens()));
            }
            case "usageOutputTokens": {
                return Optional.ofNullable(clazz.cast(this.usageOutputTokens()));
            }
            case "usageTotalTokens": {
                return Optional.ofNullable(clazz.cast(this.usageTotalTokens()));
            }
            case "cacheReadInputTokens": {
                return Optional.ofNullable(clazz.cast(this.cacheReadInputTokens()));
            }
            case "cacheWriteInputTokens": {
                return Optional.ofNullable(clazz.cast(this.cacheWriteInputTokens()));
            }
            case "inputMessages": {
                return Optional.ofNullable(clazz.cast(this.inputMessages()));
            }
            case "outputMessages": {
                return Optional.ofNullable(clazz.cast(this.outputMessages()));
            }
            case "systemInstructions": {
                return Optional.ofNullable(clazz.cast(this.systemInstructions()));
            }
            case "promptArn": {
                return Optional.ofNullable(clazz.cast(this.promptArn()));
            }
            case "promptId": {
                return Optional.ofNullable(clazz.cast(this.promptId()));
            }
            case "promptType": {
                return Optional.ofNullable(clazz.cast(this.promptTypeAsString()));
            }
            case "promptName": {
                return Optional.ofNullable(clazz.cast(this.promptName()));
            }
            case "promptVersion": {
                return Optional.ofNullable(clazz.cast(this.promptVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("operationName", OPERATION_NAME_FIELD);
        map.put("providerName", PROVIDER_NAME_FIELD);
        map.put("errorType", ERROR_TYPE_FIELD);
        map.put("agentId", AGENT_ID_FIELD);
        map.put("instanceArn", INSTANCE_ARN_FIELD);
        map.put("contactId", CONTACT_ID_FIELD);
        map.put("initialContactId", INITIAL_CONTACT_ID_FIELD);
        map.put("sessionName", SESSION_NAME_FIELD);
        map.put("aiAgentArn", AI_AGENT_ARN_FIELD);
        map.put("aiAgentType", AI_AGENT_TYPE_FIELD);
        map.put("aiAgentName", AI_AGENT_NAME_FIELD);
        map.put("aiAgentId", AI_AGENT_ID_FIELD);
        map.put("aiAgentVersion", AI_AGENT_VERSION_FIELD);
        map.put("aiAgentInvoker", AI_AGENT_INVOKER_FIELD);
        map.put("aiAgentOrchestratorUseCase", AI_AGENT_ORCHESTRATOR_USE_CASE_FIELD);
        map.put("requestModel", REQUEST_MODEL_FIELD);
        map.put("requestMaxTokens", REQUEST_MAX_TOKENS_FIELD);
        map.put("temperature", TEMPERATURE_FIELD);
        map.put("topP", TOPP_FIELD);
        map.put("responseModel", RESPONSE_MODEL_FIELD);
        map.put("responseFinishReasons", RESPONSE_FINISH_REASONS_FIELD);
        map.put("usageInputTokens", USAGE_INPUT_TOKENS_FIELD);
        map.put("usageOutputTokens", USAGE_OUTPUT_TOKENS_FIELD);
        map.put("usageTotalTokens", USAGE_TOTAL_TOKENS_FIELD);
        map.put("cacheReadInputTokens", CACHE_READ_INPUT_TOKENS_FIELD);
        map.put("cacheWriteInputTokens", CACHE_WRITE_INPUT_TOKENS_FIELD);
        map.put("inputMessages", INPUT_MESSAGES_FIELD);
        map.put("outputMessages", OUTPUT_MESSAGES_FIELD);
        map.put("systemInstructions", SYSTEM_INSTRUCTIONS_FIELD);
        map.put("promptArn", PROMPT_ARN_FIELD);
        map.put("promptId", PROMPT_ID_FIELD);
        map.put("promptType", PROMPT_TYPE_FIELD);
        map.put("promptName", PROMPT_NAME_FIELD);
        map.put("promptVersion", PROMPT_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SpanAttributes, T> g) {
        return obj -> g.apply((SpanAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String operationName;
        private String providerName;
        private String errorType;
        private String agentId;
        private String instanceArn;
        private String contactId;
        private String initialContactId;
        private String sessionName;
        private String aiAgentArn;
        private String aiAgentType;
        private String aiAgentName;
        private String aiAgentId;
        private Integer aiAgentVersion;
        private String aiAgentInvoker;
        private String aiAgentOrchestratorUseCase;
        private String requestModel;
        private Integer requestMaxTokens;
        private Float temperature;
        private Float topP;
        private String responseModel;
        private List<String> responseFinishReasons = DefaultSdkAutoConstructList.getInstance();
        private Integer usageInputTokens;
        private Integer usageOutputTokens;
        private Integer usageTotalTokens;
        private Integer cacheReadInputTokens;
        private Integer cacheWriteInputTokens;
        private List<SpanMessage> inputMessages = DefaultSdkAutoConstructList.getInstance();
        private List<SpanMessage> outputMessages = DefaultSdkAutoConstructList.getInstance();
        private List<SpanMessageValue> systemInstructions = DefaultSdkAutoConstructList.getInstance();
        private String promptArn;
        private String promptId;
        private String promptType;
        private String promptName;
        private Integer promptVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(SpanAttributes model) {
            this.operationName(model.operationName);
            this.providerName(model.providerName);
            this.errorType(model.errorType);
            this.agentId(model.agentId);
            this.instanceArn(model.instanceArn);
            this.contactId(model.contactId);
            this.initialContactId(model.initialContactId);
            this.sessionName(model.sessionName);
            this.aiAgentArn(model.aiAgentArn);
            this.aiAgentType(model.aiAgentType);
            this.aiAgentName(model.aiAgentName);
            this.aiAgentId(model.aiAgentId);
            this.aiAgentVersion(model.aiAgentVersion);
            this.aiAgentInvoker(model.aiAgentInvoker);
            this.aiAgentOrchestratorUseCase(model.aiAgentOrchestratorUseCase);
            this.requestModel(model.requestModel);
            this.requestMaxTokens(model.requestMaxTokens);
            this.temperature(model.temperature);
            this.topP(model.topP);
            this.responseModel(model.responseModel);
            this.responseFinishReasons(model.responseFinishReasons);
            this.usageInputTokens(model.usageInputTokens);
            this.usageOutputTokens(model.usageOutputTokens);
            this.usageTotalTokens(model.usageTotalTokens);
            this.cacheReadInputTokens(model.cacheReadInputTokens);
            this.cacheWriteInputTokens(model.cacheWriteInputTokens);
            this.inputMessages(model.inputMessages);
            this.outputMessages(model.outputMessages);
            this.systemInstructions(model.systemInstructions);
            this.promptArn(model.promptArn);
            this.promptId(model.promptId);
            this.promptType(model.promptType);
            this.promptName(model.promptName);
            this.promptVersion(model.promptVersion);
        }

        public final String getOperationName() {
            return this.operationName;
        }

        public final void setOperationName(String operationName) {
            this.operationName = operationName;
        }

        @Override
        public final Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public final String getProviderName() {
            return this.providerName;
        }

        public final void setProviderName(String providerName) {
            this.providerName = providerName;
        }

        @Override
        public final Builder providerName(String providerName) {
            this.providerName = providerName;
            return this;
        }

        public final String getErrorType() {
            return this.errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        public final String getAgentId() {
            return this.agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getInstanceArn() {
            return this.instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getContactId() {
            return this.contactId;
        }

        public final void setContactId(String contactId) {
            this.contactId = contactId;
        }

        @Override
        public final Builder contactId(String contactId) {
            this.contactId = contactId;
            return this;
        }

        public final String getInitialContactId() {
            return this.initialContactId;
        }

        public final void setInitialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
        }

        @Override
        public final Builder initialContactId(String initialContactId) {
            this.initialContactId = initialContactId;
            return this;
        }

        public final String getSessionName() {
            return this.sessionName;
        }

        public final void setSessionName(String sessionName) {
            this.sessionName = sessionName;
        }

        @Override
        public final Builder sessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        public final String getAiAgentArn() {
            return this.aiAgentArn;
        }

        public final void setAiAgentArn(String aiAgentArn) {
            this.aiAgentArn = aiAgentArn;
        }

        @Override
        public final Builder aiAgentArn(String aiAgentArn) {
            this.aiAgentArn = aiAgentArn;
            return this;
        }

        public final String getAiAgentType() {
            return this.aiAgentType;
        }

        public final void setAiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
        }

        @Override
        public final Builder aiAgentType(String aiAgentType) {
            this.aiAgentType = aiAgentType;
            return this;
        }

        @Override
        public final Builder aiAgentType(AIAgentType aiAgentType) {
            this.aiAgentType(aiAgentType == null ? null : aiAgentType.toString());
            return this;
        }

        public final String getAiAgentName() {
            return this.aiAgentName;
        }

        public final void setAiAgentName(String aiAgentName) {
            this.aiAgentName = aiAgentName;
        }

        @Override
        public final Builder aiAgentName(String aiAgentName) {
            this.aiAgentName = aiAgentName;
            return this;
        }

        public final String getAiAgentId() {
            return this.aiAgentId;
        }

        public final void setAiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
        }

        @Override
        public final Builder aiAgentId(String aiAgentId) {
            this.aiAgentId = aiAgentId;
            return this;
        }

        public final Integer getAiAgentVersion() {
            return this.aiAgentVersion;
        }

        public final void setAiAgentVersion(Integer aiAgentVersion) {
            this.aiAgentVersion = aiAgentVersion;
        }

        @Override
        public final Builder aiAgentVersion(Integer aiAgentVersion) {
            this.aiAgentVersion = aiAgentVersion;
            return this;
        }

        public final String getAiAgentInvoker() {
            return this.aiAgentInvoker;
        }

        public final void setAiAgentInvoker(String aiAgentInvoker) {
            this.aiAgentInvoker = aiAgentInvoker;
        }

        @Override
        public final Builder aiAgentInvoker(String aiAgentInvoker) {
            this.aiAgentInvoker = aiAgentInvoker;
            return this;
        }

        public final String getAiAgentOrchestratorUseCase() {
            return this.aiAgentOrchestratorUseCase;
        }

        public final void setAiAgentOrchestratorUseCase(String aiAgentOrchestratorUseCase) {
            this.aiAgentOrchestratorUseCase = aiAgentOrchestratorUseCase;
        }

        @Override
        public final Builder aiAgentOrchestratorUseCase(String aiAgentOrchestratorUseCase) {
            this.aiAgentOrchestratorUseCase = aiAgentOrchestratorUseCase;
            return this;
        }

        public final String getRequestModel() {
            return this.requestModel;
        }

        public final void setRequestModel(String requestModel) {
            this.requestModel = requestModel;
        }

        @Override
        public final Builder requestModel(String requestModel) {
            this.requestModel = requestModel;
            return this;
        }

        public final Integer getRequestMaxTokens() {
            return this.requestMaxTokens;
        }

        public final void setRequestMaxTokens(Integer requestMaxTokens) {
            this.requestMaxTokens = requestMaxTokens;
        }

        @Override
        public final Builder requestMaxTokens(Integer requestMaxTokens) {
            this.requestMaxTokens = requestMaxTokens;
            return this;
        }

        public final Float getTemperature() {
            return this.temperature;
        }

        public final void setTemperature(Float temperature) {
            this.temperature = temperature;
        }

        @Override
        public final Builder temperature(Float temperature) {
            this.temperature = temperature;
            return this;
        }

        public final Float getTopP() {
            return this.topP;
        }

        public final void setTopP(Float topP) {
            this.topP = topP;
        }

        @Override
        public final Builder topP(Float topP) {
            this.topP = topP;
            return this;
        }

        public final String getResponseModel() {
            return this.responseModel;
        }

        public final void setResponseModel(String responseModel) {
            this.responseModel = responseModel;
        }

        @Override
        public final Builder responseModel(String responseModel) {
            this.responseModel = responseModel;
            return this;
        }

        public final Collection<String> getResponseFinishReasons() {
            if (this.responseFinishReasons instanceof SdkAutoConstructList) {
                return null;
            }
            return this.responseFinishReasons;
        }

        public final void setResponseFinishReasons(Collection<String> responseFinishReasons) {
            this.responseFinishReasons = SpanFinishReasonListCopier.copy(responseFinishReasons);
        }

        @Override
        public final Builder responseFinishReasons(Collection<String> responseFinishReasons) {
            this.responseFinishReasons = SpanFinishReasonListCopier.copy(responseFinishReasons);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder responseFinishReasons(String ... responseFinishReasons) {
            this.responseFinishReasons(Arrays.asList(responseFinishReasons));
            return this;
        }

        public final Integer getUsageInputTokens() {
            return this.usageInputTokens;
        }

        public final void setUsageInputTokens(Integer usageInputTokens) {
            this.usageInputTokens = usageInputTokens;
        }

        @Override
        public final Builder usageInputTokens(Integer usageInputTokens) {
            this.usageInputTokens = usageInputTokens;
            return this;
        }

        public final Integer getUsageOutputTokens() {
            return this.usageOutputTokens;
        }

        public final void setUsageOutputTokens(Integer usageOutputTokens) {
            this.usageOutputTokens = usageOutputTokens;
        }

        @Override
        public final Builder usageOutputTokens(Integer usageOutputTokens) {
            this.usageOutputTokens = usageOutputTokens;
            return this;
        }

        public final Integer getUsageTotalTokens() {
            return this.usageTotalTokens;
        }

        public final void setUsageTotalTokens(Integer usageTotalTokens) {
            this.usageTotalTokens = usageTotalTokens;
        }

        @Override
        public final Builder usageTotalTokens(Integer usageTotalTokens) {
            this.usageTotalTokens = usageTotalTokens;
            return this;
        }

        public final Integer getCacheReadInputTokens() {
            return this.cacheReadInputTokens;
        }

        public final void setCacheReadInputTokens(Integer cacheReadInputTokens) {
            this.cacheReadInputTokens = cacheReadInputTokens;
        }

        @Override
        public final Builder cacheReadInputTokens(Integer cacheReadInputTokens) {
            this.cacheReadInputTokens = cacheReadInputTokens;
            return this;
        }

        public final Integer getCacheWriteInputTokens() {
            return this.cacheWriteInputTokens;
        }

        public final void setCacheWriteInputTokens(Integer cacheWriteInputTokens) {
            this.cacheWriteInputTokens = cacheWriteInputTokens;
        }

        @Override
        public final Builder cacheWriteInputTokens(Integer cacheWriteInputTokens) {
            this.cacheWriteInputTokens = cacheWriteInputTokens;
            return this;
        }

        public final List<SpanMessage.Builder> getInputMessages() {
            List<SpanMessage.Builder> result = SpanMessageListCopier.copyToBuilder(this.inputMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputMessages(Collection<SpanMessage.BuilderImpl> inputMessages) {
            this.inputMessages = SpanMessageListCopier.copyFromBuilder(inputMessages);
        }

        @Override
        public final Builder inputMessages(Collection<SpanMessage> inputMessages) {
            this.inputMessages = SpanMessageListCopier.copy(inputMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputMessages(SpanMessage ... inputMessages) {
            this.inputMessages(Arrays.asList(inputMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputMessages(Consumer<SpanMessage.Builder> ... inputMessages) {
            this.inputMessages(Stream.of(inputMessages).map(c -> (SpanMessage)((SpanMessage.Builder)SpanMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SpanMessage.Builder> getOutputMessages() {
            List<SpanMessage.Builder> result = SpanMessageListCopier.copyToBuilder(this.outputMessages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputMessages(Collection<SpanMessage.BuilderImpl> outputMessages) {
            this.outputMessages = SpanMessageListCopier.copyFromBuilder(outputMessages);
        }

        @Override
        public final Builder outputMessages(Collection<SpanMessage> outputMessages) {
            this.outputMessages = SpanMessageListCopier.copy(outputMessages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputMessages(SpanMessage ... outputMessages) {
            this.outputMessages(Arrays.asList(outputMessages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputMessages(Consumer<SpanMessage.Builder> ... outputMessages) {
            this.outputMessages(Stream.of(outputMessages).map(c -> (SpanMessage)((SpanMessage.Builder)SpanMessage.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SpanMessageValue.Builder> getSystemInstructions() {
            List<SpanMessageValue.Builder> result = SpanMessageValueListCopier.copyToBuilder(this.systemInstructions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystemInstructions(Collection<SpanMessageValue.BuilderImpl> systemInstructions) {
            this.systemInstructions = SpanMessageValueListCopier.copyFromBuilder(systemInstructions);
        }

        @Override
        public final Builder systemInstructions(Collection<SpanMessageValue> systemInstructions) {
            this.systemInstructions = SpanMessageValueListCopier.copy(systemInstructions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemInstructions(SpanMessageValue ... systemInstructions) {
            this.systemInstructions(Arrays.asList(systemInstructions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemInstructions(Consumer<SpanMessageValue.Builder> ... systemInstructions) {
            this.systemInstructions(Stream.of(systemInstructions).map(c -> (SpanMessageValue)((SpanMessageValue.Builder)SpanMessageValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPromptArn() {
            return this.promptArn;
        }

        public final void setPromptArn(String promptArn) {
            this.promptArn = promptArn;
        }

        @Override
        public final Builder promptArn(String promptArn) {
            this.promptArn = promptArn;
            return this;
        }

        public final String getPromptId() {
            return this.promptId;
        }

        public final void setPromptId(String promptId) {
            this.promptId = promptId;
        }

        @Override
        public final Builder promptId(String promptId) {
            this.promptId = promptId;
            return this;
        }

        public final String getPromptType() {
            return this.promptType;
        }

        public final void setPromptType(String promptType) {
            this.promptType = promptType;
        }

        @Override
        public final Builder promptType(String promptType) {
            this.promptType = promptType;
            return this;
        }

        @Override
        public final Builder promptType(AIPromptType promptType) {
            this.promptType(promptType == null ? null : promptType.toString());
            return this;
        }

        public final String getPromptName() {
            return this.promptName;
        }

        public final void setPromptName(String promptName) {
            this.promptName = promptName;
        }

        @Override
        public final Builder promptName(String promptName) {
            this.promptName = promptName;
            return this;
        }

        public final Integer getPromptVersion() {
            return this.promptVersion;
        }

        public final void setPromptVersion(Integer promptVersion) {
            this.promptVersion = promptVersion;
        }

        @Override
        public final Builder promptVersion(Integer promptVersion) {
            this.promptVersion = promptVersion;
            return this;
        }

        public SpanAttributes build() {
            return new SpanAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpanAttributes> {
        public Builder operationName(String var1);

        public Builder providerName(String var1);

        public Builder errorType(String var1);

        public Builder agentId(String var1);

        public Builder instanceArn(String var1);

        public Builder contactId(String var1);

        public Builder initialContactId(String var1);

        public Builder sessionName(String var1);

        public Builder aiAgentArn(String var1);

        public Builder aiAgentType(String var1);

        public Builder aiAgentType(AIAgentType var1);

        public Builder aiAgentName(String var1);

        public Builder aiAgentId(String var1);

        public Builder aiAgentVersion(Integer var1);

        public Builder aiAgentInvoker(String var1);

        public Builder aiAgentOrchestratorUseCase(String var1);

        public Builder requestModel(String var1);

        public Builder requestMaxTokens(Integer var1);

        public Builder temperature(Float var1);

        public Builder topP(Float var1);

        public Builder responseModel(String var1);

        public Builder responseFinishReasons(Collection<String> var1);

        public Builder responseFinishReasons(String ... var1);

        public Builder usageInputTokens(Integer var1);

        public Builder usageOutputTokens(Integer var1);

        public Builder usageTotalTokens(Integer var1);

        public Builder cacheReadInputTokens(Integer var1);

        public Builder cacheWriteInputTokens(Integer var1);

        public Builder inputMessages(Collection<SpanMessage> var1);

        public Builder inputMessages(SpanMessage ... var1);

        public Builder inputMessages(Consumer<SpanMessage.Builder> ... var1);

        public Builder outputMessages(Collection<SpanMessage> var1);

        public Builder outputMessages(SpanMessage ... var1);

        public Builder outputMessages(Consumer<SpanMessage.Builder> ... var1);

        public Builder systemInstructions(Collection<SpanMessageValue> var1);

        public Builder systemInstructions(SpanMessageValue ... var1);

        public Builder systemInstructions(Consumer<SpanMessageValue.Builder> ... var1);

        public Builder promptArn(String var1);

        public Builder promptId(String var1);

        public Builder promptType(String var1);

        public Builder promptType(AIPromptType var1);

        public Builder promptName(String var1);

        public Builder promptVersion(Integer var1);
    }
}

