/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.ToolExampleListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToolInstruction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToolInstruction> {
    private static final SdkField<String> INSTRUCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("instruction").getter(ToolInstruction.getter(ToolInstruction::instruction)).setter(ToolInstruction.setter(Builder::instruction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instruction").build()}).build();
    private static final SdkField<List<String>> EXAMPLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("examples").getter(ToolInstruction.getter(ToolInstruction::examples)).setter(ToolInstruction.setter(Builder::examples)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("examples").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTRUCTION_FIELD, EXAMPLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ToolInstruction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instruction;
    private final List<String> examples;

    private ToolInstruction(BuilderImpl builder) {
        this.instruction = builder.instruction;
        this.examples = builder.examples;
    }

    public final String instruction() {
        return this.instruction;
    }

    public final boolean hasExamples() {
        return this.examples != null && !(this.examples instanceof SdkAutoConstructList);
    }

    public final List<String> examples() {
        return this.examples;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instruction());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExamples() ? this.examples() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolInstruction)) {
            return false;
        }
        ToolInstruction other = (ToolInstruction)obj;
        return Objects.equals(this.instruction(), other.instruction()) && this.hasExamples() == other.hasExamples() && Objects.equals(this.examples(), other.examples());
    }

    public final String toString() {
        return ToString.builder((String)"ToolInstruction").add("Instruction", (Object)this.instruction()).add("Examples", this.hasExamples() ? this.examples() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instruction": {
                return Optional.ofNullable(clazz.cast(this.instruction()));
            }
            case "examples": {
                return Optional.ofNullable(clazz.cast(this.examples()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instruction", INSTRUCTION_FIELD);
        map.put("examples", EXAMPLES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolInstruction, T> g) {
        return obj -> g.apply((ToolInstruction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instruction;
        private List<String> examples = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ToolInstruction model) {
            this.instruction(model.instruction);
            this.examples(model.examples);
        }

        public final String getInstruction() {
            return this.instruction;
        }

        public final void setInstruction(String instruction) {
            this.instruction = instruction;
        }

        @Override
        public final Builder instruction(String instruction) {
            this.instruction = instruction;
            return this;
        }

        public final Collection<String> getExamples() {
            if (this.examples instanceof SdkAutoConstructList) {
                return null;
            }
            return this.examples;
        }

        public final void setExamples(Collection<String> examples) {
            this.examples = ToolExampleListCopier.copy(examples);
        }

        @Override
        public final Builder examples(Collection<String> examples) {
            this.examples = ToolExampleListCopier.copy(examples);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder examples(String ... examples) {
            this.examples(Arrays.asList(examples));
            return this;
        }

        public ToolInstruction build() {
            return new ToolInstruction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToolInstruction> {
        public Builder instruction(String var1);

        public Builder examples(Collection<String> var1);

        public Builder examples(String ... var1);
    }
}

