/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.qconnect.model.AIPromptInferenceConfiguration;
import software.amazon.awssdk.services.qconnect.model.AIPromptTemplateConfiguration;
import software.amazon.awssdk.services.qconnect.model.QConnectRequest;
import software.amazon.awssdk.services.qconnect.model.VisibilityStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAiPromptRequest
extends QConnectRequest
implements ToCopyableBuilder<Builder, UpdateAiPromptRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::clientToken)).setter(UpdateAiPromptRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> ASSISTANT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assistantId").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::assistantId)).setter(UpdateAiPromptRequest.setter(Builder::assistantId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assistantId").build()}).build();
    private static final SdkField<String> AI_PROMPT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("aiPromptId").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::aiPromptId)).setter(UpdateAiPromptRequest.setter(Builder::aiPromptId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("aiPromptId").build()}).build();
    private static final SdkField<String> VISIBILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("visibilityStatus").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::visibilityStatusAsString)).setter(UpdateAiPromptRequest.setter(Builder::visibilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("visibilityStatus").build()}).build();
    private static final SdkField<AIPromptTemplateConfiguration> TEMPLATE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("templateConfiguration").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::templateConfiguration)).setter(UpdateAiPromptRequest.setter(Builder::templateConfiguration)).constructor(AIPromptTemplateConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateConfiguration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::description)).setter(UpdateAiPromptRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("modelId").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::modelId)).setter(UpdateAiPromptRequest.setter(Builder::modelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("modelId").build()}).build();
    private static final SdkField<AIPromptInferenceConfiguration> INFERENCE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("inferenceConfiguration").getter(UpdateAiPromptRequest.getter(UpdateAiPromptRequest::inferenceConfiguration)).setter(UpdateAiPromptRequest.setter(Builder::inferenceConfiguration)).constructor(AIPromptInferenceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inferenceConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, ASSISTANT_ID_FIELD, AI_PROMPT_ID_FIELD, VISIBILITY_STATUS_FIELD, TEMPLATE_CONFIGURATION_FIELD, DESCRIPTION_FIELD, MODEL_ID_FIELD, INFERENCE_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAiPromptRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String assistantId;
    private final String aiPromptId;
    private final String visibilityStatus;
    private final AIPromptTemplateConfiguration templateConfiguration;
    private final String description;
    private final String modelId;
    private final AIPromptInferenceConfiguration inferenceConfiguration;

    private UpdateAiPromptRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.assistantId = builder.assistantId;
        this.aiPromptId = builder.aiPromptId;
        this.visibilityStatus = builder.visibilityStatus;
        this.templateConfiguration = builder.templateConfiguration;
        this.description = builder.description;
        this.modelId = builder.modelId;
        this.inferenceConfiguration = builder.inferenceConfiguration;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String assistantId() {
        return this.assistantId;
    }

    public final String aiPromptId() {
        return this.aiPromptId;
    }

    public final VisibilityStatus visibilityStatus() {
        return VisibilityStatus.fromValue(this.visibilityStatus);
    }

    public final String visibilityStatusAsString() {
        return this.visibilityStatus;
    }

    public final AIPromptTemplateConfiguration templateConfiguration() {
        return this.templateConfiguration;
    }

    public final String description() {
        return this.description;
    }

    public final String modelId() {
        return this.modelId;
    }

    public final AIPromptInferenceConfiguration inferenceConfiguration() {
        return this.inferenceConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.assistantId());
        hashCode = 31 * hashCode + Objects.hashCode(this.aiPromptId());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.inferenceConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAiPromptRequest)) {
            return false;
        }
        UpdateAiPromptRequest other = (UpdateAiPromptRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.assistantId(), other.assistantId()) && Objects.equals(this.aiPromptId(), other.aiPromptId()) && Objects.equals(this.visibilityStatusAsString(), other.visibilityStatusAsString()) && Objects.equals(this.templateConfiguration(), other.templateConfiguration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.modelId(), other.modelId()) && Objects.equals(this.inferenceConfiguration(), other.inferenceConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAiPromptRequest").add("ClientToken", (Object)this.clientToken()).add("AssistantId", (Object)this.assistantId()).add("AiPromptId", (Object)this.aiPromptId()).add("VisibilityStatus", (Object)this.visibilityStatusAsString()).add("TemplateConfiguration", (Object)this.templateConfiguration()).add("Description", (Object)this.description()).add("ModelId", (Object)this.modelId()).add("InferenceConfiguration", (Object)this.inferenceConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "assistantId": {
                return Optional.ofNullable(clazz.cast(this.assistantId()));
            }
            case "aiPromptId": {
                return Optional.ofNullable(clazz.cast(this.aiPromptId()));
            }
            case "visibilityStatus": {
                return Optional.ofNullable(clazz.cast(this.visibilityStatusAsString()));
            }
            case "templateConfiguration": {
                return Optional.ofNullable(clazz.cast(this.templateConfiguration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "modelId": {
                return Optional.ofNullable(clazz.cast(this.modelId()));
            }
            case "inferenceConfiguration": {
                return Optional.ofNullable(clazz.cast(this.inferenceConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("assistantId", ASSISTANT_ID_FIELD);
        map.put("aiPromptId", AI_PROMPT_ID_FIELD);
        map.put("visibilityStatus", VISIBILITY_STATUS_FIELD);
        map.put("templateConfiguration", TEMPLATE_CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("modelId", MODEL_ID_FIELD);
        map.put("inferenceConfiguration", INFERENCE_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAiPromptRequest, T> g) {
        return obj -> g.apply((UpdateAiPromptRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends QConnectRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String assistantId;
        private String aiPromptId;
        private String visibilityStatus;
        private AIPromptTemplateConfiguration templateConfiguration;
        private String description;
        private String modelId;
        private AIPromptInferenceConfiguration inferenceConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAiPromptRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.assistantId(model.assistantId);
            this.aiPromptId(model.aiPromptId);
            this.visibilityStatus(model.visibilityStatus);
            this.templateConfiguration(model.templateConfiguration);
            this.description(model.description);
            this.modelId(model.modelId);
            this.inferenceConfiguration(model.inferenceConfiguration);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getAssistantId() {
            return this.assistantId;
        }

        public final void setAssistantId(String assistantId) {
            this.assistantId = assistantId;
        }

        @Override
        public final Builder assistantId(String assistantId) {
            this.assistantId = assistantId;
            return this;
        }

        public final String getAiPromptId() {
            return this.aiPromptId;
        }

        public final void setAiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
        }

        @Override
        public final Builder aiPromptId(String aiPromptId) {
            this.aiPromptId = aiPromptId;
            return this;
        }

        public final String getVisibilityStatus() {
            return this.visibilityStatus;
        }

        public final void setVisibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
        }

        @Override
        public final Builder visibilityStatus(String visibilityStatus) {
            this.visibilityStatus = visibilityStatus;
            return this;
        }

        @Override
        public final Builder visibilityStatus(VisibilityStatus visibilityStatus) {
            this.visibilityStatus(visibilityStatus == null ? null : visibilityStatus.toString());
            return this;
        }

        public final AIPromptTemplateConfiguration.Builder getTemplateConfiguration() {
            return this.templateConfiguration != null ? this.templateConfiguration.toBuilder() : null;
        }

        public final void setTemplateConfiguration(AIPromptTemplateConfiguration.BuilderImpl templateConfiguration) {
            this.templateConfiguration = templateConfiguration != null ? templateConfiguration.build() : null;
        }

        @Override
        public final Builder templateConfiguration(AIPromptTemplateConfiguration templateConfiguration) {
            this.templateConfiguration = templateConfiguration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getModelId() {
            return this.modelId;
        }

        public final void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Override
        public final Builder modelId(String modelId) {
            this.modelId = modelId;
            return this;
        }

        public final AIPromptInferenceConfiguration.Builder getInferenceConfiguration() {
            return this.inferenceConfiguration != null ? this.inferenceConfiguration.toBuilder() : null;
        }

        public final void setInferenceConfiguration(AIPromptInferenceConfiguration.BuilderImpl inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration != null ? inferenceConfiguration.build() : null;
        }

        @Override
        public final Builder inferenceConfiguration(AIPromptInferenceConfiguration inferenceConfiguration) {
            this.inferenceConfiguration = inferenceConfiguration;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAiPromptRequest build() {
            return new UpdateAiPromptRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends QConnectRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAiPromptRequest> {
        public Builder clientToken(String var1);

        public Builder assistantId(String var1);

        public Builder aiPromptId(String var1);

        public Builder visibilityStatus(String var1);

        public Builder visibilityStatus(VisibilityStatus var1);

        public Builder templateConfiguration(AIPromptTemplateConfiguration var1);

        default public Builder templateConfiguration(Consumer<AIPromptTemplateConfiguration.Builder> templateConfiguration) {
            return this.templateConfiguration((AIPromptTemplateConfiguration)((AIPromptTemplateConfiguration.Builder)AIPromptTemplateConfiguration.builder().applyMutation(templateConfiguration)).build());
        }

        public Builder description(String var1);

        public Builder modelId(String var1);

        public Builder inferenceConfiguration(AIPromptInferenceConfiguration var1);

        default public Builder inferenceConfiguration(Consumer<AIPromptInferenceConfiguration.Builder> inferenceConfiguration) {
            return this.inferenceConfiguration((AIPromptInferenceConfiguration)((AIPromptInferenceConfiguration.Builder)AIPromptInferenceConfiguration.builder().applyMutation(inferenceConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

