/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.qconnect.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.qconnect.model.WhatsAppMessageTemplateComponentsCopier;
import software.amazon.awssdk.services.qconnect.model.WhatsAppSourceConfigurationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WhatsAppMessageTemplateSourceConfigurationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WhatsAppMessageTemplateSourceConfigurationSummary> {
    private static final SdkField<String> BUSINESS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("businessAccountId").getter(WhatsAppMessageTemplateSourceConfigurationSummary.getter(WhatsAppMessageTemplateSourceConfigurationSummary::businessAccountId)).setter(WhatsAppMessageTemplateSourceConfigurationSummary.setter(Builder::businessAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("businessAccountId").build()}).build();
    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("templateId").getter(WhatsAppMessageTemplateSourceConfigurationSummary.getter(WhatsAppMessageTemplateSourceConfigurationSummary::templateId)).setter(WhatsAppMessageTemplateSourceConfigurationSummary.setter(Builder::templateId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(WhatsAppMessageTemplateSourceConfigurationSummary.getter(WhatsAppMessageTemplateSourceConfigurationSummary::name)).setter(WhatsAppMessageTemplateSourceConfigurationSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("language").getter(WhatsAppMessageTemplateSourceConfigurationSummary.getter(WhatsAppMessageTemplateSourceConfigurationSummary::language)).setter(WhatsAppMessageTemplateSourceConfigurationSummary.setter(Builder::language)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("language").build()}).build();
    private static final SdkField<List<String>> COMPONENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("components").getter(WhatsAppMessageTemplateSourceConfigurationSummary.getter(WhatsAppMessageTemplateSourceConfigurationSummary::components)).setter(WhatsAppMessageTemplateSourceConfigurationSummary.setter(Builder::components)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("components").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WhatsAppMessageTemplateSourceConfigurationSummary.getter(WhatsAppMessageTemplateSourceConfigurationSummary::statusAsString)).setter(WhatsAppMessageTemplateSourceConfigurationSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusReason").getter(WhatsAppMessageTemplateSourceConfigurationSummary.getter(WhatsAppMessageTemplateSourceConfigurationSummary::statusReason)).setter(WhatsAppMessageTemplateSourceConfigurationSummary.setter(Builder::statusReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BUSINESS_ACCOUNT_ID_FIELD, TEMPLATE_ID_FIELD, NAME_FIELD, LANGUAGE_FIELD, COMPONENTS_FIELD, STATUS_FIELD, STATUS_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WhatsAppMessageTemplateSourceConfigurationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String businessAccountId;
    private final String templateId;
    private final String name;
    private final String language;
    private final List<String> components;
    private final String status;
    private final String statusReason;

    private WhatsAppMessageTemplateSourceConfigurationSummary(BuilderImpl builder) {
        this.businessAccountId = builder.businessAccountId;
        this.templateId = builder.templateId;
        this.name = builder.name;
        this.language = builder.language;
        this.components = builder.components;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
    }

    public final String businessAccountId() {
        return this.businessAccountId;
    }

    public final String templateId() {
        return this.templateId;
    }

    public final String name() {
        return this.name;
    }

    public final String language() {
        return this.language;
    }

    public final boolean hasComponents() {
        return this.components != null && !(this.components instanceof SdkAutoConstructList);
    }

    public final List<String> components() {
        return this.components;
    }

    public final WhatsAppSourceConfigurationStatus status() {
        return WhatsAppSourceConfigurationStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusReason() {
        return this.statusReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.businessAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.templateId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.language());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasComponents() ? this.components() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WhatsAppMessageTemplateSourceConfigurationSummary)) {
            return false;
        }
        WhatsAppMessageTemplateSourceConfigurationSummary other = (WhatsAppMessageTemplateSourceConfigurationSummary)obj;
        return Objects.equals(this.businessAccountId(), other.businessAccountId()) && Objects.equals(this.templateId(), other.templateId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.language(), other.language()) && this.hasComponents() == other.hasComponents() && Objects.equals(this.components(), other.components()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusReason(), other.statusReason());
    }

    public final String toString() {
        return ToString.builder((String)"WhatsAppMessageTemplateSourceConfigurationSummary").add("BusinessAccountId", (Object)this.businessAccountId()).add("TemplateId", (Object)this.templateId()).add("Name", (Object)this.name()).add("Language", (Object)this.language()).add("Components", this.hasComponents() ? this.components() : null).add("Status", (Object)this.statusAsString()).add("StatusReason", (Object)(this.statusReason() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "businessAccountId": {
                return Optional.ofNullable(clazz.cast(this.businessAccountId()));
            }
            case "templateId": {
                return Optional.ofNullable(clazz.cast(this.templateId()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "language": {
                return Optional.ofNullable(clazz.cast(this.language()));
            }
            case "components": {
                return Optional.ofNullable(clazz.cast(this.components()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusReason": {
                return Optional.ofNullable(clazz.cast(this.statusReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("businessAccountId", BUSINESS_ACCOUNT_ID_FIELD);
        map.put("templateId", TEMPLATE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("language", LANGUAGE_FIELD);
        map.put("components", COMPONENTS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WhatsAppMessageTemplateSourceConfigurationSummary, T> g) {
        return obj -> g.apply((WhatsAppMessageTemplateSourceConfigurationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String businessAccountId;
        private String templateId;
        private String name;
        private String language;
        private List<String> components = DefaultSdkAutoConstructList.getInstance();
        private String status;
        private String statusReason;

        private BuilderImpl() {
        }

        private BuilderImpl(WhatsAppMessageTemplateSourceConfigurationSummary model) {
            this.businessAccountId(model.businessAccountId);
            this.templateId(model.templateId);
            this.name(model.name);
            this.language(model.language);
            this.components(model.components);
            this.status(model.status);
            this.statusReason(model.statusReason);
        }

        public final String getBusinessAccountId() {
            return this.businessAccountId;
        }

        public final void setBusinessAccountId(String businessAccountId) {
            this.businessAccountId = businessAccountId;
        }

        @Override
        public final Builder businessAccountId(String businessAccountId) {
            this.businessAccountId = businessAccountId;
            return this;
        }

        public final String getTemplateId() {
            return this.templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLanguage() {
            return this.language;
        }

        public final void setLanguage(String language) {
            this.language = language;
        }

        @Override
        public final Builder language(String language) {
            this.language = language;
            return this;
        }

        public final Collection<String> getComponents() {
            if (this.components instanceof SdkAutoConstructList) {
                return null;
            }
            return this.components;
        }

        public final void setComponents(Collection<String> components) {
            this.components = WhatsAppMessageTemplateComponentsCopier.copy(components);
        }

        @Override
        public final Builder components(Collection<String> components) {
            this.components = WhatsAppMessageTemplateComponentsCopier.copy(components);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder components(String ... components) {
            this.components(Arrays.asList(components));
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WhatsAppSourceConfigurationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return this.statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public WhatsAppMessageTemplateSourceConfigurationSummary build() {
            return new WhatsAppMessageTemplateSourceConfigurationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WhatsAppMessageTemplateSourceConfigurationSummary> {
        public Builder businessAccountId(String var1);

        public Builder templateId(String var1);

        public Builder name(String var1);

        public Builder language(String var1);

        public Builder components(Collection<String> var1);

        public Builder components(String ... var1);

        public Builder status(String var1);

        public Builder status(WhatsAppSourceConfigurationStatus var1);

        public Builder statusReason(String var1);
    }
}

