/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ChannelRole {
    ASKER("ASKER"),
    EXPERT("EXPERT"),
    MODERATOR("MODERATOR"),
    SUPPORTREQUESTOR("SUPPORTREQUESTOR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ChannelRole> VALUE_MAP;
    private final String value;

    private ChannelRole(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ChannelRole fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ChannelRole> knownValues() {
        EnumSet<ChannelRole> knownValues = EnumSet.allOf(ChannelRole.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ChannelRole.class, ChannelRole::toString);
    }
}

