/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.repostspace.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.repostspace.model.AllowedDomainsListCopier;
import software.amazon.awssdk.services.repostspace.model.FeatureEnableStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SupportedEmailDomainsStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SupportedEmailDomainsStatus> {
    private static final SdkField<String> ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enabled").getter(SupportedEmailDomainsStatus.getter(SupportedEmailDomainsStatus::enabledAsString)).setter(SupportedEmailDomainsStatus.setter(Builder::enabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabled").build()}).build();
    private static final SdkField<List<String>> ALLOWED_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedDomains").getter(SupportedEmailDomainsStatus.getter(SupportedEmailDomainsStatus::allowedDomains)).setter(SupportedEmailDomainsStatus.setter(Builder::allowedDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD, ALLOWED_DOMAINS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SupportedEmailDomainsStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String enabled;
    private final List<String> allowedDomains;

    private SupportedEmailDomainsStatus(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.allowedDomains = builder.allowedDomains;
    }

    public final FeatureEnableStatus enabled() {
        return FeatureEnableStatus.fromValue(this.enabled);
    }

    public final String enabledAsString() {
        return this.enabled;
    }

    public final boolean hasAllowedDomains() {
        return this.allowedDomains != null && !(this.allowedDomains instanceof SdkAutoConstructList);
    }

    public final List<String> allowedDomains() {
        return this.allowedDomains;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.enabledAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedDomains() ? this.allowedDomains() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SupportedEmailDomainsStatus)) {
            return false;
        }
        SupportedEmailDomainsStatus other = (SupportedEmailDomainsStatus)obj;
        return Objects.equals(this.enabledAsString(), other.enabledAsString()) && this.hasAllowedDomains() == other.hasAllowedDomains() && Objects.equals(this.allowedDomains(), other.allowedDomains());
    }

    public final String toString() {
        return ToString.builder((String)"SupportedEmailDomainsStatus").add("Enabled", (Object)this.enabledAsString()).add("AllowedDomains", (Object)(this.allowedDomains() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "enabled": {
                return Optional.ofNullable(clazz.cast(this.enabledAsString()));
            }
            case "allowedDomains": {
                return Optional.ofNullable(clazz.cast(this.allowedDomains()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("enabled", ENABLED_FIELD);
        map.put("allowedDomains", ALLOWED_DOMAINS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SupportedEmailDomainsStatus, T> g) {
        return obj -> g.apply((SupportedEmailDomainsStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String enabled;
        private List<String> allowedDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SupportedEmailDomainsStatus model) {
            this.enabled(model.enabled);
            this.allowedDomains(model.allowedDomains);
        }

        public final String getEnabled() {
            return this.enabled;
        }

        public final void setEnabled(String enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(String enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public final Builder enabled(FeatureEnableStatus enabled) {
            this.enabled(enabled == null ? null : enabled.toString());
            return this;
        }

        public final Collection<String> getAllowedDomains() {
            if (this.allowedDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedDomains;
        }

        public final void setAllowedDomains(Collection<String> allowedDomains) {
            this.allowedDomains = AllowedDomainsListCopier.copy(allowedDomains);
        }

        @Override
        public final Builder allowedDomains(Collection<String> allowedDomains) {
            this.allowedDomains = AllowedDomainsListCopier.copy(allowedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedDomains(String ... allowedDomains) {
            this.allowedDomains(Arrays.asList(allowedDomains));
            return this;
        }

        public SupportedEmailDomainsStatus build() {
            return new SupportedEmailDomainsStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SupportedEmailDomainsStatus> {
        public Builder enabled(String var1);

        public Builder enabled(FeatureEnableStatus var1);

        public Builder allowedDomains(Collection<String> var1);

        public Builder allowedDomains(String ... var1);
    }
}

