/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum BucketLocationConstraint {
    EU("EU"),
    EU_WEST_1("eu-west-1"),
    US_WEST_1("us-west-1"),
    US_WEST_2("us-west-2"),
    AP_SOUTH_1("ap-south-1"),
    AP_SOUTHEAST_1("ap-southeast-1"),
    AP_SOUTHEAST_2("ap-southeast-2"),
    AP_NORTHEAST_1("ap-northeast-1"),
    SA_EAST_1("sa-east-1"),
    CN_NORTH_1("cn-north-1"),
    EU_CENTRAL_1("eu-central-1"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, BucketLocationConstraint> VALUE_MAP;
    private final String value;

    private BucketLocationConstraint(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static BucketLocationConstraint fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<BucketLocationConstraint> knownValues() {
        EnumSet<BucketLocationConstraint> knownValues = EnumSet.allOf(BucketLocationConstraint.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(BucketLocationConstraint.class, BucketLocationConstraint::toString);
    }
}

