/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum S3PrefixType {
    OBJECT("Object"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, S3PrefixType> VALUE_MAP;
    private final String value;

    private S3PrefixType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static S3PrefixType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<S3PrefixType> knownValues() {
        EnumSet<S3PrefixType> knownValues = EnumSet.allOf(S3PrefixType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(S3PrefixType.class, S3PrefixType::toString);
    }
}

