/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3control.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScopePermission {
    GET_OBJECT("GetObject"),
    GET_OBJECT_ATTRIBUTES("GetObjectAttributes"),
    LIST_MULTIPART_UPLOAD_PARTS("ListMultipartUploadParts"),
    LIST_BUCKET("ListBucket"),
    LIST_BUCKET_MULTIPART_UPLOADS("ListBucketMultipartUploads"),
    PUT_OBJECT("PutObject"),
    DELETE_OBJECT("DeleteObject"),
    ABORT_MULTIPART_UPLOAD("AbortMultipartUpload"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScopePermission> VALUE_MAP;
    private final String value;

    private ScopePermission(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScopePermission fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScopePermission> knownValues() {
        EnumSet<ScopePermission> knownValues = EnumSet.allOf(ScopePermission.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScopePermission.class, ScopePermission::toString);
    }
}

