/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AutoMLS3DataType {
    MANIFEST_FILE("ManifestFile"),
    S3_PREFIX("S3Prefix"),
    AUGMENTED_MANIFEST_FILE("AugmentedManifestFile"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AutoMLS3DataType> VALUE_MAP;
    private final String value;

    private AutoMLS3DataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLS3DataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLS3DataType> knownValues() {
        EnumSet<AutoMLS3DataType> knownValues = EnumSet.allOf(AutoMLS3DataType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AutoMLS3DataType.class, AutoMLS3DataType::toString);
    }
}

