/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.BatchAddClusterNodesErrorCode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAddClusterNodesError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchAddClusterNodesError> {
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupName").getter(BatchAddClusterNodesError.getter(BatchAddClusterNodesError::instanceGroupName)).setter(BatchAddClusterNodesError.setter(Builder::instanceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(BatchAddClusterNodesError.getter(BatchAddClusterNodesError::errorCodeAsString)).setter(BatchAddClusterNodesError.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<Integer> FAILED_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FailedCount").getter(BatchAddClusterNodesError.getter(BatchAddClusterNodesError::failedCount)).setter(BatchAddClusterNodesError.setter(Builder::failedCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedCount").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(BatchAddClusterNodesError.getter(BatchAddClusterNodesError::message)).setter(BatchAddClusterNodesError.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_GROUP_NAME_FIELD, ERROR_CODE_FIELD, FAILED_COUNT_FIELD, MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchAddClusterNodesError.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String instanceGroupName;
    private final String errorCode;
    private final Integer failedCount;
    private final String message;

    private BatchAddClusterNodesError(BuilderImpl builder) {
        this.instanceGroupName = builder.instanceGroupName;
        this.errorCode = builder.errorCode;
        this.failedCount = builder.failedCount;
        this.message = builder.message;
    }

    public final String instanceGroupName() {
        return this.instanceGroupName;
    }

    public final BatchAddClusterNodesErrorCode errorCode() {
        return BatchAddClusterNodesErrorCode.fromValue(this.errorCode);
    }

    public final String errorCodeAsString() {
        return this.errorCode;
    }

    public final Integer failedCount() {
        return this.failedCount;
    }

    public final String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAddClusterNodesError)) {
            return false;
        }
        BatchAddClusterNodesError other = (BatchAddClusterNodesError)obj;
        return Objects.equals(this.instanceGroupName(), other.instanceGroupName()) && Objects.equals(this.errorCodeAsString(), other.errorCodeAsString()) && Objects.equals(this.failedCount(), other.failedCount()) && Objects.equals(this.message(), other.message());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAddClusterNodesError").add("InstanceGroupName", (Object)this.instanceGroupName()).add("ErrorCode", (Object)this.errorCodeAsString()).add("FailedCount", (Object)this.failedCount()).add("Message", (Object)this.message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceGroupName": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupName()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCodeAsString()));
            }
            case "FailedCount": {
                return Optional.ofNullable(clazz.cast(this.failedCount()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
        map.put("ErrorCode", ERROR_CODE_FIELD);
        map.put("FailedCount", FAILED_COUNT_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAddClusterNodesError, T> g) {
        return obj -> g.apply((BatchAddClusterNodesError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String instanceGroupName;
        private String errorCode;
        private Integer failedCount;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAddClusterNodesError model) {
            this.instanceGroupName(model.instanceGroupName);
            this.errorCode(model.errorCode);
            this.failedCount(model.failedCount);
            this.message(model.message);
        }

        public final String getInstanceGroupName() {
            return this.instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        @Override
        public final Builder errorCode(BatchAddClusterNodesErrorCode errorCode) {
            this.errorCode(errorCode == null ? null : errorCode.toString());
            return this;
        }

        public final Integer getFailedCount() {
            return this.failedCount;
        }

        public final void setFailedCount(Integer failedCount) {
            this.failedCount = failedCount;
        }

        @Override
        public final Builder failedCount(Integer failedCount) {
            this.failedCount = failedCount;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public BatchAddClusterNodesError build() {
            return new BatchAddClusterNodesError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchAddClusterNodesError> {
        public Builder instanceGroupName(String var1);

        public Builder errorCode(String var1);

        public Builder errorCode(BatchAddClusterNodesErrorCode var1);

        public Builder failedCount(Integer var1);

        public Builder message(String var1);
    }
}

