/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.BatchAddClusterNodesError;
import software.amazon.awssdk.services.sagemaker.model.BatchAddClusterNodesErrorListCopier;
import software.amazon.awssdk.services.sagemaker.model.NodeAdditionResult;
import software.amazon.awssdk.services.sagemaker.model.NodeAdditionResultListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchAddClusterNodesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, BatchAddClusterNodesResponse> {
    private static final SdkField<List<NodeAdditionResult>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Successful").getter(BatchAddClusterNodesResponse.getter(BatchAddClusterNodesResponse::successful)).setter(BatchAddClusterNodesResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NodeAdditionResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchAddClusterNodesError>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Failed").getter(BatchAddClusterNodesResponse.getter(BatchAddClusterNodesResponse::failed)).setter(BatchAddClusterNodesResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchAddClusterNodesError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD, FAILED_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchAddClusterNodesResponse.memberNameToFieldInitializer();
    private final List<NodeAdditionResult> successful;
    private final List<BatchAddClusterNodesError> failed;

    private BatchAddClusterNodesResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<NodeAdditionResult> successful() {
        return this.successful;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<BatchAddClusterNodesError> failed() {
        return this.failed;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAddClusterNodesResponse)) {
            return false;
        }
        BatchAddClusterNodesResponse other = (BatchAddClusterNodesResponse)((Object)obj);
        return this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed());
    }

    public final String toString() {
        return ToString.builder((String)"BatchAddClusterNodesResponse").add("Successful", this.hasSuccessful() ? this.successful() : null).add("Failed", this.hasFailed() ? this.failed() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Successful", SUCCESSFUL_FIELD);
        map.put("Failed", FAILED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchAddClusterNodesResponse, T> g) {
        return obj -> g.apply((BatchAddClusterNodesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<NodeAdditionResult> successful = DefaultSdkAutoConstructList.getInstance();
        private List<BatchAddClusterNodesError> failed = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAddClusterNodesResponse model) {
            super(model);
            this.successful(model.successful);
            this.failed(model.failed);
        }

        public final List<NodeAdditionResult.Builder> getSuccessful() {
            List<NodeAdditionResult.Builder> result = NodeAdditionResultListCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<NodeAdditionResult.BuilderImpl> successful) {
            this.successful = NodeAdditionResultListCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<NodeAdditionResult> successful) {
            this.successful = NodeAdditionResultListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(NodeAdditionResult ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<NodeAdditionResult.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (NodeAdditionResult)((NodeAdditionResult.Builder)NodeAdditionResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchAddClusterNodesError.Builder> getFailed() {
            List<BatchAddClusterNodesError.Builder> result = BatchAddClusterNodesErrorListCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchAddClusterNodesError.BuilderImpl> failed) {
            this.failed = BatchAddClusterNodesErrorListCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchAddClusterNodesError> failed) {
            this.failed = BatchAddClusterNodesErrorListCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchAddClusterNodesError ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchAddClusterNodesError.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchAddClusterNodesError)((BatchAddClusterNodesError.Builder)BatchAddClusterNodesError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchAddClusterNodesResponse build() {
            return new BatchAddClusterNodesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchAddClusterNodesResponse> {
        public Builder successful(Collection<NodeAdditionResult> var1);

        public Builder successful(NodeAdditionResult ... var1);

        public Builder successful(Consumer<NodeAdditionResult.Builder> ... var1);

        public Builder failed(Collection<BatchAddClusterNodesError> var1);

        public Builder failed(BatchAddClusterNodesError ... var1);

        public Builder failed(Consumer<BatchAddClusterNodesError.Builder> ... var1);
    }
}

