/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.BatchReplaceClusterNodeLogicalIdsError;
import software.amazon.awssdk.services.sagemaker.model.BatchReplaceClusterNodeLogicalIdsErrorsCopier;
import software.amazon.awssdk.services.sagemaker.model.BatchReplaceClusterNodesError;
import software.amazon.awssdk.services.sagemaker.model.BatchReplaceClusterNodesErrorsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeIdsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterNodeLogicalIdListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchReplaceClusterNodesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, BatchReplaceClusterNodesResponse> {
    private static final SdkField<List<String>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Successful").getter(BatchReplaceClusterNodesResponse.getter(BatchReplaceClusterNodesResponse::successful)).setter(BatchReplaceClusterNodesResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchReplaceClusterNodesError>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Failed").getter(BatchReplaceClusterNodesResponse.getter(BatchReplaceClusterNodesResponse::failed)).setter(BatchReplaceClusterNodesResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchReplaceClusterNodesError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchReplaceClusterNodeLogicalIdsError>> FAILED_NODE_LOGICAL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("FailedNodeLogicalIds").getter(BatchReplaceClusterNodesResponse.getter(BatchReplaceClusterNodesResponse::failedNodeLogicalIds)).setter(BatchReplaceClusterNodesResponse.setter(Builder::failedNodeLogicalIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailedNodeLogicalIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchReplaceClusterNodeLogicalIdsError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SUCCESSFUL_NODE_LOGICAL_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SuccessfulNodeLogicalIds").getter(BatchReplaceClusterNodesResponse.getter(BatchReplaceClusterNodesResponse::successfulNodeLogicalIds)).setter(BatchReplaceClusterNodesResponse.setter(Builder::successfulNodeLogicalIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuccessfulNodeLogicalIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUCCESSFUL_FIELD, FAILED_FIELD, FAILED_NODE_LOGICAL_IDS_FIELD, SUCCESSFUL_NODE_LOGICAL_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchReplaceClusterNodesResponse.memberNameToFieldInitializer();
    private final List<String> successful;
    private final List<BatchReplaceClusterNodesError> failed;
    private final List<BatchReplaceClusterNodeLogicalIdsError> failedNodeLogicalIds;
    private final List<String> successfulNodeLogicalIds;

    private BatchReplaceClusterNodesResponse(BuilderImpl builder) {
        super(builder);
        this.successful = builder.successful;
        this.failed = builder.failed;
        this.failedNodeLogicalIds = builder.failedNodeLogicalIds;
        this.successfulNodeLogicalIds = builder.successfulNodeLogicalIds;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<String> successful() {
        return this.successful;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<BatchReplaceClusterNodesError> failed() {
        return this.failed;
    }

    public final boolean hasFailedNodeLogicalIds() {
        return this.failedNodeLogicalIds != null && !(this.failedNodeLogicalIds instanceof SdkAutoConstructList);
    }

    public final List<BatchReplaceClusterNodeLogicalIdsError> failedNodeLogicalIds() {
        return this.failedNodeLogicalIds;
    }

    public final boolean hasSuccessfulNodeLogicalIds() {
        return this.successfulNodeLogicalIds != null && !(this.successfulNodeLogicalIds instanceof SdkAutoConstructList);
    }

    public final List<String> successfulNodeLogicalIds() {
        return this.successfulNodeLogicalIds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailedNodeLogicalIds() ? this.failedNodeLogicalIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessfulNodeLogicalIds() ? this.successfulNodeLogicalIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchReplaceClusterNodesResponse)) {
            return false;
        }
        BatchReplaceClusterNodesResponse other = (BatchReplaceClusterNodesResponse)((Object)obj);
        return this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful()) && this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed()) && this.hasFailedNodeLogicalIds() == other.hasFailedNodeLogicalIds() && Objects.equals(this.failedNodeLogicalIds(), other.failedNodeLogicalIds()) && this.hasSuccessfulNodeLogicalIds() == other.hasSuccessfulNodeLogicalIds() && Objects.equals(this.successfulNodeLogicalIds(), other.successfulNodeLogicalIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchReplaceClusterNodesResponse").add("Successful", this.hasSuccessful() ? this.successful() : null).add("Failed", this.hasFailed() ? this.failed() : null).add("FailedNodeLogicalIds", this.hasFailedNodeLogicalIds() ? this.failedNodeLogicalIds() : null).add("SuccessfulNodeLogicalIds", this.hasSuccessfulNodeLogicalIds() ? this.successfulNodeLogicalIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
            case "Failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "FailedNodeLogicalIds": {
                return Optional.ofNullable(clazz.cast(this.failedNodeLogicalIds()));
            }
            case "SuccessfulNodeLogicalIds": {
                return Optional.ofNullable(clazz.cast(this.successfulNodeLogicalIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Successful", SUCCESSFUL_FIELD);
        map.put("Failed", FAILED_FIELD);
        map.put("FailedNodeLogicalIds", FAILED_NODE_LOGICAL_IDS_FIELD);
        map.put("SuccessfulNodeLogicalIds", SUCCESSFUL_NODE_LOGICAL_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchReplaceClusterNodesResponse, T> g) {
        return obj -> g.apply((BatchReplaceClusterNodesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<String> successful = DefaultSdkAutoConstructList.getInstance();
        private List<BatchReplaceClusterNodesError> failed = DefaultSdkAutoConstructList.getInstance();
        private List<BatchReplaceClusterNodeLogicalIdsError> failedNodeLogicalIds = DefaultSdkAutoConstructList.getInstance();
        private List<String> successfulNodeLogicalIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchReplaceClusterNodesResponse model) {
            super(model);
            this.successful(model.successful);
            this.failed(model.failed);
            this.failedNodeLogicalIds(model.failedNodeLogicalIds);
            this.successfulNodeLogicalIds(model.successfulNodeLogicalIds);
        }

        public final Collection<String> getSuccessful() {
            if (this.successful instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successful;
        }

        public final void setSuccessful(Collection<String> successful) {
            this.successful = ClusterNodeIdsCopier.copy(successful);
        }

        @Override
        public final Builder successful(Collection<String> successful) {
            this.successful = ClusterNodeIdsCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(String ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        public final List<BatchReplaceClusterNodesError.Builder> getFailed() {
            List<BatchReplaceClusterNodesError.Builder> result = BatchReplaceClusterNodesErrorsCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<BatchReplaceClusterNodesError.BuilderImpl> failed) {
            this.failed = BatchReplaceClusterNodesErrorsCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<BatchReplaceClusterNodesError> failed) {
            this.failed = BatchReplaceClusterNodesErrorsCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(BatchReplaceClusterNodesError ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<BatchReplaceClusterNodesError.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (BatchReplaceClusterNodesError)((BatchReplaceClusterNodesError.Builder)BatchReplaceClusterNodesError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchReplaceClusterNodeLogicalIdsError.Builder> getFailedNodeLogicalIds() {
            List<BatchReplaceClusterNodeLogicalIdsError.Builder> result = BatchReplaceClusterNodeLogicalIdsErrorsCopier.copyToBuilder(this.failedNodeLogicalIds);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailedNodeLogicalIds(Collection<BatchReplaceClusterNodeLogicalIdsError.BuilderImpl> failedNodeLogicalIds) {
            this.failedNodeLogicalIds = BatchReplaceClusterNodeLogicalIdsErrorsCopier.copyFromBuilder(failedNodeLogicalIds);
        }

        @Override
        public final Builder failedNodeLogicalIds(Collection<BatchReplaceClusterNodeLogicalIdsError> failedNodeLogicalIds) {
            this.failedNodeLogicalIds = BatchReplaceClusterNodeLogicalIdsErrorsCopier.copy(failedNodeLogicalIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedNodeLogicalIds(BatchReplaceClusterNodeLogicalIdsError ... failedNodeLogicalIds) {
            this.failedNodeLogicalIds(Arrays.asList(failedNodeLogicalIds));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedNodeLogicalIds(Consumer<BatchReplaceClusterNodeLogicalIdsError.Builder> ... failedNodeLogicalIds) {
            this.failedNodeLogicalIds(Stream.of(failedNodeLogicalIds).map(c -> (BatchReplaceClusterNodeLogicalIdsError)((BatchReplaceClusterNodeLogicalIdsError.Builder)BatchReplaceClusterNodeLogicalIdsError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getSuccessfulNodeLogicalIds() {
            if (this.successfulNodeLogicalIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.successfulNodeLogicalIds;
        }

        public final void setSuccessfulNodeLogicalIds(Collection<String> successfulNodeLogicalIds) {
            this.successfulNodeLogicalIds = ClusterNodeLogicalIdListCopier.copy(successfulNodeLogicalIds);
        }

        @Override
        public final Builder successfulNodeLogicalIds(Collection<String> successfulNodeLogicalIds) {
            this.successfulNodeLogicalIds = ClusterNodeLogicalIdListCopier.copy(successfulNodeLogicalIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successfulNodeLogicalIds(String ... successfulNodeLogicalIds) {
            this.successfulNodeLogicalIds(Arrays.asList(successfulNodeLogicalIds));
            return this;
        }

        @Override
        public BatchReplaceClusterNodesResponse build() {
            return new BatchReplaceClusterNodesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchReplaceClusterNodesResponse> {
        public Builder successful(Collection<String> var1);

        public Builder successful(String ... var1);

        public Builder failed(Collection<BatchReplaceClusterNodesError> var1);

        public Builder failed(BatchReplaceClusterNodesError ... var1);

        public Builder failed(Consumer<BatchReplaceClusterNodesError.Builder> ... var1);

        public Builder failedNodeLogicalIds(Collection<BatchReplaceClusterNodeLogicalIdsError> var1);

        public Builder failedNodeLogicalIds(BatchReplaceClusterNodeLogicalIdsError ... var1);

        public Builder failedNodeLogicalIds(Consumer<BatchReplaceClusterNodeLogicalIdsError.Builder> ... var1);

        public Builder successfulNodeLogicalIds(Collection<String> var1);

        public Builder successfulNodeLogicalIds(String ... var1);
    }
}

