/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterEbsVolumeConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterEbsVolumeConfig> {
    private static final SdkField<Integer> VOLUME_SIZE_IN_GB_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VolumeSizeInGB").getter(ClusterEbsVolumeConfig.getter(ClusterEbsVolumeConfig::volumeSizeInGB)).setter(ClusterEbsVolumeConfig.setter(Builder::volumeSizeInGB)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeSizeInGB").build()}).build();
    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeKmsKeyId").getter(ClusterEbsVolumeConfig.getter(ClusterEbsVolumeConfig::volumeKmsKeyId)).setter(ClusterEbsVolumeConfig.setter(Builder::volumeKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()}).build();
    private static final SdkField<Boolean> ROOT_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("RootVolume").getter(ClusterEbsVolumeConfig.getter(ClusterEbsVolumeConfig::rootVolume)).setter(ClusterEbsVolumeConfig.setter(Builder::rootVolume)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RootVolume").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_SIZE_IN_GB_FIELD, VOLUME_KMS_KEY_ID_FIELD, ROOT_VOLUME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterEbsVolumeConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer volumeSizeInGB;
    private final String volumeKmsKeyId;
    private final Boolean rootVolume;

    private ClusterEbsVolumeConfig(BuilderImpl builder) {
        this.volumeSizeInGB = builder.volumeSizeInGB;
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.rootVolume = builder.rootVolume;
    }

    public final Integer volumeSizeInGB() {
        return this.volumeSizeInGB;
    }

    public final String volumeKmsKeyId() {
        return this.volumeKmsKeyId;
    }

    public final Boolean rootVolume() {
        return this.rootVolume;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeSizeInGB());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootVolume());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterEbsVolumeConfig)) {
            return false;
        }
        ClusterEbsVolumeConfig other = (ClusterEbsVolumeConfig)obj;
        return Objects.equals(this.volumeSizeInGB(), other.volumeSizeInGB()) && Objects.equals(this.volumeKmsKeyId(), other.volumeKmsKeyId()) && Objects.equals(this.rootVolume(), other.rootVolume());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterEbsVolumeConfig").add("VolumeSizeInGB", (Object)this.volumeSizeInGB()).add("VolumeKmsKeyId", (Object)this.volumeKmsKeyId()).add("RootVolume", (Object)this.rootVolume()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeSizeInGB": {
                return Optional.ofNullable(clazz.cast(this.volumeSizeInGB()));
            }
            case "VolumeKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.volumeKmsKeyId()));
            }
            case "RootVolume": {
                return Optional.ofNullable(clazz.cast(this.rootVolume()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VolumeSizeInGB", VOLUME_SIZE_IN_GB_FIELD);
        map.put("VolumeKmsKeyId", VOLUME_KMS_KEY_ID_FIELD);
        map.put("RootVolume", ROOT_VOLUME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterEbsVolumeConfig, T> g) {
        return obj -> g.apply((ClusterEbsVolumeConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer volumeSizeInGB;
        private String volumeKmsKeyId;
        private Boolean rootVolume;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterEbsVolumeConfig model) {
            this.volumeSizeInGB(model.volumeSizeInGB);
            this.volumeKmsKeyId(model.volumeKmsKeyId);
            this.rootVolume(model.rootVolume);
        }

        public final Integer getVolumeSizeInGB() {
            return this.volumeSizeInGB;
        }

        public final void setVolumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
        }

        @Override
        public final Builder volumeSizeInGB(Integer volumeSizeInGB) {
            this.volumeSizeInGB = volumeSizeInGB;
            return this;
        }

        public final String getVolumeKmsKeyId() {
            return this.volumeKmsKeyId;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final Boolean getRootVolume() {
            return this.rootVolume;
        }

        public final void setRootVolume(Boolean rootVolume) {
            this.rootVolume = rootVolume;
        }

        @Override
        public final Builder rootVolume(Boolean rootVolume) {
            this.rootVolume = rootVolume;
            return this;
        }

        public ClusterEbsVolumeConfig build() {
            return new ClusterEbsVolumeConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterEbsVolumeConfig> {
        public Builder volumeSizeInGB(Integer var1);

        public Builder volumeKmsKeyId(String var1);

        public Builder rootVolume(Boolean var1);
    }
}

