/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.EksRoleAccessEntriesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterMetadata> {
    private static final SdkField<String> FAILURE_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureMessage").getter(ClusterMetadata.getter(ClusterMetadata::failureMessage)).setter(ClusterMetadata.setter(Builder::failureMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureMessage").build()}).build();
    private static final SdkField<List<String>> EKS_ROLE_ACCESS_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("EksRoleAccessEntries").getter(ClusterMetadata.getter(ClusterMetadata::eksRoleAccessEntries)).setter(ClusterMetadata.setter(Builder::eksRoleAccessEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EksRoleAccessEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SLR_ACCESS_ENTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SlrAccessEntry").getter(ClusterMetadata.getter(ClusterMetadata::slrAccessEntry)).setter(ClusterMetadata.setter(Builder::slrAccessEntry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SlrAccessEntry").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILURE_MESSAGE_FIELD, EKS_ROLE_ACCESS_ENTRIES_FIELD, SLR_ACCESS_ENTRY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterMetadata.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String failureMessage;
    private final List<String> eksRoleAccessEntries;
    private final String slrAccessEntry;

    private ClusterMetadata(BuilderImpl builder) {
        this.failureMessage = builder.failureMessage;
        this.eksRoleAccessEntries = builder.eksRoleAccessEntries;
        this.slrAccessEntry = builder.slrAccessEntry;
    }

    public final String failureMessage() {
        return this.failureMessage;
    }

    public final boolean hasEksRoleAccessEntries() {
        return this.eksRoleAccessEntries != null && !(this.eksRoleAccessEntries instanceof SdkAutoConstructList);
    }

    public final List<String> eksRoleAccessEntries() {
        return this.eksRoleAccessEntries;
    }

    public final String slrAccessEntry() {
        return this.slrAccessEntry;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failureMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEksRoleAccessEntries() ? this.eksRoleAccessEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.slrAccessEntry());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterMetadata)) {
            return false;
        }
        ClusterMetadata other = (ClusterMetadata)obj;
        return Objects.equals(this.failureMessage(), other.failureMessage()) && this.hasEksRoleAccessEntries() == other.hasEksRoleAccessEntries() && Objects.equals(this.eksRoleAccessEntries(), other.eksRoleAccessEntries()) && Objects.equals(this.slrAccessEntry(), other.slrAccessEntry());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterMetadata").add("FailureMessage", (Object)this.failureMessage()).add("EksRoleAccessEntries", this.hasEksRoleAccessEntries() ? this.eksRoleAccessEntries() : null).add("SlrAccessEntry", (Object)this.slrAccessEntry()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailureMessage": {
                return Optional.ofNullable(clazz.cast(this.failureMessage()));
            }
            case "EksRoleAccessEntries": {
                return Optional.ofNullable(clazz.cast(this.eksRoleAccessEntries()));
            }
            case "SlrAccessEntry": {
                return Optional.ofNullable(clazz.cast(this.slrAccessEntry()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("FailureMessage", FAILURE_MESSAGE_FIELD);
        map.put("EksRoleAccessEntries", EKS_ROLE_ACCESS_ENTRIES_FIELD);
        map.put("SlrAccessEntry", SLR_ACCESS_ENTRY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterMetadata, T> g) {
        return obj -> g.apply((ClusterMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String failureMessage;
        private List<String> eksRoleAccessEntries = DefaultSdkAutoConstructList.getInstance();
        private String slrAccessEntry;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterMetadata model) {
            this.failureMessage(model.failureMessage);
            this.eksRoleAccessEntries(model.eksRoleAccessEntries);
            this.slrAccessEntry(model.slrAccessEntry);
        }

        public final String getFailureMessage() {
            return this.failureMessage;
        }

        public final void setFailureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
        }

        @Override
        public final Builder failureMessage(String failureMessage) {
            this.failureMessage = failureMessage;
            return this;
        }

        public final Collection<String> getEksRoleAccessEntries() {
            if (this.eksRoleAccessEntries instanceof SdkAutoConstructList) {
                return null;
            }
            return this.eksRoleAccessEntries;
        }

        public final void setEksRoleAccessEntries(Collection<String> eksRoleAccessEntries) {
            this.eksRoleAccessEntries = EksRoleAccessEntriesCopier.copy(eksRoleAccessEntries);
        }

        @Override
        public final Builder eksRoleAccessEntries(Collection<String> eksRoleAccessEntries) {
            this.eksRoleAccessEntries = EksRoleAccessEntriesCopier.copy(eksRoleAccessEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder eksRoleAccessEntries(String ... eksRoleAccessEntries) {
            this.eksRoleAccessEntries(Arrays.asList(eksRoleAccessEntries));
            return this;
        }

        public final String getSlrAccessEntry() {
            return this.slrAccessEntry;
        }

        public final void setSlrAccessEntry(String slrAccessEntry) {
            this.slrAccessEntry = slrAccessEntry;
        }

        @Override
        public final Builder slrAccessEntry(String slrAccessEntry) {
            this.slrAccessEntry = slrAccessEntry;
            return this;
        }

        public ClusterMetadata build() {
            return new ClusterMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterMetadata> {
        public Builder failureMessage(String var1);

        public Builder eksRoleAccessEntries(Collection<String> var1);

        public Builder eksRoleAccessEntries(String ... var1);

        public Builder slrAccessEntry(String var1);
    }
}

