/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ClusterConfigMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterTieredStorageConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterTieredStorageConfig> {
    private static final SdkField<String> MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Mode").getter(ClusterTieredStorageConfig.getter(ClusterTieredStorageConfig::modeAsString)).setter(ClusterTieredStorageConfig.setter(Builder::mode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mode").build()}).build();
    private static final SdkField<Integer> INSTANCE_MEMORY_ALLOCATION_PERCENTAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceMemoryAllocationPercentage").getter(ClusterTieredStorageConfig.getter(ClusterTieredStorageConfig::instanceMemoryAllocationPercentage)).setter(ClusterTieredStorageConfig.setter(Builder::instanceMemoryAllocationPercentage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceMemoryAllocationPercentage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD, INSTANCE_MEMORY_ALLOCATION_PERCENTAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterTieredStorageConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String mode;
    private final Integer instanceMemoryAllocationPercentage;

    private ClusterTieredStorageConfig(BuilderImpl builder) {
        this.mode = builder.mode;
        this.instanceMemoryAllocationPercentage = builder.instanceMemoryAllocationPercentage;
    }

    public final ClusterConfigMode mode() {
        return ClusterConfigMode.fromValue(this.mode);
    }

    public final String modeAsString() {
        return this.mode;
    }

    public final Integer instanceMemoryAllocationPercentage() {
        return this.instanceMemoryAllocationPercentage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMemoryAllocationPercentage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterTieredStorageConfig)) {
            return false;
        }
        ClusterTieredStorageConfig other = (ClusterTieredStorageConfig)obj;
        return Objects.equals(this.modeAsString(), other.modeAsString()) && Objects.equals(this.instanceMemoryAllocationPercentage(), other.instanceMemoryAllocationPercentage());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterTieredStorageConfig").add("Mode", (Object)this.modeAsString()).add("InstanceMemoryAllocationPercentage", (Object)this.instanceMemoryAllocationPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Mode": {
                return Optional.ofNullable(clazz.cast(this.modeAsString()));
            }
            case "InstanceMemoryAllocationPercentage": {
                return Optional.ofNullable(clazz.cast(this.instanceMemoryAllocationPercentage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Mode", MODE_FIELD);
        map.put("InstanceMemoryAllocationPercentage", INSTANCE_MEMORY_ALLOCATION_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterTieredStorageConfig, T> g) {
        return obj -> g.apply((ClusterTieredStorageConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String mode;
        private Integer instanceMemoryAllocationPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterTieredStorageConfig model) {
            this.mode(model.mode);
            this.instanceMemoryAllocationPercentage(model.instanceMemoryAllocationPercentage);
        }

        public final String getMode() {
            return this.mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ClusterConfigMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final Integer getInstanceMemoryAllocationPercentage() {
            return this.instanceMemoryAllocationPercentage;
        }

        public final void setInstanceMemoryAllocationPercentage(Integer instanceMemoryAllocationPercentage) {
            this.instanceMemoryAllocationPercentage = instanceMemoryAllocationPercentage;
        }

        @Override
        public final Builder instanceMemoryAllocationPercentage(Integer instanceMemoryAllocationPercentage) {
            this.instanceMemoryAllocationPercentage = instanceMemoryAllocationPercentage;
            return this;
        }

        public ClusterTieredStorageConfig build() {
            return new ClusterTieredStorageConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterTieredStorageConfig> {
        public Builder mode(String var1);

        public Builder mode(ClusterConfigMode var1);

        public Builder instanceMemoryAllocationPercentage(Integer var1);
    }
}

