/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AuthorizedUrl;
import software.amazon.awssdk.services.sagemaker.model.AuthorizedUrlConfigsCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateHubContentPresignedUrlsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, CreateHubContentPresignedUrlsResponse> {
    private static final SdkField<List<AuthorizedUrl>> AUTHORIZED_URL_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AuthorizedUrlConfigs").getter(CreateHubContentPresignedUrlsResponse.getter(CreateHubContentPresignedUrlsResponse::authorizedUrlConfigs)).setter(CreateHubContentPresignedUrlsResponse.setter(Builder::authorizedUrlConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorizedUrlConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthorizedUrl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(CreateHubContentPresignedUrlsResponse.getter(CreateHubContentPresignedUrlsResponse::nextToken)).setter(CreateHubContentPresignedUrlsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZED_URL_CONFIGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateHubContentPresignedUrlsResponse.memberNameToFieldInitializer();
    private final List<AuthorizedUrl> authorizedUrlConfigs;
    private final String nextToken;

    private CreateHubContentPresignedUrlsResponse(BuilderImpl builder) {
        super(builder);
        this.authorizedUrlConfigs = builder.authorizedUrlConfigs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAuthorizedUrlConfigs() {
        return this.authorizedUrlConfigs != null && !(this.authorizedUrlConfigs instanceof SdkAutoConstructList);
    }

    public final List<AuthorizedUrl> authorizedUrlConfigs() {
        return this.authorizedUrlConfigs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizedUrlConfigs() ? this.authorizedUrlConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateHubContentPresignedUrlsResponse)) {
            return false;
        }
        CreateHubContentPresignedUrlsResponse other = (CreateHubContentPresignedUrlsResponse)((Object)obj);
        return this.hasAuthorizedUrlConfigs() == other.hasAuthorizedUrlConfigs() && Objects.equals(this.authorizedUrlConfigs(), other.authorizedUrlConfigs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateHubContentPresignedUrlsResponse").add("AuthorizedUrlConfigs", this.hasAuthorizedUrlConfigs() ? this.authorizedUrlConfigs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AuthorizedUrlConfigs": {
                return Optional.ofNullable(clazz.cast(this.authorizedUrlConfigs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AuthorizedUrlConfigs", AUTHORIZED_URL_CONFIGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateHubContentPresignedUrlsResponse, T> g) {
        return obj -> g.apply((CreateHubContentPresignedUrlsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<AuthorizedUrl> authorizedUrlConfigs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateHubContentPresignedUrlsResponse model) {
            super(model);
            this.authorizedUrlConfigs(model.authorizedUrlConfigs);
            this.nextToken(model.nextToken);
        }

        public final List<AuthorizedUrl.Builder> getAuthorizedUrlConfigs() {
            List<AuthorizedUrl.Builder> result = AuthorizedUrlConfigsCopier.copyToBuilder(this.authorizedUrlConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizedUrlConfigs(Collection<AuthorizedUrl.BuilderImpl> authorizedUrlConfigs) {
            this.authorizedUrlConfigs = AuthorizedUrlConfigsCopier.copyFromBuilder(authorizedUrlConfigs);
        }

        @Override
        public final Builder authorizedUrlConfigs(Collection<AuthorizedUrl> authorizedUrlConfigs) {
            this.authorizedUrlConfigs = AuthorizedUrlConfigsCopier.copy(authorizedUrlConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedUrlConfigs(AuthorizedUrl ... authorizedUrlConfigs) {
            this.authorizedUrlConfigs(Arrays.asList(authorizedUrlConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizedUrlConfigs(Consumer<AuthorizedUrl.Builder> ... authorizedUrlConfigs) {
            this.authorizedUrlConfigs(Stream.of(authorizedUrlConfigs).map(c -> (AuthorizedUrl)((AuthorizedUrl.Builder)AuthorizedUrl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public CreateHubContentPresignedUrlsResponse build() {
            return new CreateHubContentPresignedUrlsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateHubContentPresignedUrlsResponse> {
        public Builder authorizedUrlConfigs(Collection<AuthorizedUrl> var1);

        public Builder authorizedUrlConfigs(AuthorizedUrl ... var1);

        public Builder authorizedUrlConfigs(Consumer<AuthorizedUrl.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

