/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.OwnershipSettings;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SpaceSettings;
import software.amazon.awssdk.services.sagemaker.model.SpaceSharingSettings;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateSpaceRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateSpaceRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(CreateSpaceRequest.getter(CreateSpaceRequest::domainId)).setter(CreateSpaceRequest.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpaceName").getter(CreateSpaceRequest.getter(CreateSpaceRequest::spaceName)).setter(CreateSpaceRequest.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateSpaceRequest.getter(CreateSpaceRequest::tags)).setter(CreateSpaceRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SpaceSettings> SPACE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpaceSettings").getter(CreateSpaceRequest.getter(CreateSpaceRequest::spaceSettings)).setter(CreateSpaceRequest.setter(Builder::spaceSettings)).constructor(SpaceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSettings").build()}).build();
    private static final SdkField<OwnershipSettings> OWNERSHIP_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OwnershipSettings").getter(CreateSpaceRequest.getter(CreateSpaceRequest::ownershipSettings)).setter(CreateSpaceRequest.setter(Builder::ownershipSettings)).constructor(OwnershipSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnershipSettings").build()}).build();
    private static final SdkField<SpaceSharingSettings> SPACE_SHARING_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpaceSharingSettings").getter(CreateSpaceRequest.getter(CreateSpaceRequest::spaceSharingSettings)).setter(CreateSpaceRequest.setter(Builder::spaceSharingSettings)).constructor(SpaceSharingSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSharingSettings").build()}).build();
    private static final SdkField<String> SPACE_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpaceDisplayName").getter(CreateSpaceRequest.getter(CreateSpaceRequest::spaceDisplayName)).setter(CreateSpaceRequest.setter(Builder::spaceDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceDisplayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, SPACE_NAME_FIELD, TAGS_FIELD, SPACE_SETTINGS_FIELD, OWNERSHIP_SETTINGS_FIELD, SPACE_SHARING_SETTINGS_FIELD, SPACE_DISPLAY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateSpaceRequest.memberNameToFieldInitializer();
    private final String domainId;
    private final String spaceName;
    private final List<Tag> tags;
    private final SpaceSettings spaceSettings;
    private final OwnershipSettings ownershipSettings;
    private final SpaceSharingSettings spaceSharingSettings;
    private final String spaceDisplayName;

    private CreateSpaceRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.spaceName = builder.spaceName;
        this.tags = builder.tags;
        this.spaceSettings = builder.spaceSettings;
        this.ownershipSettings = builder.ownershipSettings;
        this.spaceSharingSettings = builder.spaceSharingSettings;
        this.spaceDisplayName = builder.spaceDisplayName;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final SpaceSettings spaceSettings() {
        return this.spaceSettings;
    }

    public final OwnershipSettings ownershipSettings() {
        return this.ownershipSettings;
    }

    public final SpaceSharingSettings spaceSharingSettings() {
        return this.spaceSharingSettings;
    }

    public final String spaceDisplayName() {
        return this.spaceDisplayName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownershipSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceSharingSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceDisplayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSpaceRequest)) {
            return false;
        }
        CreateSpaceRequest other = (CreateSpaceRequest)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.spaceName(), other.spaceName()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.spaceSettings(), other.spaceSettings()) && Objects.equals(this.ownershipSettings(), other.ownershipSettings()) && Objects.equals(this.spaceSharingSettings(), other.spaceSharingSettings()) && Objects.equals(this.spaceDisplayName(), other.spaceDisplayName());
    }

    public final String toString() {
        return ToString.builder((String)"CreateSpaceRequest").add("DomainId", (Object)this.domainId()).add("SpaceName", (Object)this.spaceName()).add("Tags", this.hasTags() ? this.tags() : null).add("SpaceSettings", (Object)this.spaceSettings()).add("OwnershipSettings", (Object)this.ownershipSettings()).add("SpaceSharingSettings", (Object)this.spaceSharingSettings()).add("SpaceDisplayName", (Object)this.spaceDisplayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "SpaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "SpaceSettings": {
                return Optional.ofNullable(clazz.cast(this.spaceSettings()));
            }
            case "OwnershipSettings": {
                return Optional.ofNullable(clazz.cast(this.ownershipSettings()));
            }
            case "SpaceSharingSettings": {
                return Optional.ofNullable(clazz.cast(this.spaceSharingSettings()));
            }
            case "SpaceDisplayName": {
                return Optional.ofNullable(clazz.cast(this.spaceDisplayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DomainId", DOMAIN_ID_FIELD);
        map.put("SpaceName", SPACE_NAME_FIELD);
        map.put("Tags", TAGS_FIELD);
        map.put("SpaceSettings", SPACE_SETTINGS_FIELD);
        map.put("OwnershipSettings", OWNERSHIP_SETTINGS_FIELD);
        map.put("SpaceSharingSettings", SPACE_SHARING_SETTINGS_FIELD);
        map.put("SpaceDisplayName", SPACE_DISPLAY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSpaceRequest, T> g) {
        return obj -> g.apply((CreateSpaceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String domainId;
        private String spaceName;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private SpaceSettings spaceSettings;
        private OwnershipSettings ownershipSettings;
        private SpaceSharingSettings spaceSharingSettings;
        private String spaceDisplayName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSpaceRequest model) {
            super(model);
            this.domainId(model.domainId);
            this.spaceName(model.spaceName);
            this.tags(model.tags);
            this.spaceSettings(model.spaceSettings);
            this.ownershipSettings(model.ownershipSettings);
            this.spaceSharingSettings(model.spaceSharingSettings);
            this.spaceDisplayName(model.spaceDisplayName);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final SpaceSettings.Builder getSpaceSettings() {
            return this.spaceSettings != null ? this.spaceSettings.toBuilder() : null;
        }

        public final void setSpaceSettings(SpaceSettings.BuilderImpl spaceSettings) {
            this.spaceSettings = spaceSettings != null ? spaceSettings.build() : null;
        }

        @Override
        public final Builder spaceSettings(SpaceSettings spaceSettings) {
            this.spaceSettings = spaceSettings;
            return this;
        }

        public final OwnershipSettings.Builder getOwnershipSettings() {
            return this.ownershipSettings != null ? this.ownershipSettings.toBuilder() : null;
        }

        public final void setOwnershipSettings(OwnershipSettings.BuilderImpl ownershipSettings) {
            this.ownershipSettings = ownershipSettings != null ? ownershipSettings.build() : null;
        }

        @Override
        public final Builder ownershipSettings(OwnershipSettings ownershipSettings) {
            this.ownershipSettings = ownershipSettings;
            return this;
        }

        public final SpaceSharingSettings.Builder getSpaceSharingSettings() {
            return this.spaceSharingSettings != null ? this.spaceSharingSettings.toBuilder() : null;
        }

        public final void setSpaceSharingSettings(SpaceSharingSettings.BuilderImpl spaceSharingSettings) {
            this.spaceSharingSettings = spaceSharingSettings != null ? spaceSharingSettings.build() : null;
        }

        @Override
        public final Builder spaceSharingSettings(SpaceSharingSettings spaceSharingSettings) {
            this.spaceSharingSettings = spaceSharingSettings;
            return this;
        }

        public final String getSpaceDisplayName() {
            return this.spaceDisplayName;
        }

        public final void setSpaceDisplayName(String spaceDisplayName) {
            this.spaceDisplayName = spaceDisplayName;
        }

        @Override
        public final Builder spaceDisplayName(String spaceDisplayName) {
            this.spaceDisplayName = spaceDisplayName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSpaceRequest build() {
            return new CreateSpaceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateSpaceRequest> {
        public Builder domainId(String var1);

        public Builder spaceName(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder spaceSettings(SpaceSettings var1);

        default public Builder spaceSettings(Consumer<SpaceSettings.Builder> spaceSettings) {
            return this.spaceSettings((SpaceSettings)((SpaceSettings.Builder)SpaceSettings.builder().applyMutation(spaceSettings)).build());
        }

        public Builder ownershipSettings(OwnershipSettings var1);

        default public Builder ownershipSettings(Consumer<OwnershipSettings.Builder> ownershipSettings) {
            return this.ownershipSettings((OwnershipSettings)((OwnershipSettings.Builder)OwnershipSettings.builder().applyMutation(ownershipSettings)).build());
        }

        public Builder spaceSharingSettings(SpaceSharingSettings var1);

        default public Builder spaceSharingSettings(Consumer<SpaceSharingSettings.Builder> spaceSharingSettings) {
            return this.spaceSharingSettings((SpaceSharingSettings)((SpaceSharingSettings.Builder)SpaceSharingSettings.builder().applyMutation(spaceSharingSettings)).build());
        }

        public Builder spaceDisplayName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

