/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HubSearchKeywordListCopier;
import software.amazon.awssdk.services.sagemaker.model.HubStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HubInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HubInfo> {
    private static final SdkField<String> HUB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubName").getter(HubInfo.getter(HubInfo::hubName)).setter(HubInfo.setter(Builder::hubName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubName").build()}).build();
    private static final SdkField<String> HUB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubArn").getter(HubInfo.getter(HubInfo::hubArn)).setter(HubInfo.setter(Builder::hubArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubArn").build()}).build();
    private static final SdkField<String> HUB_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubDisplayName").getter(HubInfo.getter(HubInfo::hubDisplayName)).setter(HubInfo.setter(Builder::hubDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDisplayName").build()}).build();
    private static final SdkField<String> HUB_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubDescription").getter(HubInfo.getter(HubInfo::hubDescription)).setter(HubInfo.setter(Builder::hubDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubDescription").build()}).build();
    private static final SdkField<List<String>> HUB_SEARCH_KEYWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HubSearchKeywords").getter(HubInfo.getter(HubInfo::hubSearchKeywords)).setter(HubInfo.setter(Builder::hubSearchKeywords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubSearchKeywords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> HUB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HubStatus").getter(HubInfo.getter(HubInfo::hubStatusAsString)).setter(HubInfo.setter(Builder::hubStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(HubInfo.getter(HubInfo::creationTime)).setter(HubInfo.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(HubInfo.getter(HubInfo::lastModifiedTime)).setter(HubInfo.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_NAME_FIELD, HUB_ARN_FIELD, HUB_DISPLAY_NAME_FIELD, HUB_DESCRIPTION_FIELD, HUB_SEARCH_KEYWORDS_FIELD, HUB_STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HubInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String hubName;
    private final String hubArn;
    private final String hubDisplayName;
    private final String hubDescription;
    private final List<String> hubSearchKeywords;
    private final String hubStatus;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private HubInfo(BuilderImpl builder) {
        this.hubName = builder.hubName;
        this.hubArn = builder.hubArn;
        this.hubDisplayName = builder.hubDisplayName;
        this.hubDescription = builder.hubDescription;
        this.hubSearchKeywords = builder.hubSearchKeywords;
        this.hubStatus = builder.hubStatus;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public final String hubName() {
        return this.hubName;
    }

    public final String hubArn() {
        return this.hubArn;
    }

    public final String hubDisplayName() {
        return this.hubDisplayName;
    }

    public final String hubDescription() {
        return this.hubDescription;
    }

    public final boolean hasHubSearchKeywords() {
        return this.hubSearchKeywords != null && !(this.hubSearchKeywords instanceof SdkAutoConstructList);
    }

    public final List<String> hubSearchKeywords() {
        return this.hubSearchKeywords;
    }

    public final HubStatus hubStatus() {
        return HubStatus.fromValue(this.hubStatus);
    }

    public final String hubStatusAsString() {
        return this.hubStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hubName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hubDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHubSearchKeywords() ? this.hubSearchKeywords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hubStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HubInfo)) {
            return false;
        }
        HubInfo other = (HubInfo)obj;
        return Objects.equals(this.hubName(), other.hubName()) && Objects.equals(this.hubArn(), other.hubArn()) && Objects.equals(this.hubDisplayName(), other.hubDisplayName()) && Objects.equals(this.hubDescription(), other.hubDescription()) && this.hasHubSearchKeywords() == other.hasHubSearchKeywords() && Objects.equals(this.hubSearchKeywords(), other.hubSearchKeywords()) && Objects.equals(this.hubStatusAsString(), other.hubStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public final String toString() {
        return ToString.builder((String)"HubInfo").add("HubName", (Object)this.hubName()).add("HubArn", (Object)this.hubArn()).add("HubDisplayName", (Object)this.hubDisplayName()).add("HubDescription", (Object)this.hubDescription()).add("HubSearchKeywords", this.hasHubSearchKeywords() ? this.hubSearchKeywords() : null).add("HubStatus", (Object)this.hubStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubName": {
                return Optional.ofNullable(clazz.cast(this.hubName()));
            }
            case "HubArn": {
                return Optional.ofNullable(clazz.cast(this.hubArn()));
            }
            case "HubDisplayName": {
                return Optional.ofNullable(clazz.cast(this.hubDisplayName()));
            }
            case "HubDescription": {
                return Optional.ofNullable(clazz.cast(this.hubDescription()));
            }
            case "HubSearchKeywords": {
                return Optional.ofNullable(clazz.cast(this.hubSearchKeywords()));
            }
            case "HubStatus": {
                return Optional.ofNullable(clazz.cast(this.hubStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("HubName", HUB_NAME_FIELD);
        map.put("HubArn", HUB_ARN_FIELD);
        map.put("HubDisplayName", HUB_DISPLAY_NAME_FIELD);
        map.put("HubDescription", HUB_DESCRIPTION_FIELD);
        map.put("HubSearchKeywords", HUB_SEARCH_KEYWORDS_FIELD);
        map.put("HubStatus", HUB_STATUS_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HubInfo, T> g) {
        return obj -> g.apply((HubInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String hubName;
        private String hubArn;
        private String hubDisplayName;
        private String hubDescription;
        private List<String> hubSearchKeywords = DefaultSdkAutoConstructList.getInstance();
        private String hubStatus;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(HubInfo model) {
            this.hubName(model.hubName);
            this.hubArn(model.hubArn);
            this.hubDisplayName(model.hubDisplayName);
            this.hubDescription(model.hubDescription);
            this.hubSearchKeywords(model.hubSearchKeywords);
            this.hubStatus(model.hubStatus);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getHubName() {
            return this.hubName;
        }

        public final void setHubName(String hubName) {
            this.hubName = hubName;
        }

        @Override
        public final Builder hubName(String hubName) {
            this.hubName = hubName;
            return this;
        }

        public final String getHubArn() {
            return this.hubArn;
        }

        public final void setHubArn(String hubArn) {
            this.hubArn = hubArn;
        }

        @Override
        public final Builder hubArn(String hubArn) {
            this.hubArn = hubArn;
            return this;
        }

        public final String getHubDisplayName() {
            return this.hubDisplayName;
        }

        public final void setHubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
        }

        @Override
        public final Builder hubDisplayName(String hubDisplayName) {
            this.hubDisplayName = hubDisplayName;
            return this;
        }

        public final String getHubDescription() {
            return this.hubDescription;
        }

        public final void setHubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
        }

        @Override
        public final Builder hubDescription(String hubDescription) {
            this.hubDescription = hubDescription;
            return this;
        }

        public final Collection<String> getHubSearchKeywords() {
            if (this.hubSearchKeywords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hubSearchKeywords;
        }

        public final void setHubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
        }

        @Override
        public final Builder hubSearchKeywords(Collection<String> hubSearchKeywords) {
            this.hubSearchKeywords = HubSearchKeywordListCopier.copy(hubSearchKeywords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubSearchKeywords(String ... hubSearchKeywords) {
            this.hubSearchKeywords(Arrays.asList(hubSearchKeywords));
            return this;
        }

        public final String getHubStatus() {
            return this.hubStatus;
        }

        public final void setHubStatus(String hubStatus) {
            this.hubStatus = hubStatus;
        }

        @Override
        public final Builder hubStatus(String hubStatus) {
            this.hubStatus = hubStatus;
            return this;
        }

        @Override
        public final Builder hubStatus(HubStatus hubStatus) {
            this.hubStatus(hubStatus == null ? null : hubStatus.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public HubInfo build() {
            return new HubInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HubInfo> {
        public Builder hubName(String var1);

        public Builder hubArn(String var1);

        public Builder hubDisplayName(String var1);

        public Builder hubDescription(String var1);

        public Builder hubSearchKeywords(Collection<String> var1);

        public Builder hubSearchKeywords(String ... var1);

        public Builder hubStatus(String var1);

        public Builder hubStatus(HubStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

