/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummary;
import software.amazon.awssdk.services.sagemaker.model.NotebookInstanceSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListNotebookInstancesResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListNotebookInstancesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListNotebookInstancesResponse.getter(ListNotebookInstancesResponse::nextToken)).setter(ListNotebookInstancesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<NotebookInstanceSummary>> NOTEBOOK_INSTANCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NotebookInstances").getter(ListNotebookInstancesResponse.getter(ListNotebookInstancesResponse::notebookInstances)).setter(ListNotebookInstancesResponse.setter(Builder::notebookInstances)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotebookInstances").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NotebookInstanceSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NOTEBOOK_INSTANCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListNotebookInstancesResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<NotebookInstanceSummary> notebookInstances;

    private ListNotebookInstancesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.notebookInstances = builder.notebookInstances;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasNotebookInstances() {
        return this.notebookInstances != null && !(this.notebookInstances instanceof SdkAutoConstructList);
    }

    public final List<NotebookInstanceSummary> notebookInstances() {
        return this.notebookInstances;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNotebookInstances() ? this.notebookInstances() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNotebookInstancesResponse)) {
            return false;
        }
        ListNotebookInstancesResponse other = (ListNotebookInstancesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasNotebookInstances() == other.hasNotebookInstances() && Objects.equals(this.notebookInstances(), other.notebookInstances());
    }

    public final String toString() {
        return ToString.builder((String)"ListNotebookInstancesResponse").add("NextToken", (Object)this.nextToken()).add("NotebookInstances", this.hasNotebookInstances() ? this.notebookInstances() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "NotebookInstances": {
                return Optional.ofNullable(clazz.cast(this.notebookInstances()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("NotebookInstances", NOTEBOOK_INSTANCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListNotebookInstancesResponse, T> g) {
        return obj -> g.apply((ListNotebookInstancesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<NotebookInstanceSummary> notebookInstances = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListNotebookInstancesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.notebookInstances(model.notebookInstances);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<NotebookInstanceSummary.Builder> getNotebookInstances() {
            List<NotebookInstanceSummary.Builder> result = NotebookInstanceSummaryListCopier.copyToBuilder(this.notebookInstances);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNotebookInstances(Collection<NotebookInstanceSummary.BuilderImpl> notebookInstances) {
            this.notebookInstances = NotebookInstanceSummaryListCopier.copyFromBuilder(notebookInstances);
        }

        @Override
        public final Builder notebookInstances(Collection<NotebookInstanceSummary> notebookInstances) {
            this.notebookInstances = NotebookInstanceSummaryListCopier.copy(notebookInstances);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookInstances(NotebookInstanceSummary ... notebookInstances) {
            this.notebookInstances(Arrays.asList(notebookInstances));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder notebookInstances(Consumer<NotebookInstanceSummary.Builder> ... notebookInstances) {
            this.notebookInstances(Stream.of(notebookInstances).map(c -> (NotebookInstanceSummary)((NotebookInstanceSummary.Builder)NotebookInstanceSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListNotebookInstancesResponse build() {
            return new ListNotebookInstancesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListNotebookInstancesResponse> {
        public Builder nextToken(String var1);

        public Builder notebookInstances(Collection<NotebookInstanceSummary> var1);

        public Builder notebookInstances(NotebookInstanceSummary ... var1);

        public Builder notebookInstances(Consumer<NotebookInstanceSummary.Builder> ... var1);
    }
}

