/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelCompressionType {
    NONE("None"),
    GZIP("Gzip"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelCompressionType> VALUE_MAP;
    private final String value;

    private ModelCompressionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelCompressionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelCompressionType> knownValues() {
        EnumSet<ModelCompressionType> knownValues = EnumSet.allOf(ModelCompressionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelCompressionType.class, ModelCompressionType::toString);
    }
}

