/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ModelPackageRegistrationType {
    LOGGED("Logged"),
    REGISTERED("Registered"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ModelPackageRegistrationType> VALUE_MAP;
    private final String value;

    private ModelPackageRegistrationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ModelPackageRegistrationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ModelPackageRegistrationType> knownValues() {
        EnumSet<ModelPackageRegistrationType> knownValues = EnumSet.allOf(ModelPackageRegistrationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ModelPackageRegistrationType.class, ModelPackageRegistrationType::toString);
    }
}

