/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NodeUnavailabilityType {
    INSTANCE_COUNT("INSTANCE_COUNT"),
    CAPACITY_PERCENTAGE("CAPACITY_PERCENTAGE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NodeUnavailabilityType> VALUE_MAP;
    private final String value;

    private NodeUnavailabilityType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NodeUnavailabilityType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NodeUnavailabilityType> knownValues() {
        EnumSet<NodeUnavailabilityType> knownValues = EnumSet.allOf(NodeUnavailabilityType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NodeUnavailabilityType.class, NodeUnavailabilityType::toString);
    }
}

